/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.tools.examinesupportdata;

import com.pingidentity.csd.server.util.StaticUtils;
import com.pingidentity.csd.tools.examinesupportdata.SupportDataArchive;
import com.pingidentity.csd.tools.examinesupportdata.SupportDataExaminer;
import com.unboundid.csd.messages.UBIDExaminerMessages;
import com.unboundid.messages.Category;
import com.unboundid.messages.Message;
import com.unboundid.messages.Severity;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class VersionExaminer
extends SupportDataExaminer {
    @Override
    public String getTitle() {
        return "Version Data Analysis";
    }

    @Override
    public List<Category> getCategories() {
        return Arrays.asList(Category.VERSION);
    }

    @Override
    public Message getExplanation() {
        return UBIDExaminerMessages.INFO_VERSION_EXPLANATION.get();
    }

    @Override
    public SupportDataExaminer.Result examine(SupportDataArchive sda) {
        SupportDataExaminer.Result result = new SupportDataExaminer.Result(this);
        try {
            String fixIds;
            Map<String, String> versionMap = SupportDataArchive.createMapFromInputStream(sda.getServerFile("full-version"), "^([^:]+):\\s*(.+)\\s*$");
            String versionQualifier = versionMap.get("Version Qualifier");
            if (versionQualifier != null && !versionQualifier.isEmpty()) {
                result.setSeverity(Severity.NOTICE);
                result.writeln("Version Qualifier detected: " + versionQualifier);
            }
            if ((fixIds = versionMap.get("Fix IDs")) != null && !fixIds.isEmpty()) {
                result.setSeverity(Severity.NOTICE);
                result.writeln("Fix IDs detected: " + fixIds);
            }
        }
        catch (Exception ex) {
            this.log("Exception occurred while displaying full-version: " + StaticUtils.stackTraceToSingleLineString(ex));
        }
        return result;
    }
}

