/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.appserver.jetty;

import com.pingidentity.configservice.SysDirInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.util.IO;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.servlet.filter.ResponseHeaderHelper;

public class PFDefaultHandler
extends AbstractHandler {
    private static final Log log = LogFactory.getLog(PFDefaultHandler.class);
    private static File favicon;
    private static byte[] faviconData;

    public PFDefaultHandler() {
        SysDirInfo sysDirInfo = (SysDirInfo)GlobalRegistry.getService(SysDirInfo.class);
        String faviconPath = sysDirInfo.getImagesDir() + File.separator + "favicon.ico";
        favicon = new File(faviconPath);
        if (favicon.exists()) {
            try (FileInputStream is = FileUtils.openInputStream((File)favicon);){
                faviconData = IO.readBytes((InputStream)is);
            }
            catch (IOException e) {
                faviconData = null;
                log.warn((Object)("Error reading favicon data from " + favicon.getAbsolutePath() + ". Favicons for runtime will be disabled."));
            }
        } else {
            log.warn((Object)("No favicon found at " + favicon.getAbsolutePath() + ". Favicons for runtime will be disabled."));
        }
    }

    public void handle(String s, Request request, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        if (httpServletResponse.isCommitted() || request.isHandled()) {
            return;
        }
        if (faviconData != null && request.getPathInfo() != null && request.getPathInfo().equals("/favicon.ico")) {
            ConfigStore store = ConfigStoreFarm.getConfig((String)"response-header-runtime-config");
            log.debug((Object)("Found request for favicon.ico. Intercepting and returning favicon from " + favicon.getAbsolutePath()));
            request.setHandled(true);
            httpServletResponse.setStatus(200);
            httpServletResponse.setContentType("image/x-icon");
            httpServletResponse.setContentLength(faviconData.length);
            httpServletResponse.setDateHeader(HttpHeader.LAST_MODIFIED.toString(), favicon.lastModified());
            ResponseHeaderHelper.getInstance((String)"response-header-runtime-config").setResponseHeaders(httpServletRequest, httpServletResponse, store);
            httpServletResponse.getOutputStream().write(faviconData);
        }
    }
}

