/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.appserver.jetty;

import com.pingidentity.sdk.api.authn.common.CommonErrorSpec;
import com.pingidentity.sdk.api.authn.util.AuthnApiSupport;
import com.pingidentity.sdk.template.TemplateRendererUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Optional;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.server.Dispatcher;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.wwwauth.AccessTokenUtil;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.local.MetadataLocal;
import org.sourceid.util.BaseUrlUtil;
import org.sourceid.util.log.internal.HttpRequestLoggingUtil;

public class PFRuntimeErrorHandler
extends ErrorPageErrorHandler {
    private static final Logger LOG = Log.getLogger(PFRuntimeErrorHandler.class);
    private static final String REQUEST_ERROR_ATTR_NAME = "javax.servlet.error.message";
    String _cacheControl = "must-revalidate,no-cache,no-store";
    private static AuthzServerManager authzServerManager = MgmtFactory.getAuthzServerManager();
    private static MetadataLocal metadataLocal = MetaDataFactory.getLocalMetaData();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            HttpRequestLoggingUtil.init((HttpServletRequest)request);
            String method = request.getMethod();
            if (!(HttpMethod.GET.is(method) || HttpMethod.POST.is(method) || HttpMethod.HEAD.is(method))) {
                baseRequest.setHandled(true);
                return;
            }
            if (authzServerManager.isEnableOAuth() && HttpMethod.GET.is(method) && StringUtils.isNotBlank((String)authzServerManager.getRegisteredAuthzPath()) && request.getRequestURI().equals(request.getContextPath() + authzServerManager.getRegisteredAuthzPath())) {
                String baseUrl = metadataLocal.getBaseUrl();
                String currentBaseUrl = BaseUrlUtil.getCurrentBaseUrl((String)baseUrl);
                StringBuilder redirectToUserAuthz = new StringBuilder();
                redirectToUserAuthz.append(currentBaseUrl).append("/as/user_authz.oauth2");
                if (request.getQueryString() != null) {
                    redirectToUserAuthz.append("?").append(request.getQueryString());
                }
                response.sendRedirect(redirectToUserAuthz.toString());
                return;
            }
            if (this instanceof ErrorHandler.ErrorPageMapper) {
                String old_error_page;
                String error_page = this.getErrorPage(request);
                ContextHandler.Context errorContext = ((Request)request).getErrorContext();
                if (!(error_page == null || errorContext == null || (old_error_page = (String)request.getAttribute("org.eclipse.jetty.server.error_page")) != null && old_error_page.equals(error_page))) {
                    block19: {
                        request.setAttribute("org.eclipse.jetty.server.error_page", (Object)error_page);
                        Dispatcher dispatcher = (Dispatcher)errorContext.getRequestDispatcher(error_page);
                        response.setHeader("Cache-Control", "no-cache, no-store");
                        try {
                            if (dispatcher == null) break block19;
                            dispatcher.error((ServletRequest)request, (ServletResponse)response);
                            return;
                        }
                        catch (ServletException e) {
                            LOG.warn("EXCEPTION", (Throwable)e);
                            HttpRequestLoggingUtil.cleanup();
                            return;
                        }
                    }
                    LOG.warn("No error page " + error_page, new Object[0]);
                }
            }
            baseRequest.setHandled(true);
            String contentType = AccessTokenUtil.getErrorResponseContentType((HttpServletRequest)request);
            if (contentType != null) {
                response.setContentType(contentType);
            } else {
                response.setContentType(MimeTypes.Type.TEXT_HTML_UTF_8.asString());
            }
            if (this._cacheControl != null) {
                response.setHeader(HttpHeader.CACHE_CONTROL.asString(), this._cacheControl);
            }
            PrintWriter writer = response.getWriter();
            String reason = null;
            if (response instanceof Response) {
                Optional<Object> reqError = Optional.ofNullable(((Response)response).getHttpChannel()).map(HttpChannel::getRequest).map(req -> req.getAttribute(REQUEST_ERROR_ATTR_NAME));
                reason = reqError.map(Object::toString).orElse(null);
                ((Response)response).setStatusWithReason(response.getStatus(), reason);
            }
            this.writeErrorPage(request, reason, response);
            ((Writer)writer).flush();
        }
        finally {
            HttpRequestLoggingUtil.cleanup();
        }
    }

    private void writeErrorPage(HttpServletRequest request, String message, HttpServletResponse response) throws IOException {
        if (message == null) {
            message = HttpStatus.getMessage((int)response.getStatus());
        }
        if (AuthnApiSupport.getDefault().isApiRequest(request)) {
            AuthnApiSupport.getDefault().writeErrorResponse(request, response, CommonErrorSpec.INVALID_REQUEST.makeInstanceBuilder().message(message).build());
        } else if (MimeTypes.Type.APPLICATION_JSON.asString().equals(response.getContentType())) {
            String responseText = String.format("{\"status\":%s, \"message\":\"%s\"}", response.getStatus(), message);
            response.getWriter().write(responseText);
        } else {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("errorCode", response.getStatus());
            params.put("message", message);
            TemplateRendererUtil.render((HttpServletRequest)request, (HttpServletResponse)response, (String)"http.error.page.template.html", params);
        }
    }
}

