/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.appserver.jetty;

import com.pingidentity.appserver.jetty.PFErrorHandler;
import com.pingidentity.common.util.PropertyInfo;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.jetty.deploy.App;
import org.eclipse.jetty.deploy.providers.ScanningAppProvider;
import org.eclipse.jetty.deploy.util.FileID;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.util.AttributesMap;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.WebAppContext;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;

public class PFWebAppProvider
extends ScanningAppProvider {
    private static final String SKIP_CONTEXT_PATH_PREPENDING_CONFIG_STORE_KEY = "SkipContextPathPrepending";
    private final ConfigStore config = ConfigStoreFarm.getConfig(((Object)((Object)this)).getClass());
    private boolean _extractWars;
    private boolean _applyContextPathConfigToWebArchiveFile;
    private boolean _parentLoaderPriority;
    private String _defaultsDescriptor;
    private Filter _filter;
    private File _tempDirectory;
    private String[] _configurationClasses;
    private ErrorHandler _errorHandler;
    private Integer _maxFormContentSize;
    private Integer _maxFormKeys;
    private final AttributesMap _attributes = new AttributesMap();

    public PFWebAppProvider() {
        this(new Filter());
    }

    public PFWebAppProvider(FilenameFilter filter) {
        super(filter);
        this._filter = (Filter)filter;
        this._filter._monitoredResources = this.getMonitoredResources();
        this.setScanInterval(0);
    }

    public boolean isExtractWars() {
        return this._extractWars;
    }

    public void setExtractWars(boolean extractWars) {
        this._extractWars = extractWars;
    }

    public boolean isApplyContextPathConfigurationToWebArchiveFile() {
        return this._applyContextPathConfigToWebArchiveFile;
    }

    public void setApplyContextPathConfigurationToWebArchiveFile(boolean applyContextPathConfigurationToWebArchiveFile) {
        this._applyContextPathConfigToWebArchiveFile = applyContextPathConfigurationToWebArchiveFile;
    }

    public boolean isParentLoaderPriority() {
        return this._parentLoaderPriority;
    }

    public void setParentLoaderPriority(boolean parentLoaderPriority) {
        this._parentLoaderPriority = parentLoaderPriority;
    }

    public String getDefaultsDescriptor() {
        return this._defaultsDescriptor;
    }

    public void setDefaultsDescriptor(String defaultsDescriptor) {
        this._defaultsDescriptor = defaultsDescriptor;
    }

    public String getContextXmlDir() {
        return this._filter._contexts == null ? null : this._filter._contexts.toString();
    }

    public void setContextXmlDir(String contextsDir) {
        try {
            this._filter._contexts = Resource.newResource((String)contextsDir).getFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setConfigurationClasses(String[] configurations) {
        this._configurationClasses = configurations == null ? null : (String[])configurations.clone();
    }

    public String[] getConfigurationClasses() {
        return (String[])this._configurationClasses.clone();
    }

    public void setTempDir(File directory) {
        this._tempDirectory = directory;
    }

    public File getTempDir() {
        return this._tempDirectory;
    }

    public ErrorHandler getErrorHandler() {
        return this._errorHandler;
    }

    public void setErrorHandler(ErrorHandler _errorHandler) {
        this._errorHandler = _errorHandler;
    }

    public void setMaxFormContentSize(int maxFormContentSize) {
        this._maxFormContentSize = maxFormContentSize;
    }

    public void setMaxFormKeys(int maxFormKeys) {
        this._maxFormKeys = maxFormKeys;
    }

    private boolean isApplyContextPath(String context) {
        Map skipContextPathPrependingConfigMap = this.config.getMapValue(SKIP_CONTEXT_PATH_PREPENDING_CONFIG_STORE_KEY, new HashMap());
        return (skipContextPathPrependingConfigMap.get(context) == null || !Boolean.parseBoolean(skipContextPathPrependingConfigMap.get(context).toString())) && this.isApplyContextPathConfigurationToWebArchiveFile();
    }

    private String getWebArchiveFileContextPath(String context) {
        if (this.isApplyContextPath(context)) {
            Object contextPath = PropertyInfo.getContextPath();
            if (!((String)contextPath).endsWith("/")) {
                contextPath = (String)contextPath + "/";
            }
            return (String)contextPath + context;
        }
        return context;
    }

    public ContextHandler createContextHandler(App app) throws Exception {
        Resource resource = Resource.newResource((String)app.getOriginId());
        File file = resource.getFile();
        if (!resource.exists()) {
            throw new IllegalStateException("App resource does not exist " + resource);
        }
        Object context = file.getName();
        if (file.isDirectory()) {
            if (file.getName().endsWith(".war")) {
                context = ((String)context).substring(0, ((String)context).length() - 4);
            }
        } else if (FileID.isWebArchiveFile((File)file)) {
            context = this.getWebArchiveFileContextPath(((String)context).substring(0, ((String)context).length() - 4));
        } else {
            throw new IllegalStateException("unable to create ContextHandler for " + app);
        }
        if (((String)context).length() > 0 && ((String)context).endsWith("/")) {
            context = ((String)context).substring(0, ((String)context).length() - 1);
        }
        WebAppContext wah = new WebAppContext();
        wah.setDisplayName((String)context);
        if (this._maxFormKeys != null) {
            wah.setMaxFormKeys(this._maxFormKeys.intValue());
        }
        if (this._maxFormContentSize != null) {
            wah.setMaxFormContentSize(this._maxFormContentSize.intValue());
        }
        if (((String)context).equalsIgnoreCase("root")) {
            context = "/";
        } else if (((String)context).toLowerCase().startsWith("root-")) {
            int dash = ((String)context).toLowerCase().indexOf(45);
            String virtual = ((String)context).substring(dash + 1);
            wah.setVirtualHosts(new String[]{virtual});
            context = "/";
        }
        if (((String)context).charAt(0) != '/') {
            context = "/" + (String)context;
        }
        wah.setContextPath((String)context);
        wah.setWar(file.getAbsolutePath());
        if (this._defaultsDescriptor != null) {
            wah.setDefaultsDescriptor(this._defaultsDescriptor);
        }
        wah.setExtractWAR(this._extractWars);
        wah.setParentLoaderPriority(this._parentLoaderPriority);
        if (this._configurationClasses != null) {
            wah.setConfigurationClasses(this._configurationClasses);
        }
        if (this._tempDirectory != null) {
            wah.setAttribute("org.eclipse.jetty.webapp.basetempdir", (Object)this._tempDirectory);
        }
        PFErrorHandler errorHandler = this._errorHandler != null ? (ErrorHandler)this._errorHandler.getClass().newInstance() : new PFErrorHandler();
        errorHandler.setShowStacks(false);
        errorHandler.setShowServlet(false);
        wah.setErrorHandler((ErrorHandler)errorHandler);
        for (Map.Entry entry : this._attributes.getAttributeEntrySet()) {
            wah.setAttribute((String)entry.getKey(), entry.getValue());
        }
        wah.clearAliasChecks();
        return wah;
    }

    public void setExclusions(String[] exclusions) {
        this._filter._exclusions = exclusions != null ? new HashSet<String>(Arrays.asList(exclusions)) : new HashSet<String>();
    }

    public void setAttribute(String name, Object value) {
        this._attributes.setAttribute(name, value);
    }

    public static class Filter
    implements FilenameFilter {
        private File _contexts;
        private Set<String> _exclusions = new HashSet<String>();
        private List<Resource> _monitoredResources = new ArrayList<Resource>();

        @Override
        public boolean accept(File dir, String name) {
            if (!dir.exists()) {
                return false;
            }
            String lowername = name.toLowerCase();
            Resource resource = Resource.newResource((File)new File(dir, name));
            for (Resource m : this._monitoredResources) {
                if (!resource.isSame(m)) continue;
                return false;
            }
            File file = new File(dir, name);
            if (!file.isDirectory() && !lowername.endsWith(".war")) {
                return false;
            }
            if (this._exclusions.contains(FilenameUtils.getBaseName((String)name))) {
                return false;
            }
            if (lowername.startsWith(".")) {
                return false;
            }
            if (file.isDirectory()) {
                if (new File(dir, name + ".war").exists() || new File(dir, name + ".WAR").exists()) {
                    return false;
                }
                if ("cvs".equals(lowername) || "cvsroot".equals(lowername)) {
                    return false;
                }
            }
            if (this._contexts != null) {
                String context = name;
                if (!file.isDirectory()) {
                    context = context.substring(0, context.length() - 4);
                }
                return !new File(this._contexts, context + ".xml").exists() && !new File(this._contexts, context + ".XML").exists();
            }
            return true;
        }
    }
}

