/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.appserver.jetty.server.connector;

import com.pingidentity.appserver.jetty.server.connector.ssl.RuntimeSslContextFactory;
import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.crypto.CertificateService;
import com.pingidentity.crypto.PkCert;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.security.KeyStore;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.Scheduler;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.config.ConfigurationException;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.mgmt.AdminNodeConfigManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.Mode;
import org.sourceid.saml20.domain.mgmt.impl.ModeSupport;
import org.sourceid.saml20.domain.mgmt.impl.SslServerPkCertManagerImpl;
import org.sourceid.saml20.util.SystemUtil;
import org.sourceid.websso.servlet.DeferredInitServlet;

@SuppressFBWarnings(value={"NM_SAME_SIMPLE_NAME_AS_SUPERCLASS"})
public class ServerConnector
extends org.eclipse.jetty.server.ServerConnector {
    private static final Log log = LogFactory.getLog(ServerConnector.class);
    private final ConfigStore config = ConfigStoreFarm.getConfig((String)"cipher-suite-settings");
    private boolean preferServerCipherSuites = this.config.getBooleanValue("prefer-server-cipher-suites", false);

    public ServerConnector(@Name(value="server") Server server, ConnectionFactory ... factories) {
        super(server, factories);
    }

    public ServerConnector(@Name(value="server") Server server, @Name(value="executor") Executor executor, @Name(value="scheduler") Scheduler scheduler, @Name(value="bufferPool") ByteBufferPool bufferPool, @Name(value="acceptors") int acceptors, @Name(value="selectors") int selectors, ConnectionFactory ... factories) {
        super(server, executor, scheduler, bufferPool, acceptors, selectors, factories);
    }

    public ServerConnector(@Name(value="server") Server server, @Name(value="acceptors") int acceptors, @Name(value="selectors") int selectors, ConnectionFactory ... factories) {
        super(server, acceptors, selectors, factories);
    }

    public ServerConnector(@Name(value="server") Server server, @Name(value="acceptors") int acceptors, @Name(value="selectors") int selectors, @Name(value="sslContextFactory") SslContextFactory.Server sslContextFactory) {
        super(server, acceptors, selectors, sslContextFactory);
    }

    public ServerConnector(@Name(value="server") Server server, @Name(value="acceptors") int acceptors, @Name(value="selectors") int selectors) {
        super(server, acceptors, selectors);
    }

    public ServerConnector(@Name(value="server") Server server, @Name(value="sslContextFactory") SslContextFactory.Server sslContextFactory, ConnectionFactory ... factories) {
        super(server, sslContextFactory, factories);
    }

    public ServerConnector(@Name(value="server") Server server, @Name(value="sslContextFactory") SslContextFactory.Server sslContextFactory) {
        super(server, sslContextFactory);
    }

    public ServerConnector(@Name(value="server") Server server) {
        super(server);
    }

    public void open() throws IOException {
        if (this.getPort() < 0) {
            return;
        }
        super.open();
    }

    public void doStart() throws Exception {
        if (!DeferredInitServlet.isStarted()) {
            DeferredInitServlet.addInitCall((Object)((Object)this), (String)"realStart");
            DeferredInitServlet.addDestroyCall((Object)((Object)this), (String)"stop");
        } else {
            this.realStart();
        }
    }

    protected synchronized void doStop() {
        int port = this.getPort();
        if (port > 0) {
            try {
                super.doStop();
                log.info((Object)("Stopped listener " + ((Object)((Object)this)).getClass() + " " + port));
            }
            catch (Exception e) {
                log.debug((Object)("Unable to stop the listener. " + e.getMessage()));
            }
        }
    }

    private void realStart() {
        int port = this.getPort();
        if (port > 0) {
            log.info((Object)("Starting listener " + ((Object)((Object)this)).getClass() + " " + port));
            try {
                SslConnectionFactory connFactory = (SslConnectionFactory)this.getConnectionFactory(SslConnectionFactory.class);
                if (connFactory != null) {
                    this.configureSslContextFactory((SslContextFactory)connFactory.getSslContextFactory());
                }
                super.doStart();
            }
            catch (Exception e) {
                String msg = "Exception in invoking realStart() on " + this + ". The port number (" + port + ") may be in use or bind address (" + this.getHost() + ") is invalid.";
                SystemUtil.hardShutdown((String)msg, (Throwable)e);
            }
        } else {
            log.info((Object)("Not starting listener " + ((Object)((Object)this)).getClass() + " because port was set to " + port));
        }
    }

    private void configureSslContextFactory(SslContextFactory sslContextFactory) {
        sslContextFactory.setKeyStores(this.getSSLKeyStores(sslContextFactory));
        sslContextFactory.setKeyStorePassword(SslServerPkCertManagerImpl.TEMP_KEYSTORE_PASSWORD);
        sslContextFactory.setTrustStore(this.getTrustKeyStore());
        String[] supportedCiphers = MgmtFactory.getJCEManager().getEnabledCipherSuites();
        if (supportedCiphers != null) {
            sslContextFactory.setExcludeCipherSuites(new String[0]);
            sslContextFactory.setIncludeCipherSuites(supportedCiphers);
            sslContextFactory.setUseCipherSuitesOrder(this.preferServerCipherSuites);
            if (log.isDebugEnabled()) {
                for (String s : sslContextFactory.getIncludeCipherSuites()) {
                    log.debug((Object)("cipher enabled: " + s));
                }
            }
        }
    }

    private List<KeyStore> getSSLKeyStores(SslContextFactory sslContextFactory) {
        boolean clusteredPassiveConsoleWithoutPkCert;
        Object certManager = sslContextFactory instanceof RuntimeSslContextFactory ? MgmtFactory.getSslServerPkCertManager() : MgmtFactory.getAdminSslServerPkCertManager();
        AdminNodeConfigManager adminNodeConfigManager = MgmtFactory.getAdminNodeConfigManager();
        PkCert defaultActiveServerPkCert = certManager.getDefaultActiveServerPkCert();
        boolean clusteredEngineWithoutPkCert = defaultActiveServerPkCert == null && ModeSupport.getMode() == Mode.CLUSTERED_ENGINE && (!certManager.isCreateServerPkCertOnEngineNode() || PropertyInfo.isHardwareHSM());
        boolean bl = clusteredPassiveConsoleWithoutPkCert = defaultActiveServerPkCert == null && adminNodeConfigManager.isEnabledAndPassiveNode() && PropertyInfo.isHardwareHSM();
        if (clusteredEngineWithoutPkCert) {
            String error = "Default active server cert is not present on node. Server operational mode is CLUSTERED_ENGINE and HSM is configured so the cert will not be generated as that will strand an unused key on the HSM. Instead the configuration data needs to be retrieved from the console. Ensure the console is started before starting this engine. It may be necessary to trigger replication on the console after startup to ensure configuration data is published to the cluster.";
            throw new ConfigurationException(error);
        }
        if (clusteredPassiveConsoleWithoutPkCert) {
            String error = "Default active server cert is not present on node. This is a passive console node and HSM is configured so the cert will not be generated as that will strand an unused key on the HSM. Instead the configuration data needs to be retrieved from the active console. Ensure the active console is started before starting this passive console.";
            throw new ConfigurationException(error);
        }
        sslContextFactory.setCertAlias(defaultActiveServerPkCert.getAlias());
        return certManager.getActiveCertKeystores();
    }

    private KeyStore getTrustKeyStore() {
        CertificateService cs = (CertificateService)GlobalRegistry.getService(CertificateService.class);
        if (PropertyInfo.HSM_MODE.OFF == PropertyInfo.getHSMMode()) {
            return cs.getTrustKeystore();
        }
        if (!PropertyInfo.isHSMHybrid()) {
            return cs.getTrustHSMKeystore();
        }
        try {
            return cs.getTrustKeystore();
        }
        catch (ConfigurationException e) {
            return cs.getTrustHSMKeystore();
        }
    }
}

