/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.appserver.jetty.server.connector.ssl;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CRL;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Stream;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.sourceid.saml20.domain.mgmt.impl.ServerX509TrustManager;

public abstract class AbstractSslContextFactory
extends SslContextFactory.Server {
    private static final Log log = LogFactory.getLog(AbstractSslContextFactory.class);
    private static final String TLS_V_1_3 = "TLSv1.3";

    protected abstract KeyManager[] getUnwrappedKeyManagers(KeyStore var1) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException;

    protected TrustManager[] getTrustManagers(KeyStore trustStore, Collection<? extends CRL> crls) throws Exception {
        ServerX509TrustManager serverX509TrustManager = ServerX509TrustManager.getX509TrustManager();
        return new TrustManager[]{serverX509TrustManager};
    }

    protected String[] parseProtocols(String protocolsStr) {
        String[] result = new String[]{"TLSv1.2"};
        if (StringUtils.isNotBlank((String)protocolsStr)) {
            result = (String[])Stream.of(protocolsStr.split(",")).map(String::trim).toArray(String[]::new);
        }
        return this.checkAndPruneTls13(result);
    }

    private String[] checkAndPruneTls13(String[] result) {
        if (Arrays.asList(result).contains(TLS_V_1_3)) {
            try {
                String[] supportedProtocols = SSLContext.getDefault().getSupportedSSLParameters().getProtocols();
                boolean tls13IsSupported = Arrays.asList(supportedProtocols).contains(TLS_V_1_3);
                if (!tls13IsSupported) {
                    String warnMessage = "PingFederate cannot make use of TLSv1.3 protocol since it is not supported by the in-use java version. Removing TLSv1.3 from the protocol list";
                    log.debug((Object)warnMessage);
                    return (String[])Stream.of(result).filter(s -> !s.equals(TLS_V_1_3)).toArray(String[]::new);
                }
            }
            catch (NoSuchAlgorithmException e) {
                log.error((Object)"Unexpected error retrieving supported TLS algorithms", (Throwable)e);
            }
        }
        return result;
    }

    public abstract String[] getEnabledProtocols();
}

