/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.appserver.jetty.server.customizer;

import com.pingidentity.common.util.PropertyInfo;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.jetty.http.HostPortHttpField;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.Request;

public class AdminHostHeaderCustomizer
implements HttpConfiguration.Customizer {
    public void customize(Connector connector, HttpConfiguration channelConfig, Request request) {
        String serverName = this.getHostname();
        int serverPort = this.getPort();
        String host = serverName == null ? request.getServerName() : serverName;
        int port = HttpScheme.normalizePort((String)request.getScheme(), (int)serverPort);
        request.setHttpURI((HttpURI)HttpURI.build((HttpURI)request.getHttpURI()).authority(host, port));
        HttpFields original = request.getHttpFields();
        HttpFields.Mutable httpFields = HttpFields.build((int)(original.size() + 1));
        httpFields.add((HttpField)new HostPortHttpField(host, port));
        httpFields.add(request.getHttpFields());
        request.setHttpFields((HttpFields)httpFields);
    }

    private String getHostname() {
        String adminBaseUrl = PropertyInfo.getAdminBaseUrl();
        if (adminBaseUrl != null && !adminBaseUrl.isEmpty()) {
            try {
                return new URI(adminBaseUrl).getHost();
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Invalid admin base URL: " + adminBaseUrl, e);
            }
        }
        String hostname = PropertyInfo.getAdminHostname();
        if (hostname != null && !hostname.isEmpty()) {
            return hostname;
        }
        return null;
    }

    private int getPort() {
        String adminBaseUrl = PropertyInfo.getAdminBaseUrl();
        if (adminBaseUrl != null && !adminBaseUrl.isEmpty()) {
            try {
                return new URI(adminBaseUrl).getPort();
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Invalid admin base URL: " + adminBaseUrl, e);
            }
        }
        return Integer.parseInt(PropertyInfo.getAdminHttpsPort());
    }
}

