/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.appserver.jetty.server.customizer;

import com.google.common.collect.Lists;
import com.pingidentity.common.util.PropertyInfo;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.Request;
import org.sourceid.oauth20.issuer.OAuthIssuerManager;
import org.sourceid.oauth20.issuer.OAuthIssuerUtils;
import org.sourceid.oauth20.issuer.domain.OAuthIssuer;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.local.MetadataLocal;

public class OAuthIssuerRequestCustomizer
implements HttpConfiguration.Customizer {
    private static final Pattern AUTHZ_ENDPOINT_PATTERN = Pattern.compile("/.well-known/oauth-authorization-server(.*)");
    private static final Log LOG = LogFactory.getLog(OAuthIssuerRequestCustomizer.class);
    private static final List<String> OAUTH_PROTOCOL_MAPPINGS = Lists.newArrayList((Object[])new String[]{".oauth2", ".ciba", ".openid", "/.well-known/openid-configuration", "/pf/JWKS"});
    private static final String DCRM_PATH = "/as/clients.oauth2/";
    private static final String PF_WS_OAUTH_GRANTS_PATH = "/pf-ws/rest/oauth/grants";
    private final OAuthIssuerManager manager = MgmtFactory.getOAuthIssuerManager();
    private final MetadataLocal metadataLocal = MetaDataFactory.getLocalMetaData();
    private final OAuthIssuerUtils oAuthIssuerUtils = OAuthIssuerUtils.getInstance();

    public void customize(Connector connector, HttpConfiguration channelConfig, Request request) {
        boolean startWithContextPath;
        String pathInfo = request.getPathInfo();
        String contextPath = PropertyInfo.getContextPath();
        boolean isOAuthMetadataPath = pathInfo.startsWith("/.well-known/oauth-authorization-server");
        if (isOAuthMetadataPath) {
            this.updateRequestForOAuthMetaDataIfNeeded(request);
            return;
        }
        boolean bl = startWithContextPath = !contextPath.equals("/") && (contextPath + "/.well-known/oauth-authorization-server").equals(pathInfo);
        if (startWithContextPath) {
            this.updatePath(request, "/.well-known/oauth-authorization-server");
            return;
        }
        if (this.manager.getAll().isEmpty()) {
            return;
        }
        if (!this.isPathSupported(pathInfo)) {
            return;
        }
        if (!pathInfo.startsWith(contextPath)) {
            return;
        }
        String serverName = request.getServerName();
        OAuthIssuer oAuthIssuer = this.manager.getByHostAndPath(serverName, pathInfo);
        if (oAuthIssuer == null) {
            return;
        }
        String issuerValue = oAuthIssuer.constructIssuer((HttpServletRequest)request);
        if (issuerValue.equals(this.metadataLocal.getBaseUrl())) {
            return;
        }
        String normalizePathInfo = oAuthIssuer.normalizePathInfo(pathInfo);
        if (StringUtils.isNotBlank((CharSequence)normalizePathInfo)) {
            this.updatePath(request, normalizePathInfo);
            this.oAuthIssuerUtils.addOAuthIssuerToRequest((HttpServletRequest)request, oAuthIssuer);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Using OAuth issuer for this request:" + oAuthIssuer));
            }
        }
    }

    private void updateRequestForOAuthMetaDataIfNeeded(Request request) {
        String pathInfo = request.getPathInfo();
        String contextPath = PropertyInfo.getContextPath();
        if (this.manager.getAll().isEmpty()) {
            this.handleHardcodedContextPathEdgeCaseForAuthzServerMetadata(request, pathInfo, contextPath);
            return;
        }
        Matcher authzServerMetadataEndpointMatcher = AUTHZ_ENDPOINT_PATTERN.matcher(pathInfo);
        if (!authzServerMetadataEndpointMatcher.matches()) {
            return;
        }
        String pfCompatiblePath = authzServerMetadataEndpointMatcher.group(1) + "/.well-known/oauth-authorization-server";
        if (!pfCompatiblePath.startsWith(contextPath)) {
            return;
        }
        String serverName = request.getServerName();
        OAuthIssuer oAuthIssuer = this.manager.getByHostAndPath(serverName, pfCompatiblePath);
        if (oAuthIssuer == null) {
            this.handleHardcodedContextPathEdgeCaseForAuthzServerMetadata(request, pathInfo, contextPath);
            return;
        }
        String issuerValue = oAuthIssuer.constructIssuer((HttpServletRequest)request);
        if (issuerValue.equals(this.metadataLocal.getBaseUrl())) {
            return;
        }
        String normalizePathInfo = oAuthIssuer.normalizePathInfo(pfCompatiblePath);
        if (StringUtils.isNotBlank((CharSequence)normalizePathInfo)) {
            this.updatePath(request, normalizePathInfo);
            this.oAuthIssuerUtils.addOAuthIssuerToRequest((HttpServletRequest)request, oAuthIssuer);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Using OAuth issuer for this request:" + oAuthIssuer));
            }
        }
    }

    private boolean isPathSupported(String pathInfo) {
        Optional<String> isOauthPath = OAUTH_PROTOCOL_MAPPINGS.stream().filter(pathInfo::endsWith).findFirst();
        if (isOauthPath.isPresent()) {
            return true;
        }
        if (pathInfo.contains(DCRM_PATH)) {
            return true;
        }
        String sloPath = this.metadataLocal.getIdpLocalPathMappings().getInitiateSLOPath();
        if (pathInfo.endsWith(sloPath)) {
            return true;
        }
        if (pathInfo.contains("/pf-ws/rest/sessionMgmt/")) {
            return true;
        }
        return pathInfo.endsWith(PF_WS_OAUTH_GRANTS_PATH) || pathInfo.contains("/pf-ws/rest/oauth/grants/");
    }

    private void handleHardcodedContextPathEdgeCaseForAuthzServerMetadata(Request request, String pathInfo, String contextPath) {
        String expectedWellKnownEndpoint;
        if (!"/".equals(contextPath) && (expectedWellKnownEndpoint = "/.well-known/oauth-authorization-server" + contextPath).equals(pathInfo)) {
            String internal = contextPath + "/.well-known/oauth-authorization-server";
            this.updatePath(request, internal);
        }
    }

    private void updatePath(Request request, String path) {
        String method = request.getMetaData().getMethod();
        HttpURI.Mutable httpURI = HttpURI.build((HttpURI)request.getMetaData().getURI());
        httpURI.path(path);
        HttpVersion httpVersion = request.getHttpVersion();
        HttpFields httpFields = request.getHttpFields();
        long contentLength = request.getMetaData().getContentLength();
        MetaData.Request req = new MetaData.Request(method, (HttpURI)httpURI, httpVersion, httpFields, contentLength);
        request.setMetaData(req);
    }
}

