/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.channel;

import com.pingidentity.provisioner.cluster.ClusteringException;
import com.pingidentity.provisioner.directory.DirectoryException;
import com.pingidentity.provisioner.directory.DirectoryResourceCallback;
import com.pingidentity.provisioner.directory.DirectoryResourceGuidCallback;
import com.pingidentity.provisioner.directory.GuidFormatter;
import com.pingidentity.provisioner.store.groups.GroupMembershipStore;
import com.pingidentity.provisioner.store.groups.GroupStoreException;
import java.util.LinkedList;
import java.util.List;

public class AddMembershipCallback
extends DirectoryResourceGuidCallback {
    private final List<DirectoryResourceCallback.DirectoryCallbackProcessException> nonFatalExceptions = new LinkedList<DirectoryResourceCallback.DirectoryCallbackProcessException>();
    private final GroupMembershipStore _membershipStore;
    private final String _groupGuid;
    private final boolean _isUserMembers;

    public AddMembershipCallback(GuidFormatter guidFormatter, String groupGuid, GroupMembershipStore membershipStore, boolean isUserMembers) {
        super(guidFormatter);
        this._groupGuid = groupGuid;
        this._membershipStore = membershipStore;
        this._isUserMembers = isUserMembers;
    }

    @Override
    public void process(String dn, String guid) throws DirectoryException, ClusteringException {
        try {
            if (this._isUserMembers) {
                this._membershipStore.addUserMembership(this._groupGuid, guid);
            } else {
                this._membershipStore.addSubGroupMembership(this._groupGuid, guid);
            }
        }
        catch (GroupStoreException e) {
            this.nonFatalExceptions.add(new DirectoryResourceCallback.DirectoryCallbackProcessException("Unable to commit group membership batch", e));
        }
    }

    @Override
    public List<DirectoryResourceCallback.DirectoryCallbackProcessException> getNonFatalExceptions() {
        return this.nonFatalExceptions;
    }
}

