/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.channel;

import com.pingidentity.common.util.TinyHashSet;
import com.pingidentity.provisioner.channel.DirectoryGroupWorker;
import com.pingidentity.provisioner.cluster.ClusteringException;
import com.pingidentity.provisioner.directory.DirectoryDriver;
import com.pingidentity.provisioner.directory.DirectoryException;
import com.pingidentity.provisioner.directory.DirectoryResourceCallback;
import com.pingidentity.provisioner.identity.DirectoryGroup;
import com.pingidentity.provisioner.identity.SaasGroup;
import com.pingidentity.provisioner.mapping.AttributesMapper;
import com.pingidentity.provisioner.resources.DirectoryResource;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AddRemoveGroupsCallback
implements DirectoryResourceCallback {
    private final Map<String, SaasGroup> _insideGroups;
    private final Map<String, SaasGroup> _outsideGroups;
    private final DirectoryDriver _directoryDriver;
    private final DirectoryGroupWorker _worker;
    private final TinyHashSet<String> _guidsWorkedOn;

    public AddRemoveGroupsCallback(Map<String, SaasGroup> insideGroups, Map<String, SaasGroup> outsideGroups, DirectoryDriver directoryDriver, DirectoryGroupWorker worker, TinyHashSet<String> guidsWorkedOn) {
        this._insideGroups = insideGroups;
        this._outsideGroups = outsideGroups;
        this._directoryDriver = directoryDriver;
        this._worker = worker;
        this._guidsWorkedOn = guidsWorkedOn;
    }

    @Override
    public List<DirectoryResourceCallback.DirectoryCallbackProcessException> getNonFatalExceptions() {
        return this._worker.getNonFatalExceptions();
    }

    @Override
    public Set<String> getAttributeNames() {
        return this._worker.getAttributeNames();
    }

    @Override
    public AttributesMapper getAttributeMapper() {
        return this._directoryDriver.getDirectoryGroupAttributesMapper();
    }

    @Override
    public void process(String dn, DirectoryResource resource) throws DirectoryException, ClusteringException {
        String guid = resource.getGuid();
        if (this._insideGroups.containsKey(guid)) {
            this._insideGroups.remove(guid);
        } else if (this._outsideGroups.containsKey(guid)) {
            this._worker.work(dn, (DirectoryGroup)resource, false);
            this._outsideGroups.remove(guid);
            this._guidsWorkedOn.add((Object)guid);
        } else {
            this._worker.work(dn, (DirectoryGroup)resource, true);
            this._guidsWorkedOn.add((Object)guid);
        }
    }
}

