/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.channel;

import com.pingidentity.provisioner.cluster.ClusteringException;
import com.pingidentity.provisioner.cluster.ProvisionerClusterManager;
import com.pingidentity.provisioner.directory.DirectoryDriver;
import com.pingidentity.provisioner.directory.DirectoryResourceCallback;
import com.pingidentity.provisioner.directory.spring.DirectoryIdentityAttributesMapper;
import com.pingidentity.provisioner.identity.DirectoryIdentity;
import com.pingidentity.provisioner.identity.SaasIdentity;
import com.pingidentity.provisioner.mapping.AttributesMapper;
import com.pingidentity.provisioner.mapping.IdentityMapper;
import com.pingidentity.provisioner.mapping.MappingException;
import com.pingidentity.provisioner.monitor.ProvisioningEventLogger;
import com.pingidentity.provisioner.resources.DirectoryResource;
import com.pingidentity.provisioner.store.DuplicateKeyException;
import com.pingidentity.provisioner.store.InvalidProvisioningDataException;
import com.pingidentity.provisioner.store.UserStore;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AttributeSyncCallback
implements DirectoryResourceCallback {
    private static final Logger _logger = LogManager.getLogger(AttributeSyncCallback.class);
    private final IdentityMapper _identityMapper;
    private final UserStore _userStore;
    private final ProvisionerClusterManager _clusterManager;
    private final DirectoryIdentityAttributesMapper _directoryAttrsMapper;
    private final DirectoryDriver _directoryDriver;
    private final Set<String> _attributeNames = new HashSet<String>();
    private boolean _ignoreValuesHash = false;
    private final Set<String> _usersToIgnore;
    private final ProvisioningEventLogger _provisioningEventLogger;

    public AttributeSyncCallback(DirectoryDriver directoryDriver, IdentityMapper identityMapper, UserStore userStore, ProvisionerClusterManager clusterManager, Set<String> usersToIgnore, ProvisioningEventLogger provisioningEventLogger) {
        this._directoryDriver = directoryDriver;
        this._directoryAttrsMapper = directoryDriver.getDirectoryIdentityAttributesMapper();
        this._identityMapper = identityMapper;
        this._userStore = userStore;
        this._clusterManager = clusterManager;
        this._provisioningEventLogger = provisioningEventLogger;
        this._attributeNames.addAll(identityMapper.getAttributeNames());
        this._attributeNames.add(this._directoryDriver.getGuidFormatter().getGuidAttributeName());
        this._attributeNames.add(this._directoryDriver.getChangedResourceAttribute());
        this._usersToIgnore = usersToIgnore;
    }

    public void setIgnoreValuesHash(boolean ignoreValuesHash) {
        this._ignoreValuesHash = ignoreValuesHash;
    }

    @Override
    public void process(String dn, DirectoryResource directoryResource) throws ClusteringException {
        if (!this._directoryDriver.verifyChangedResource(directoryResource)) {
            this._provisioningEventLogger.attributeSyncUserNotUpdated();
            return;
        }
        DirectoryIdentity directoryIdentity = (DirectoryIdentity)directoryResource;
        String guid = directoryIdentity.getGuid();
        if (this.ignoreUser(guid)) {
            _logger.debug("Skipping user " + guid + " as they are managed by another channel");
            this._provisioningEventLogger.attributeSyncUserSkipped();
        } else {
            try {
                this._clusterManager.sendHeartBeat();
                SaasIdentity saasIdentity = this._identityMapper.map(directoryIdentity);
                boolean updateUserStore = true;
                if (!this._ignoreValuesHash) {
                    String oldHash = this._userStore.getValuesHash(guid);
                    if (oldHash == null) {
                        this._userStore.create(guid, saasIdentity, true);
                        this._provisioningEventLogger.attributeSyncUserUpdated();
                        return;
                    }
                    String newHash = saasIdentity.calculateValuesHash();
                    if (oldHash.equals(newHash)) {
                        updateUserStore = false;
                        this._provisioningEventLogger.attributeSyncUserNotUpdated();
                    }
                }
                if (updateUserStore) {
                    this._userStore.update(guid, saasIdentity);
                    _logger.debug("User marked for update, GUID: " + guid);
                    this._provisioningEventLogger.attributeSyncUserUpdated();
                }
                this._directoryDriver.processChangedResource(directoryIdentity);
            }
            catch (MappingException e) {
                _logger.error("Changed user cannot be mapped during attribute sync: " + guid, (Throwable)e);
                this._provisioningEventLogger.attributeSyncUserError();
            }
            catch (DuplicateKeyException e) {
                _logger.error("User update skipped for GUID: " + guid + " collision with saasUsername: " + e.getConflictValue());
                this._provisioningEventLogger.attributeSyncUserError();
            }
            catch (InvalidProvisioningDataException e) {
                _logger.error(e.getMessage());
            }
        }
    }

    @Override
    public Set<String> getAttributeNames() {
        return this._identityMapper.getAttributeNames();
    }

    @Override
    public List<DirectoryResourceCallback.DirectoryCallbackProcessException> getNonFatalExceptions() {
        return Collections.emptyList();
    }

    @Override
    public AttributesMapper getAttributeMapper() {
        return this._directoryAttrsMapper;
    }

    private boolean ignoreUser(String guid) {
        if (this._usersToIgnore == null) {
            return false;
        }
        return this._usersToIgnore.contains(guid);
    }
}

