/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.channel;

import com.pingidentity.provisioner.channel.AddMembershipCallback;
import com.pingidentity.provisioner.channel.SecondPhaseDirectoryGroupWorker;
import com.pingidentity.provisioner.cluster.ClusteringException;
import com.pingidentity.provisioner.cluster.ProvisionerClusterManager;
import com.pingidentity.provisioner.cluster.RuntimeClusteringException;
import com.pingidentity.provisioner.directory.DirectoryDriver;
import com.pingidentity.provisioner.directory.DirectoryException;
import com.pingidentity.provisioner.directory.DirectoryResourceCallback;
import com.pingidentity.provisioner.directory.ResourceCallbackCriteria;
import com.pingidentity.provisioner.directory.spring.RuntimeDirectoryException;
import com.pingidentity.provisioner.identity.DirectoryGroup;
import com.pingidentity.provisioner.identity.SaasGroup;
import com.pingidentity.provisioner.mapping.GroupMapper;
import com.pingidentity.provisioner.monitor.ProvisioningEventLogger;
import com.pingidentity.provisioner.store.groups.GroupMembershipStore;
import com.pingidentity.provisioner.store.groups.GroupStore;
import com.pingidentity.provisioner.store.groups.GroupStoreException;
import com.pingidentity.provisioner.store.groups.RuntimeGroupStoreException;
import com.unboundid.ldap.sdk.Filter;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.transaction.support.TransactionTemplate;

public class DirectoryGroupWorker {
    private final GroupStore groupStore;
    private final GroupMembershipStore groupMembershipStore;
    private final ProvisionerClusterManager clusterManager;
    private final List<DirectoryResourceCallback.DirectoryCallbackProcessException> nonFatalExceptions = new LinkedList<DirectoryResourceCallback.DirectoryCallbackProcessException>();
    private final DirectoryDriver directoryDriver;
    private final Filter usersFilter;
    private final String usersGroup;
    private final boolean isGroupMembershipSupported;
    private final SecondPhaseDirectoryGroupWorker secondPhaseDirectoryGroupWorker;
    private final boolean delayHashUpdate;
    private final Set<String> attributeNames = new HashSet<String>();
    private final GroupMapper groupMapper;
    private final TransactionTemplate transactionTemplate;
    private final ProvisioningEventLogger _provisioningEventLogger;
    private static Logger _logger = LogManager.getLogger(DirectoryGroupWorker.class);

    public DirectoryGroupWorker(GroupStore groupStore, GroupMembershipStore groupMembershipStore, ProvisionerClusterManager clusterManager, boolean usingDnAsGroupName, boolean isGroupMembershipSupported, DirectoryDriver directoryDriver, Filter usersFilter, String usersGroup, SecondPhaseDirectoryGroupWorker secondPhaseDirectoryGroupWorker, boolean delayHashUpdate, TransactionTemplate transactionTemplate, ProvisioningEventLogger provisioningEventLogger) {
        this.groupStore = groupStore;
        this.groupMembershipStore = groupMembershipStore;
        this.clusterManager = clusterManager;
        this.directoryDriver = directoryDriver;
        this.usersFilter = usersFilter;
        this.usersGroup = usersGroup;
        this.isGroupMembershipSupported = isGroupMembershipSupported;
        this.secondPhaseDirectoryGroupWorker = secondPhaseDirectoryGroupWorker;
        this.delayHashUpdate = delayHashUpdate;
        this.groupMapper = new GroupMapper(usingDnAsGroupName);
        this._provisioningEventLogger = provisioningEventLogger;
        this.transactionTemplate = transactionTemplate;
        this.attributeNames.add(directoryDriver.getGuidFormatter().getGuidAttributeName());
        this.attributeNames.add(directoryDriver.getChangedResourceAttribute());
        this.attributeNames.addAll(this.groupMapper.getLdapAttributeNames());
    }

    public void work(String dn, DirectoryGroup directoryGroup, boolean isCreate) throws DirectoryException, ClusteringException {
        this.clusterManager.sendHeartBeat();
        String guid = directoryGroup.getGuid();
        SaasGroup saasGroup = this.groupMapper.map(dn, directoryGroup);
        String groupName = saasGroup.getName();
        try {
            this.transactionTemplate.execute(status -> {
                String message = "Starting transaction to update " + groupName + (this.isGroupMembershipSupported ? " and rebuild group membership" : "");
                _logger.debug(message);
                try {
                    if (isCreate) {
                        this.groupStore.create(guid, saasGroup, true);
                        this._provisioningEventLogger.passiveProvGroupAdded();
                    } else {
                        this.groupStore.update(guid, saasGroup, true);
                    }
                    if (this.isGroupMembershipSupported) {
                        this.groupMembershipStore.deleteMembership(guid);
                        AddMembershipCallback addMembershipCallback = new AddMembershipCallback(this.directoryDriver.getGuidFormatter(), guid, this.groupMembershipStore, true);
                        ResourceCallbackCriteria callbackCriteria = new ResourceCallbackCriteria();
                        callbackCriteria.setGroupCriterion(this.usersGroup);
                        callbackCriteria.setObjectClassCriterion(this.directoryDriver.getUserObjectClass());
                        callbackCriteria.setFilterCriterion(this.usersFilter);
                        this.directoryDriver.processResourcesInGroup(dn, callbackCriteria, addMembershipCallback);
                        this.nonFatalExceptions.addAll(addMembershipCallback.getNonFatalExceptions());
                        if (this.secondPhaseDirectoryGroupWorker != null) {
                            this.secondPhaseDirectoryGroupWorker.work(dn, directoryGroup);
                        }
                    }
                }
                catch (ClusteringException e) {
                    _logger.error("Error rebuilding group membership for group " + groupName + ". Transaction will be rolled back.", (Throwable)e);
                    throw new RuntimeClusteringException(e);
                }
                catch (DirectoryException e) {
                    _logger.error("Error rebuilding group membership for group " + groupName + ". Transaction will be rolled back.", (Throwable)e);
                    throw new RuntimeDirectoryException(e);
                }
                catch (GroupStoreException e) {
                    throw new RuntimeGroupStoreException("Unable to create group '" + groupName + "' in group store", e);
                }
                return true;
            });
        }
        catch (RuntimeClusteringException e) {
            throw e.getClusteringCause();
        }
        catch (RuntimeDirectoryException e) {
            throw e.getDirectoryCause();
        }
        catch (RuntimeGroupStoreException e) {
            this.nonFatalExceptions.add(new DirectoryResourceCallback.DirectoryCallbackProcessException(e.getMessage(), e));
            return;
        }
        this.directoryDriver.processChangedResource(directoryGroup);
        if (this.isGroupMembershipSupported && this.secondPhaseDirectoryGroupWorker == null && !this.delayHashUpdate) {
            this.groupStore.updateValuesHashWithMembers(saasGroup);
        }
    }

    public List<DirectoryResourceCallback.DirectoryCallbackProcessException> getNonFatalExceptions() {
        return this.nonFatalExceptions;
    }

    public Set<String> getAttributeNames() {
        return this.attributeNames;
    }
}

