/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.channel;

import com.pingidentity.common.util.TinyHashSet;
import com.pingidentity.provisioner.channel.DirectoryGroupWorker;
import com.pingidentity.provisioner.cluster.ClusteringException;
import com.pingidentity.provisioner.directory.DirectoryDriver;
import com.pingidentity.provisioner.directory.DirectoryException;
import com.pingidentity.provisioner.directory.DirectoryResourceCallback;
import com.pingidentity.provisioner.identity.DirectoryGroup;
import com.pingidentity.provisioner.mapping.AttributesMapper;
import com.pingidentity.provisioner.resources.DirectoryResource;
import com.pingidentity.provisioner.store.groups.GroupStore;
import java.util.List;
import java.util.Set;

public class GroupSyncCallback
implements DirectoryResourceCallback {
    private final DirectoryDriver directoryDriver;
    private final DirectoryGroupWorker worker;
    private final GroupStore groupStore;
    private final boolean delayHashCleanup;
    private final TinyHashSet<String> cleanGroupsAfterFirstPhase;

    public GroupSyncCallback(DirectoryDriver directoryDriver, GroupStore groupStore, DirectoryGroupWorker worker, boolean delayHashCleanup, TinyHashSet<String> cleanGroupsAfterFirstPhase) {
        this.directoryDriver = directoryDriver;
        this.worker = worker;
        this.groupStore = groupStore;
        this.delayHashCleanup = delayHashCleanup;
        this.cleanGroupsAfterFirstPhase = cleanGroupsAfterFirstPhase;
    }

    @Override
    public List<DirectoryResourceCallback.DirectoryCallbackProcessException> getNonFatalExceptions() {
        return this.worker.getNonFatalExceptions();
    }

    @Override
    public Set<String> getAttributeNames() {
        return this.worker.getAttributeNames();
    }

    @Override
    public AttributesMapper getAttributeMapper() {
        return this.directoryDriver.getDirectoryGroupAttributesMapper();
    }

    @Override
    public void process(String dn, DirectoryResource resource) throws DirectoryException, ClusteringException {
        String newHash;
        if (!this.directoryDriver.verifyChangedResource(resource)) {
            return;
        }
        String oldHash = this.groupStore.getValuesHash(resource.getGuid(), true);
        this.worker.work(dn, (DirectoryGroup)resource, false);
        if (oldHash != null && oldHash.equals(newHash = this.groupStore.getValuesHash(resource.getGuid(), false))) {
            if (this.delayHashCleanup) {
                this.cleanGroupsAfterFirstPhase.add((Object)resource.getGuid());
            } else {
                this.groupStore.clearDirtyFlag(resource.getGuid(), false);
            }
        }
    }
}

