/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.channel.runner;

import com.pingidentity.common.mgr.ExpressionManager;
import com.pingidentity.common.util.AdapterUtils;
import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.provisioner.channel.GenericUserProvisioningChannel;
import com.pingidentity.provisioner.channel.ProvisioningChannel;
import com.pingidentity.provisioner.cluster.NoopProvisionerClusterManager;
import com.pingidentity.provisioner.cluster.ProvisionerClusterManager;
import com.pingidentity.provisioner.directory.DirectoryDriver;
import com.pingidentity.provisioner.directory.GuidFormatter;
import com.pingidentity.provisioner.directory.spring.ActiveDirectoryAccountStatusReader;
import com.pingidentity.provisioner.directory.spring.BaseAccountStatusReader;
import com.pingidentity.provisioner.directory.spring.BaseChangedUsersAlgorithm;
import com.pingidentity.provisioner.directory.spring.DirectoryGroupAttributesMapper;
import com.pingidentity.provisioner.directory.spring.DirectoryIdentityAttributesMapper;
import com.pingidentity.provisioner.directory.spring.FlagAccountStatusReader;
import com.pingidentity.provisioner.directory.spring.SpringLdapDirectoryDriver;
import com.pingidentity.provisioner.directory.spring.SpringLdapGuidFormatter;
import com.pingidentity.provisioner.directory.spring.TimestampChangedUsersAlgorithm;
import com.pingidentity.provisioner.directory.spring.UsnChangedUsersAlgorithm;
import com.pingidentity.provisioner.domain.Channel;
import com.pingidentity.provisioner.domain.IdentityMappingField;
import com.pingidentity.provisioner.domain.mgmt.ProvisionerConfig;
import com.pingidentity.provisioner.domain.mgmt.ProvisionerManager;
import com.pingidentity.provisioner.domain.source.ChannelSource;
import com.pingidentity.provisioner.domain.source.LdapGuidFormatter;
import com.pingidentity.provisioner.domain.target.SaasTarget;
import com.pingidentity.provisioner.mapping.FieldConfig;
import com.pingidentity.provisioner.mapping.FieldInfo;
import com.pingidentity.provisioner.mapping.IdentityMapper;
import com.pingidentity.provisioner.monitor.ProvisioningEventLogger;
import com.pingidentity.provisioner.monitor.SaasProvisioningCycleIdHelper;
import com.pingidentity.provisioner.monitor.SaasProvisioningEventTracker;
import com.pingidentity.provisioner.saas.BaseSaasPlugin;
import com.pingidentity.provisioner.saas.SaasPluginManager;
import com.pingidentity.provisioner.saas.SaasProvisionerPlugin;
import com.pingidentity.provisioner.store.UserStoreWithEventTracking;
import com.pingidentity.provisioner.store.groups.GroupStoreWithEventTracking;
import com.pingidentity.provisioner.store.jdbc.JdbcGroupMembershipStore;
import com.pingidentity.provisioner.store.jdbc.JdbcGroupStore;
import com.pingidentity.provisioner.store.jdbc.JdbcMetadataCallback;
import com.pingidentity.provisioner.store.jdbc.JdbcUserStore;
import com.pingidentity.provisioner.store.jdbc.JdbcVariableStore;
import com.pingidentity.sdk.PluginFipsStatus;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.sourceid.saml20.adapter.conf.FieldList;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.springframework.jdbc.support.DatabaseMetaDataCallback;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.MetaDataAccessException;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public class ChannelFactory {
    private Logger _logger = LogManager.getLogger(ChannelFactory.class);
    private DataSource _internalDataSource;
    private SaasProvisioningEventTracker _eventTracker;
    private ProvisionerClusterManager _clusterManager = new NoopProvisionerClusterManager();
    private Set<String> _validatedServerUrls = new HashSet<String>();
    private PlatformTransactionManager _transactionManager;

    public void setEventTracker(SaasProvisioningEventTracker eventTracker) {
        this._eventTracker = eventTracker;
    }

    public void setClusterManager(ProvisionerClusterManager clusterManager) {
        this._clusterManager = clusterManager;
    }

    public void setInternalDataSource(DataSource internalDataSource) {
        this._internalDataSource = internalDataSource;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this._transactionManager = transactionManager;
    }

    public List<ProvisioningChannel> createActiveChannels() throws MetaDataAccessException {
        this._validatedServerUrls.clear();
        ArrayList<ProvisioningChannel> channels = new ArrayList<ProvisioningChannel>();
        Boolean hasSubGroupColumn = (Boolean)JdbcUtils.extractDatabaseMetaData((DataSource)this._internalDataSource, (DatabaseMetaDataCallback)new JdbcMetadataCallback());
        for (ProvisionerConfig config : ProvisionerManager.getProvisionerConfigs()) {
            ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
            SpConnection spConnection = connectionManager.getSpConnection(config.getEntityId());
            if (spConnection == null || !spConnection.isActive() || !connectionManager.passesFilterByServerSettings(spConnection, false)) continue;
            ArrayList<Integer> prevChannelIds = new ArrayList<Integer>();
            for (Channel dChannel : config.getChannels()) {
                if (!dChannel.isActive() || !this.validateChannel(dChannel)) continue;
                try {
                    int channelId = dChannel.getId();
                    String channelCode = "channel" + channelId;
                    ChannelSource dChannelSource = dChannel.getSource();
                    GuidFormatter directoryServerGuidFormatter = this.createGuidFormatter(dChannelSource);
                    DirectoryIdentityAttributesMapper directoryIdentityAttributesMapper = this.createDirectoryIdentityAttributesMapper(dChannelSource, directoryServerGuidFormatter);
                    DirectoryGroupAttributesMapper directoryGroupAttributesMapper = this.createDirectoryGroupAttributesMapper(directoryServerGuidFormatter);
                    boolean restrictAttributeSyncFilter = true;
                    DirectoryDriver directoryServer = this.createDirectoryServer(dChannelSource, directoryServerGuidFormatter, directoryIdentityAttributesMapper, directoryGroupAttributesMapper, restrictAttributeSyncFilter);
                    SaasTarget target = config.getTarget();
                    ProvisioningEventLogger provisioningEventLogger = new ProvisioningEventLogger(channelId, dChannel.getName(), SaasProvisioningCycleIdHelper.getInstance().getCycleId(), config.getEntityId());
                    SaasProvisionerPlugin saasDriver = this.createSaasDriver(target, channelId, config.getEntityId(), provisioningEventLogger);
                    GenericUserProvisioningChannel channel = new GenericUserProvisioningChannel();
                    channel.setConnectionId(config.getEntityId());
                    channel.setCode(channelCode);
                    channel.setName(dChannel.getName());
                    channel.setChannelId(channelId);
                    channel.setDirectoryDriver(directoryServer);
                    channel.setSaasDriver(saasDriver);
                    JdbcUserStore jdbcUserStore = new JdbcUserStore(this._internalDataSource, channelId);
                    UserStoreWithEventTracking userStoreWithEventTracking = new UserStoreWithEventTracking(jdbcUserStore, channelId, this._eventTracker);
                    channel.setUserStore(userStoreWithEventTracking);
                    ArrayList<Integer> prevChannelIdsCopy = new ArrayList<Integer>(prevChannelIds);
                    JdbcGroupMembershipStore membershipStore = new JdbcGroupMembershipStore(this._internalDataSource, channelId, hasSubGroupColumn);
                    JdbcGroupStore jdbcGroupStore = new JdbcGroupStore(this._internalDataSource, channelId, prevChannelIdsCopy, membershipStore);
                    GroupStoreWithEventTracking groupStoreWithEventTracking = new GroupStoreWithEventTracking(jdbcGroupStore, channelId, this._eventTracker);
                    channel.setGroupStore(groupStoreWithEventTracking);
                    channel.setGroupMembershipStore(membershipStore);
                    channel.setSubGroupColumn(hasSubGroupColumn);
                    channel.setVariableStore(new JdbcVariableStore(this._internalDataSource, channelId));
                    channel.setPassiveProvisioningGroupDnForUsers(dChannelSource.getGroupDNForUsers());
                    channel.setPassiveProvisioningFilterForUsers(dChannelSource.getFilterForUsers());
                    channel.setPassiveProvisioningGroupDnForGroups(dChannelSource.getGroupDNForGroups());
                    channel.setPassiveProvisioningGroupFilterForGroups(dChannelSource.getGroupFilterForGroups());
                    channel.setMaxSaasThreads(dChannel.getMaxThreads());
                    channel.setTimeout(dChannel.getTimeout());
                    channel.setIdentityMapper(this.createIdentityMapper(channelCode, dChannel));
                    channel.setUserNestedSearch(dChannelSource.isUserNestedSearch());
                    channel.setGroupNestedSearch(dChannelSource.isGroupNestedSearch());
                    channel.setClusterManager(this._clusterManager);
                    channel.setIdentityMappingHash(dChannel.getIdentityMappingHash());
                    channel.setProvisioningEventLogger(provisioningEventLogger);
                    channel.setTransactionTemplate(new TransactionTemplate(this._transactionManager));
                    prevChannelIds.add(channelId);
                    channels.add(channel);
                }
                catch (Exception e) {
                    this._logger.error("Cannot create channel: " + dChannel.getId() + ". " + dChannel.getName(), (Throwable)e);
                }
            }
        }
        return channels;
    }

    public GuidFormatter createGuidFormatter(ChannelSource channelSource) throws Exception {
        LdapGuidFormatter domainLdapGuidFormatter = channelSource.getGuidFormatter();
        SpringLdapGuidFormatter directoryServerGuidFormatter = new SpringLdapGuidFormatter();
        directoryServerGuidFormatter.setGuidAttributeName(domainLdapGuidFormatter.getGuidAttributeName());
        directoryServerGuidFormatter.setGuidIsBinary(domainLdapGuidFormatter.isGuidIsBinary());
        return directoryServerGuidFormatter;
    }

    public DirectoryIdentityAttributesMapper createDirectoryIdentityAttributesMapper(ChannelSource channelSource, GuidFormatter guidFormatter) throws Exception {
        BaseAccountStatusReader statusReader;
        DirectoryIdentityAttributesMapper identityMapper = new DirectoryIdentityAttributesMapper();
        String accountStatusAlgorithmCode = channelSource.getAccountStatusAlgorithm();
        if ("Active Directory Bitmap".equals(accountStatusAlgorithmCode)) {
            statusReader = new ActiveDirectoryAccountStatusReader();
        } else if ("Flag".equals(accountStatusAlgorithmCode)) {
            FlagAccountStatusReader flagStatusReader = new FlagAccountStatusReader();
            flagStatusReader.setComparisonValue(channelSource.getFlagComparisonValue());
            flagStatusReader.setComparisonValueStatus(channelSource.isFlagComparisonStatus());
            statusReader = flagStatusReader;
        } else {
            throw new Exception("Unknown account status algorithm: " + accountStatusAlgorithmCode);
        }
        statusReader.setAttributeName(channelSource.getAccountStatusAttributeName());
        statusReader.setDefault(channelSource.isDefaultStatus());
        identityMapper.setStatusReader(statusReader);
        identityMapper.setGuidFormatter(guidFormatter);
        return identityMapper;
    }

    public DirectoryGroupAttributesMapper createDirectoryGroupAttributesMapper(GuidFormatter guidFormatter) throws Exception {
        DirectoryGroupAttributesMapper groupMapper = new DirectoryGroupAttributesMapper();
        groupMapper.setGuidFormatter(guidFormatter);
        return groupMapper;
    }

    public DirectoryDriver createDirectoryServer(ChannelSource channelSource, GuidFormatter directoryServerGuidFormatter, DirectoryIdentityAttributesMapper identityMapper, DirectoryGroupAttributesMapper groupMapper, boolean restrictAttributeSyncFilter) throws Exception {
        BaseChangedUsersAlgorithm changedUsersAlgorithm;
        SpringLdapDirectoryDriver directoryDriver = new SpringLdapDirectoryDriver(channelSource.getDataSourceId());
        directoryDriver.setTimestampAttributeName(channelSource.getTimeStampAttributeName());
        TimestampChangedUsersAlgorithm timestampChangedUsersAlgorithm = new TimestampChangedUsersAlgorithm(directoryDriver);
        String changedUsersAlgorithmCode = channelSource.getChangedUsersAlgorithm();
        if ("Active Directory USN".equals(changedUsersAlgorithmCode)) {
            UsnChangedUsersAlgorithm usnChangedUsersAlgorithm = new UsnChangedUsersAlgorithm(directoryDriver);
            usnChangedUsersAlgorithm.setUsnAttributeName(channelSource.getUsnAttributeName());
            usnChangedUsersAlgorithm.setUsersBaseDn(channelSource.getUsersBaseDN());
            if (restrictAttributeSyncFilter) {
                usnChangedUsersAlgorithm.setMemberOfGroupAttribute(channelSource.getMemberOfGroupAttributeName());
                usnChangedUsersAlgorithm.setProvisioningGroupDnForGroups(channelSource.getGroupDNForGroups());
                usnChangedUsersAlgorithm.setProvisioningGroupFilterForGroups(channelSource.getGroupFilterForGroups());
            }
            changedUsersAlgorithm = usnChangedUsersAlgorithm;
        } else if ("Timestamp".equals(changedUsersAlgorithmCode)) {
            timestampChangedUsersAlgorithm.setTimestampAttributeName(channelSource.getTimeStampAttributeName());
            timestampChangedUsersAlgorithm.setUsersBaseDn(channelSource.getUsersBaseDN());
            if (restrictAttributeSyncFilter) {
                timestampChangedUsersAlgorithm.setMemberOfGroupAttribute(channelSource.getMemberOfGroupAttributeName());
                timestampChangedUsersAlgorithm.setProvisioningGroupDnForGroups(channelSource.getGroupDNForGroups());
                timestampChangedUsersAlgorithm.setProvisioningGroupFilterForGroups(channelSource.getGroupFilterForGroups());
            }
            changedUsersAlgorithm = timestampChangedUsersAlgorithm;
        } else if ("Timestamp No Negation".equals(changedUsersAlgorithmCode)) {
            timestampChangedUsersAlgorithm.setNoNot(true);
            timestampChangedUsersAlgorithm.setTimestampAttributeName(channelSource.getTimeStampAttributeName());
            timestampChangedUsersAlgorithm.setUsersBaseDn(channelSource.getUsersBaseDN());
            if (restrictAttributeSyncFilter) {
                timestampChangedUsersAlgorithm.setMemberOfGroupAttribute(channelSource.getMemberOfGroupAttributeName());
                timestampChangedUsersAlgorithm.setProvisioningGroupDnForGroups(channelSource.getGroupDNForGroups());
                timestampChangedUsersAlgorithm.setProvisioningGroupFilterForGroups(channelSource.getGroupFilterForGroups());
            }
            changedUsersAlgorithm = timestampChangedUsersAlgorithm;
        } else {
            throw new Exception("Unknown chaged users algorithm: " + changedUsersAlgorithmCode);
        }
        directoryDriver.setChangedUsersAlgorithm(changedUsersAlgorithm);
        directoryDriver.setGroupMemberAttributeName(channelSource.getGroupMemberAttributeName());
        directoryDriver.setMemberOfGroupAttributeName(channelSource.getMemberOfGroupAttributeName());
        directoryDriver.setGuidFormatter(directoryServerGuidFormatter);
        directoryDriver.setUsersBaseDn(channelSource.getUserBaseDN());
        directoryDriver.setDirectoryIdentityAttributesMapper(identityMapper);
        directoryDriver.setDirectoryGroupAttributesMapper(groupMapper);
        directoryDriver.setUserObjectClass(channelSource.getUserObjectClass());
        directoryDriver.setGroupObjectClass(channelSource.getGroupObjectClass());
        String dsId = channelSource.getDataSourceId();
        LdapDataSource dataSource = MgmtFactory.getDataSourceManager().getLdapDataSource(dsId);
        if (dataSource.isActiveDirectoryType()) {
            directoryDriver.setNestedMemberOfGroupAttributeName(directoryDriver.getMemberOfGroupAttributeName() + ":1.2.840.113556.1.4.1941:");
        } else if (dataSource.isSunOneType() || dataSource.isOracleUnifiedDirectoryType() || dataSource.isPingDirectoryOrPingDSType()) {
            directoryDriver.setNestedMemberOfGroupAttributeName("isMemberOf");
        }
        return directoryDriver;
    }

    private SaasProvisionerPlugin createSaasDriver(SaasTarget saasTarget, int channelId, String entityId, ProvisioningEventLogger provisioningEventLogger) throws Exception {
        PluginFipsStatus fipsStatus;
        SaasPluginManager saasPluginManager = SaasPluginManager.getInstance();
        BaseSaasPlugin saasPlugin = (BaseSaasPlugin)saasPluginManager.getPluginInstance(saasTarget.getPluginId());
        if (saasPlugin == null) {
            throw new Exception("Cannot get SaaS Plugin Instance for: " + saasTarget.getPluginId());
        }
        if (PropertyInfo.isBCFIPSMode() && (fipsStatus = AdapterUtils.getPluginFipsStatus((String)saasPlugin.getClass().getName(), saasPlugin.getMetadata())) != PluginFipsStatus.COMPLIANT) {
            this._logger.warn("'" + saasPlugin.getId() + "' FIPS status: " + fipsStatus + " (" + saasPlugin.getDescription() + ", " + saasPlugin.getClass().getName() + ")");
        }
        saasPlugin.setParameters((FieldList)saasTarget.getParameterValues());
        saasPlugin.setChannelId(channelId);
        saasPlugin.setEventTracker(this._eventTracker);
        saasPlugin.setProvisioningEventLogger(provisioningEventLogger);
        SpConnection conn = MgmtFactory.getConnectionManager().getSpConnection(entityId);
        saasPlugin.setSpConnection(conn);
        return saasPlugin;
    }

    public IdentityMapper createIdentityMapper(String channelCode, Channel dChannel) {
        String saasUsernameFieldCode = dChannel.getSaasUsernameFieldCode();
        ArrayList<FieldInfo> fieldInfos = new ArrayList<FieldInfo>();
        HashMap<String, FieldConfig> fieldConfigs = new HashMap<String, FieldConfig>();
        for (IdentityMappingField identityMappingField : dChannel.getIdentityMapping()) {
            String fieldCode = identityMappingField.getFieldName();
            fieldInfos.add(identityMappingField.getFieldInfo());
            fieldConfigs.put(fieldCode, identityMappingField.getFieldConfig());
        }
        IdentityMapper identityMapper = IdentityMapper.createIdentityMapper(channelCode, saasUsernameFieldCode, fieldInfos, fieldConfigs);
        this.createSpecialAttributeNamesSet(dChannel);
        identityMapper.setSpecialAttributeNames(this.createSpecialAttributeNamesSet(dChannel));
        return identityMapper;
    }

    private Set<String> createSpecialAttributeNamesSet(Channel dChannel) {
        HashSet<String> specialAttributeNames = new HashSet<String>();
        ChannelSource source = dChannel.getSource();
        specialAttributeNames.add(source.getGuidFormatter().getGuidAttributeName());
        String memberOfGroupAttributeName = source.getMemberOfGroupAttributeName();
        if (memberOfGroupAttributeName != null && memberOfGroupAttributeName.trim().length() > 0) {
            specialAttributeNames.add(memberOfGroupAttributeName);
        }
        specialAttributeNames.add(source.getTimeStampAttributeName());
        if ("Active Directory USN".equals(source.getChangedUsersAlgorithm())) {
            specialAttributeNames.add(source.getUsnAttributeName());
        }
        specialAttributeNames.add(source.getAccountStatusAttributeName());
        return specialAttributeNames;
    }

    private boolean validateChannel(Channel dChannel) {
        ExpressionManager expressionManager = ExpressionManager.getInstance();
        if (!expressionManager.isEvaluateExpressionsOn()) {
            for (IdentityMappingField identityMappingField : dChannel.getIdentityMapping()) {
                FieldConfig fieldConfig = identityMappingField.getFieldConfig();
                if (!fieldConfig.hasScript()) continue;
                String fieldCode = identityMappingField.getFieldName();
                this._logger.error("Expressions disabled but channel " + dChannel.getId() + " uses them for field: " + fieldCode + ". Channel dropped.");
                return false;
            }
        }
        return true;
    }
}

