/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.channel.runner;

import com.pingidentity.provisioner.channel.ProvisioningChannel;
import com.pingidentity.provisioner.cluster.ClusteringException;
import com.pingidentity.provisioner.cluster.ProvisionerClusterManager;
import com.pingidentity.provisioner.cluster.StopProvisionerException;
import com.pingidentity.provisioner.monitor.SaasProvisioningCycleIdHelper;
import com.pingidentity.provisioner.monitor.SaasProvisioningEventTracker;
import com.pingidentity.provisioner.saas.SaasException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.slf4j.MDC;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class SequentialChannelRunner
extends TimerTask {
    private static Logger _logger = LogManager.getLogger(SequentialChannelRunner.class);
    private boolean _active = false;
    private boolean _stopped = false;
    private List<ProvisioningChannel> _channels;
    private long _runPeriodMillis;
    private ProvisionerClusterManager _clusterManager;
    private SaasProvisioningEventTracker _eventTracker;
    private Map<String, Map<String, Integer>> connectionToUnManagedUsers;
    private long _waitForCleanStopMillis = 5000L;

    public SequentialChannelRunner(List<ProvisioningChannel> channels, long runPeriodMillis, ProvisionerClusterManager clusterManager, SaasProvisioningEventTracker eventTracker) {
        this._channels = channels;
        this._runPeriodMillis = runPeriodMillis;
        this._clusterManager = clusterManager;
        this._eventTracker = eventTracker;
        this.connectionToUnManagedUsers = new HashMap<String, Map<String, Integer>>();
    }

    public List<ProvisioningChannel> getChannels() {
        return this._channels;
    }

    public long getRunPeriodMillis() {
        return this._runPeriodMillis;
    }

    public void startChannels() {
        if (!MgmtFactory.getAdminNodeConfigManager().isEnabledAndPassiveNode()) {
            for (ProvisioningChannel channel : this.getChannels()) {
                try {
                    channel.start();
                }
                catch (SaasException e) {
                    _logger.error("Could not start channel: " + channel.getChannelCode(), (Throwable)e);
                }
            }
        } else {
            _logger.trace("Provisioning channels are disabled on passive admin servers.");
        }
    }

    public void stopChannels() {
        long waitStart;
        this._stopped = true;
        for (ProvisioningChannel channel : this.getChannels()) {
            try {
                _logger.info("Stopping channel: " + channel.getChannelCode() + "...");
                channel.stop();
            }
            catch (SaasException e) {
                _logger.error("Could not stop channel: " + channel.getChannelCode(), (Throwable)e);
            }
        }
        long waitCurrent = waitStart = System.currentTimeMillis();
        while (this._active) {
            waitCurrent = System.currentTimeMillis();
            if (waitCurrent - waitStart <= this._waitForCleanStopMillis) continue;
            _logger.error("Cannot wait for clean Sequential Channel Runner stop!");
            break;
        }
        if (!this._active) {
            _logger.info("Sequential Channel Runner cleanly stopped in: " + (waitCurrent - waitStart) + " milliseconds");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this._active) {
            _logger.warn("Previous sync cycle still active, skipping this one!");
            return;
        }
        boolean isProvisionerCycleStopped = false;
        try {
            this._active = true;
            if (this._clusterManager.isActiveNode()) {
                _logger.debug("This is the active node: " + this._clusterManager.getNodeId());
                long timeStart = System.currentTimeMillis();
                SaasProvisioningCycleIdHelper.getInstance().generateNewCycleId();
                this._eventTracker.trackEvent(SaasProvisioningEventTracker.EventType.START_CYCLE);
                MDC.put((String)"cycle_id", (String)String.valueOf(SaasProvisioningCycleIdHelper.getInstance().getCycleId()));
                _logger.debug("Starting provisioning cycle: " + SaasProvisioningCycleIdHelper.getInstance().getCycleId());
                HashMap<String, HashSet<String>> connectionToUsersMap = new HashMap<String, HashSet<String>>();
                for (ProvisioningChannel channel : this.getChannels()) {
                    if (this._stopped) {
                        throw new StopProvisionerException("Sequential Channel Runner stopped!");
                    }
                    try {
                        Map<String, Integer> unManagedUsers;
                        MDC.put((String)"ChannelCode", (String)String.valueOf(channel.getChannelId()));
                        long channelTimeStart = System.currentTimeMillis();
                        String connectionId = channel.getConnectionId();
                        HashSet<String> usersToIgnore = (HashSet<String>)connectionToUsersMap.get(connectionId);
                        if (usersToIgnore == null) {
                            usersToIgnore = new HashSet<String>();
                        }
                        if ((unManagedUsers = this.connectionToUnManagedUsers.get(connectionId)) == null) {
                            unManagedUsers = new HashMap<String, Integer>();
                            this.connectionToUnManagedUsers.put(connectionId, unManagedUsers);
                        }
                        Set<String> usersManagedByChannel = channel.run(usersToIgnore, unManagedUsers);
                        usersToIgnore.addAll(usersManagedByChannel);
                        connectionToUsersMap.put(connectionId, usersToIgnore);
                        long channelTimeEnd = System.currentTimeMillis();
                        _logger.info("Channel cycle: " + (channelTimeEnd - channelTimeStart) + " milliseconds.");
                    }
                    catch (Exception e) {
                        _logger.error("Channel run error!", (Throwable)e);
                    }
                    finally {
                        channel.getProvisioningEventLogger().logCycleSummary();
                        MDC.remove((String)"ChannelCode");
                    }
                }
                long timeEnd = System.currentTimeMillis();
                if (this.getChannels().size() > 1) {
                    _logger.info("Total channels cycle: " + (timeEnd - timeStart) + " milliseconds.");
                }
                if (timeEnd - timeStart > this.getRunPeriodMillis()) {
                    _logger.warn("Total channels cycle time greater than cycle period: " + (timeEnd - timeStart) + " vs " + this.getRunPeriodMillis() + " milliseconds!");
                }
            } else {
                this._clusterManager.sendHeartBeat();
                _logger.info("Backup node, provisioning cycle skipped.");
            }
        }
        catch (StopProvisionerException e) {
            _logger.info("Provisioner forced down!");
            _logger.debug("Provisioner forced down!", (Throwable)e);
            isProvisionerCycleStopped = true;
        }
        catch (ClusteringException e) {
            _logger.error("Cannot run provisioning channels!", (Throwable)e);
        }
        catch (RuntimeException e) {
            _logger.error("Unknown runtime exception while running channels!", (Throwable)e);
        }
        finally {
            this._active = false;
            try {
                if (isProvisionerCycleStopped || this._clusterManager.isActiveNode()) {
                    this._eventTracker.trackEvent(SaasProvisioningEventTracker.EventType.STOP_CYCLE);
                }
            }
            catch (ClusteringException e) {
                _logger.error("Unable to determine if active node.", (Throwable)e);
            }
            catch (RuntimeException e) {
                _logger.error("Unknown runtime exception while tracking STOP_CYCLE event", (Throwable)e);
            }
            MDC.remove((String)"cycle_id");
        }
    }
}

