/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.channel.synchronous;

import com.pingidentity.provisioner.channel.synchronous.SynchronousSaasGroupRunner;
import com.pingidentity.provisioner.channel.synchronous.SynchronousSaasRunner;
import com.pingidentity.provisioner.channel.synchronous.SynchronousSaasUserRunner;
import com.pingidentity.provisioner.cluster.ClusteringException;
import com.pingidentity.provisioner.cluster.ProvisionerClusterManager;
import com.pingidentity.provisioner.cluster.RuntimeClusteringException;
import com.pingidentity.provisioner.identity.SaasGroup;
import com.pingidentity.provisioner.identity.SaasIdentity;
import com.pingidentity.provisioner.monitor.ProvisioningEventLogger;
import com.pingidentity.provisioner.resources.SaasProvisionableResource;
import com.pingidentity.provisioner.saas.SaasException;
import com.pingidentity.provisioner.saas.SaasProvisionerPlugin;
import com.pingidentity.provisioner.store.DataStoreUpdater;
import com.pingidentity.provisioner.store.SaasProvisionableResourceCallback;
import com.pingidentity.provisioner.store.UserStoreUpdater;
import com.pingidentity.provisioner.store.groups.GroupStoreUpdater;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SynchronousSaasCallback
implements SaasProvisionableResourceCallback {
    private static Logger _logger = LogManager.getLogger(SynchronousSaasCallback.class);
    private SaasProvisionerPlugin _saasDriver;
    private long _timeoutMillis;
    private ProvisionerClusterManager _clusterManager;
    private Set<String> _provisionedGroups;
    private final ProvisioningEventLogger _provisioningEventLogger;

    public SynchronousSaasCallback(SaasProvisionerPlugin saasDriver, long timeoutMillis, ProvisionerClusterManager clusterManager, Set<String> provisionedGroups, ProvisioningEventLogger provisioningEventLogger) {
        this._saasDriver = saasDriver;
        this._timeoutMillis = timeoutMillis;
        this._clusterManager = clusterManager;
        this._provisionedGroups = provisionedGroups;
        this._provisioningEventLogger = provisioningEventLogger;
    }

    @Override
    public void start() throws SaasException {
        if (!this._saasDriver.isSessionStarted()) {
            this._saasDriver.startSession();
        }
        this._saasDriver.checkSession();
    }

    @Override
    public void stop() throws SaasException {
    }

    @Override
    public void process(SaasProvisionableResource provisionableResource, DataStoreUpdater updater, String sourceGuid) throws SaasException {
        try {
            this._clusterManager.sendHeartBeat();
        }
        catch (ClusteringException e) {
            throw new RuntimeClusteringException(e);
        }
        SynchronousSaasRunner synchronousSaasRunner = null;
        if (provisionableResource instanceof SaasIdentity) {
            synchronousSaasRunner = new SynchronousSaasUserRunner(this._saasDriver, (SaasIdentity)provisionableResource, (UserStoreUpdater)updater, sourceGuid);
        } else if (provisionableResource instanceof SaasGroup) {
            boolean mergeMembership = this._provisionedGroups.contains(provisionableResource.getInternalGuid());
            synchronousSaasRunner = new SynchronousSaasGroupRunner(this._saasDriver, (SaasGroup)provisionableResource, (GroupStoreUpdater)updater, sourceGuid, mergeMembership, this._provisioningEventLogger);
        } else {
            throw new SaasException("Unable to start SynchronousSaasRunner thread. provisionableResource is not of a supported type: " + provisionableResource.toString());
        }
        this.startThread(synchronousSaasRunner, provisionableResource);
    }

    private void startThread(SynchronousSaasRunner synchronousSaasRunner, SaasProvisionableResource provisionableResource) throws SaasException {
        Thread saasThread = new Thread(synchronousSaasRunner);
        saasThread.start();
        try {
            saasThread.join(this._timeoutMillis);
        }
        catch (InterruptedException e) {
            _logger.error("SaaS call interrupted!", (Throwable)e);
            return;
        }
        if (saasThread.isAlive()) {
            saasThread.interrupt();
            _logger.error("SaaS call timed out at " + this._timeoutMillis + " milliseconds.");
            return;
        }
        if (synchronousSaasRunner.hasSaasException()) {
            SaasException e = synchronousSaasRunner.getSaasException();
            String resourceName = provisionableResource != null ? provisionableResource.getName() : "";
            _logger.error("Cannot process resource: " + resourceName, (Throwable)e);
            if (e.isStopSession()) {
                throw e;
            }
        }
    }
}

