/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.channel.synchronous;

import com.pingidentity.provisioner.channel.synchronous.SynchronousSaasRunner;
import com.pingidentity.provisioner.identity.SaasGroup;
import com.pingidentity.provisioner.monitor.ProvisioningEventLogger;
import com.pingidentity.provisioner.monitor.SaasProvisioningEventTracker;
import com.pingidentity.provisioner.saas.BaseSaasPlugin;
import com.pingidentity.provisioner.saas.SaasException;
import com.pingidentity.provisioner.saas.SaasProvisionerPlugin;
import com.pingidentity.provisioner.saas.SaasProvisionerPluginGroupsExtension;
import com.pingidentity.provisioner.saas.SaasProvisionerPluginGroupsWithMembersExt;
import com.pingidentity.provisioner.store.groups.GroupStoreUpdater;

class SynchronousSaasGroupRunner
implements SynchronousSaasRunner {
    private final SaasGroupPluginWrapper _saasPluginWrapper;
    private SaasGroup _saasGroup;
    private GroupStoreUpdater _groupStoreUpdater;
    private String _sourceGuid;
    private SaasException _saasException;
    private boolean _mergeMembership;

    public SynchronousSaasGroupRunner(SaasProvisionerPlugin saasPlugin, SaasGroup saasGroup, GroupStoreUpdater groupUpdater, String sourceGuid, boolean mergeMembership, ProvisioningEventLogger _provisioningEventLogger) {
        this._saasPluginWrapper = new SaasGroupPluginWrapper(saasPlugin, _provisioningEventLogger);
        this._saasGroup = saasGroup;
        this._groupStoreUpdater = groupUpdater;
        this._sourceGuid = sourceGuid;
        this._mergeMembership = mergeMembership;
    }

    @Override
    public void run() {
        block23: {
            try {
                if (this._saasGroup.isMarkedForDelete()) {
                    SaasException saasException = null;
                    SaasProvisioningEventTracker.EventType eventType = null;
                    try {
                        eventType = SaasProvisioningEventTracker.EventType.DELETE_GROUP;
                        this._saasPluginWrapper.deleteGroup(this._saasGroup);
                        this._groupStoreUpdater.clearDirtyFlag();
                        break block23;
                    }
                    catch (SaasException e) {
                        saasException = e;
                        throw e;
                    }
                    finally {
                        BaseSaasPlugin baseSaasPlugin = (BaseSaasPlugin)this._saasPluginWrapper.getPlugin();
                        if (baseSaasPlugin.getSaasProvisioningEventTracker() != null && eventType != null) {
                            String targetId = this._saasGroup.getName();
                            baseSaasPlugin.getSaasProvisioningEventTracker().trackEvent(this._sourceGuid, targetId, eventType, baseSaasPlugin.getChannelId(), saasException);
                        }
                    }
                }
                SaasException saasException = null;
                SaasProvisioningEventTracker.EventType eventType = null;
                try {
                    if (!this._saasPluginWrapper.doesGroupExist(this._saasGroup)) {
                        eventType = SaasProvisioningEventTracker.EventType.CREATE_GROUP;
                        String returnedSaasGuid = this._saasPluginWrapper.createGroup(this._saasGroup);
                        if (returnedSaasGuid != null) {
                            this._groupStoreUpdater.setSaasGuid(returnedSaasGuid);
                        }
                        if (this._groupStoreUpdater.isMarkForSecondProv()) {
                            this._groupStoreUpdater.markGroupForSecondPhase();
                        } else {
                            this._groupStoreUpdater.clearDirtyFlag();
                        }
                    } else {
                        eventType = SaasProvisioningEventTracker.EventType.UPDATE_GROUP;
                        String guid = this._saasPluginWrapper.updateGroup(this._saasGroup, this._mergeMembership);
                        if (guid != null) {
                            this._saasGroup.setGuid(guid);
                        }
                        this._groupStoreUpdater.setSaasGuid(this._saasGroup.getGuid());
                        if (this._groupStoreUpdater.isMarkForSecondProv()) {
                            this._groupStoreUpdater.markGroupForSecondPhase();
                        } else {
                            this._groupStoreUpdater.clearDirtyFlag();
                        }
                    }
                }
                catch (SaasException e) {
                    saasException = e;
                    throw e;
                }
                finally {
                    BaseSaasPlugin baseSaasPlugin = (BaseSaasPlugin)this._saasPluginWrapper.getPlugin();
                    if (baseSaasPlugin.getSaasProvisioningEventTracker() != null && eventType != null) {
                        String targetId = this._saasGroup.getName();
                        baseSaasPlugin.getSaasProvisioningEventTracker().trackEvent(this._sourceGuid, targetId, eventType, baseSaasPlugin.getChannelId(), saasException);
                    }
                }
            }
            catch (SaasException e) {
                this._saasException = e;
            }
        }
    }

    @Override
    public boolean hasSaasException() {
        return this._saasException != null;
    }

    @Override
    public SaasException getSaasException() {
        return this._saasException;
    }

    private static class SaasGroupPluginWrapper {
        private SaasProvisionerPluginGroupsExtension _saasPlugin;
        private SaasProvisionerPluginGroupsWithMembersExt _saasPlugin2;
        private final ProvisioningEventLogger _provisioningEventLogger;

        public SaasGroupPluginWrapper(SaasProvisionerPlugin groupPlugin, ProvisioningEventLogger provisioningEventLogger) {
            this._provisioningEventLogger = provisioningEventLogger;
            if (groupPlugin instanceof SaasProvisionerPluginGroupsWithMembersExt) {
                this._saasPlugin2 = (SaasProvisionerPluginGroupsWithMembersExt)((Object)groupPlugin);
            } else if (groupPlugin instanceof SaasProvisionerPluginGroupsExtension) {
                this._saasPlugin = (SaasProvisionerPluginGroupsExtension)((Object)groupPlugin);
            } else {
                throw new IllegalArgumentException("Provisioner plugin doesn't support groups!");
            }
        }

        public boolean doesGroupExist(SaasGroup saasGroup) throws SaasException {
            if (this._saasPlugin2 != null) {
                return this._saasPlugin2.doesGroupExist(saasGroup);
            }
            if (this._saasPlugin != null) {
                return this._saasPlugin.doesGroupExist(saasGroup.getName());
            }
            return false;
        }

        public String updateGroup(SaasGroup saasGroup, boolean mergeMembership) throws SaasException {
            if (this._saasPlugin2 != null) {
                return this._saasPlugin2.updateGroup(saasGroup, mergeMembership);
            }
            if (this._saasPlugin != null) {
                saasGroup.setGuid(saasGroup.getName());
                this._saasPlugin.updateGroup(saasGroup);
            }
            return null;
        }

        public String createGroup(SaasGroup saasGroup) throws SaasException {
            this._provisioningEventLogger.newGroupPushedToTarget();
            if (this._saasPlugin2 != null) {
                return this._saasPlugin2.createGroup(saasGroup);
            }
            if (this._saasPlugin != null) {
                saasGroup.setGuid(saasGroup.getName());
                this._saasPlugin.createGroup(saasGroup);
                return saasGroup.getGuid();
            }
            return null;
        }

        public void deleteGroup(SaasGroup saasGroup) throws SaasException {
            this._provisioningEventLogger.groupDeprovisionedFromTarget();
            if (this._saasPlugin2 != null) {
                this._saasPlugin2.deleteGroup(saasGroup);
            } else if (this._saasPlugin != null) {
                this._saasPlugin.deleteGroup(saasGroup);
            }
        }

        public SaasProvisionerPlugin getPlugin() {
            if (this._saasPlugin2 != null) {
                return (SaasProvisionerPlugin)((Object)this._saasPlugin2);
            }
            if (this._saasPlugin != null) {
                return (SaasProvisionerPlugin)((Object)this._saasPlugin);
            }
            throw new IllegalStateException("SaasGroupPluginWrapper doesn't have an associated plugin!");
        }
    }
}

