/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.cli;

import com.pingidentity.provisioner.cli.CliException;
import com.pingidentity.provisioner.cli.InternalDbCommand;
import com.pingidentity.provisioner.resources.SaasProvisionableResource;
import com.pingidentity.provisioner.saas.SaasException;
import com.pingidentity.provisioner.store.DataStoreUpdater;
import com.pingidentity.provisioner.store.SaasProvisionableResourceCallback;
import com.pingidentity.provisioner.store.groups.GroupStore;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class ClearDirtyGroupsCommand
extends InternalDbCommand {
    @Override
    protected Option createOption() {
        return new Option(null, "clear-dirty-group-records", false, "Clear all dirty group records [c]");
    }

    @Override
    public void execute(CommandLine cli, Options options) throws CliException {
        GroupStore groupStore = this.getGroupStore(this.getChannelId(cli));
        ClearDirtyGroupsCallback callback = new ClearDirtyGroupsCallback();
        try {
            groupStore.processDirty(callback, null);
        }
        catch (SaasException e) {
            throw new CliException("Cannot clear dirty group records!", e);
        }
        this._out.println("Cleared groups: " + callback.getCnt());
    }

    private static class ClearDirtyGroupsCallback
    implements SaasProvisionableResourceCallback {
        private int _cnt = 0;

        private ClearDirtyGroupsCallback() {
        }

        @Override
        public void start() throws SaasException {
        }

        @Override
        public void process(SaasProvisionableResource saasGroup, DataStoreUpdater groupStoreUpdater, String sourceGuid) throws SaasException {
            ++this._cnt;
            groupStoreUpdater.clearDirtyFlag();
        }

        @Override
        public void stop() throws SaasException {
        }

        public int getCnt() {
            return this._cnt;
        }
    }
}

