/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.cli;

import com.pingidentity.provisioner.cli.CliException;
import com.pingidentity.provisioner.cli.InternalDbCommand;
import com.pingidentity.provisioner.resources.SaasProvisionableResource;
import com.pingidentity.provisioner.saas.SaasException;
import com.pingidentity.provisioner.store.DataStoreUpdater;
import com.pingidentity.provisioner.store.SaasProvisionableResourceCallback;
import com.pingidentity.provisioner.store.UserStore;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class ClearDirtyUsersCommand
extends InternalDbCommand {
    @Override
    protected Option createOption() {
        return new Option(null, "clear-dirty-user-records", false, "Clear all dirty user records [c]");
    }

    @Override
    public void execute(CommandLine cli, Options options) throws CliException {
        UserStore userStore = this.getUserStore(this.getChannelId(cli));
        ClearDirtyUsersCallback callback = new ClearDirtyUsersCallback();
        try {
            userStore.processDirty(callback, null);
        }
        catch (SaasException e) {
            throw new CliException("Cannot clear dirty user records!", e);
        }
        this._out.println("Cleared users: " + callback.getCnt());
    }

    private static class ClearDirtyUsersCallback
    implements SaasProvisionableResourceCallback {
        private int _cnt = 0;

        private ClearDirtyUsersCallback() {
        }

        @Override
        public void start() throws SaasException {
        }

        @Override
        public void process(SaasProvisionableResource saasIdentity, DataStoreUpdater updater, String sourceGuid) throws SaasException {
            ++this._cnt;
            updater.clearDirtyFlag();
        }

        @Override
        public void stop() throws SaasException {
        }

        public int getCnt() {
            return this._cnt;
        }
    }
}

