/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.cli;

import com.pingidentity.provisioner.cli.CliException;
import com.pingidentity.provisioner.cli.InternalDbCommand;
import com.pingidentity.provisioner.resources.SaasProvisionableResource;
import com.pingidentity.provisioner.saas.SaasException;
import com.pingidentity.provisioner.store.DataStoreUpdater;
import com.pingidentity.provisioner.store.SaasProvisionableResourceCallback;
import com.pingidentity.provisioner.store.groups.GroupStore;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class DeleteDirtyGroupsCommand
extends InternalDbCommand {
    @Override
    protected Option createOption() {
        return new Option(null, "delete-dirty-group-records", false, "Delete all dirty group records [c]");
    }

    @Override
    public void execute(CommandLine cli, Options options) throws CliException {
        GroupStore groupStore = this.getGroupStore(this.getChannelId(cli));
        DeleteDirtyGroupsCallback callback = new DeleteDirtyGroupsCallback(groupStore);
        try {
            groupStore.processDirty(callback, null);
        }
        catch (SaasException e) {
            throw new CliException("Cannot delete dirty group records!", e);
        }
        this._out.println("Deleted groups: " + callback.getCnt());
    }

    private static class DeleteDirtyGroupsCallback
    implements SaasProvisionableResourceCallback {
        private GroupStore _groupStore;
        private int _cnt = 0;

        private DeleteDirtyGroupsCallback(GroupStore groupStore) {
            this._groupStore = groupStore;
        }

        @Override
        public void start() throws SaasException {
        }

        @Override
        public void process(SaasProvisionableResource saasGroup, DataStoreUpdater groupStoreUpdater, String sourceGuid) throws SaasException {
            ++this._cnt;
            groupStoreUpdater.clearDirtyFlag();
            this._groupStore.removeIfNotDirty(sourceGuid);
        }

        @Override
        public void stop() throws SaasException {
        }

        public int getCnt() {
            return this._cnt;
        }
    }
}

