/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.cli;

import com.pingidentity.provisioner.cli.CliException;
import com.pingidentity.provisioner.cli.CommandLineTool;
import com.pingidentity.provisioner.cli.InternalDbCommand;
import com.pingidentity.provisioner.cluster.ClusteringException;
import com.pingidentity.provisioner.cluster.ProvisionerNodeRole;
import com.pingidentity.provisioner.store.jdbc.ProvisionerNodeStateDataManager;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class ForceNodeBackupCommand
extends InternalDbCommand {
    @Override
    protected Option createOption() {
        return new Option(null, "force-node-backup", false, "Force a node status to BACKUP in a failover environment [n]");
    }

    @Override
    public void execute(CommandLine cli, Options options) throws CliException {
        Properties run = CommandLineTool.getRunProperties();
        String mode = run.getProperty("pf.provisioner.mode", "").trim();
        if ("FAILOVER".equals(mode)) {
            ProvisionerNodeStateDataManager nodeStateDataManager = this.getProvisionerNodeStateDataManager();
            int nodeId = this.getNodeId(cli);
            ProvisionerNodeRole role = ProvisionerNodeRole.backup;
            try {
                nodeStateDataManager.setRole(nodeId, role);
            }
            catch (ClusteringException e) {
                throw new CliException("Cannot force node status to BACKUP! Node: " + nodeId, e);
            }
        } else {
            this._out.println("Not running in failover mode: " + mode);
        }
    }
}

