/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.cli;

import com.pingidentity.common.util.ldap.PingSslClientTrustManager;
import com.pingidentity.crypto.CertificateService;
import com.pingidentity.provisioner.cli.BaseCommand;
import com.pingidentity.provisioner.cli.CliException;
import com.pingidentity.provisioner.domain.ProvisionerGlobalSettings;
import com.pingidentity.provisioner.domain.mgmt.ProvisionerManager;
import com.pingidentity.provisioner.store.UserStore;
import com.pingidentity.provisioner.store.VariableStore;
import com.pingidentity.provisioner.store.groups.GroupMembershipStore;
import com.pingidentity.provisioner.store.groups.GroupStore;
import com.pingidentity.provisioner.store.jdbc.JdbcGroupMembershipStore;
import com.pingidentity.provisioner.store.jdbc.JdbcGroupStore;
import com.pingidentity.provisioner.store.jdbc.JdbcMetadataCallback;
import com.pingidentity.provisioner.store.jdbc.JdbcProvisionerNodeStateDataManager;
import com.pingidentity.provisioner.store.jdbc.JdbcUserStore;
import com.pingidentity.provisioner.store.jdbc.JdbcVariableStore;
import com.pingidentity.provisioner.store.jdbc.ProvisionerNodeStateDataManager;
import java.io.File;
import java.util.Collections;
import javax.sql.DataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.domain.JdbcDataSource;
import org.sourceid.saml20.domain.mgmt.DataSourceManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.TrustedCAsManager;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.SingleConnectionDataSource;
import org.springframework.jdbc.support.DatabaseMetaDataCallback;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.MetaDataAccessException;

public abstract class InternalDbCommand
extends BaseCommand {
    private static Logger _logger = LogManager.getLogger(InternalDbCommand.class);
    protected CertificateService certService = (CertificateService)GlobalRegistry.getService(CertificateService.class);
    protected DataSource _internalDataSource;
    protected boolean _isHsqldb;
    private boolean hasSubGroup;

    @Override
    public void init() throws CliException {
        Boolean hasSubGroupColumn;
        super.init();
        ProvisionerGlobalSettings provisionerGlobalSettings = ProvisionerManager.getProvisionerGlobalSettings();
        DataSourceManager dataSourceManager = MgmtFactory.getDataSourceManager();
        TrustedCAsManager trustedManager = MgmtFactory.getTrustedCAsManager();
        JdbcDataSource jdbcDataSource = null;
        String dataSourceId = provisionerGlobalSettings.getInternalDataSourceId();
        if (dataSourceId != null) {
            jdbcDataSource = dataSourceManager.getJdbcDataSource(dataSourceId);
        }
        if (jdbcDataSource == null) {
            throw new CliException("Provisioner not configured!");
        }
        String jdbcDriver = jdbcDataSource.getDriverClass();
        String jdbcUrl = this.expandJdbcUrl(jdbcDataSource.getConnectionUrlForNode());
        String jdbcUsername = jdbcDataSource.getUserName();
        String jdbcPassword = jdbcDataSource.getPassword();
        this._isHsqldb = jdbcDataSource.isEmbeddedHsqldb();
        _logger.info("JDBC Driver: " + jdbcDriver);
        _logger.info("JDBC URL: " + jdbcUrl);
        _logger.info("JDBC Username: " + jdbcUsername);
        _logger.info("JDBC Password: *****");
        _logger.info("Embedded HSQLDB: " + (this._isHsqldb ? "yes" : "no"));
        SingleConnectionDataSource dataSource = new SingleConnectionDataSource();
        dataSource.setDriverClassName(jdbcDriver);
        dataSource.setUrl(jdbcUrl);
        dataSource.setUsername(jdbcUsername);
        dataSource.setPassword(jdbcPassword);
        dataSource.setAutoCommit(true);
        this._internalDataSource = dataSource;
        try {
            hasSubGroupColumn = (Boolean)JdbcUtils.extractDatabaseMetaData((DataSource)this._internalDataSource, (DatabaseMetaDataCallback)new JdbcMetadataCallback());
            PingSslClientTrustManager pingLdapSslClientTrustManager = PingSslClientTrustManager.getInstance();
            pingLdapSslClientTrustManager.setTrustedCAs(trustedManager.getTrustedCaX509s());
        }
        catch (MetaDataAccessException e) {
            throw new CliException(e);
        }
        this.hasSubGroup = hasSubGroupColumn;
    }

    @Override
    public void destroy() throws CliException {
        if (this._isHsqldb) {
            JdbcTemplate jdbcTemplace = new JdbcTemplate(this._internalDataSource);
            jdbcTemplace.execute("SHUTDOWN");
        }
        super.destroy();
    }

    private String expandJdbcUrl(String url) {
        String url2 = url.replace("${jboss.server.data.dir}", System.getProperty("pf.server.default.dir") + File.separator + "data").replace("${/}", File.separator);
        return url2.replace("${pf.server.data.dir}", System.getProperty("pf.server.default.dir") + File.separator + "data").replace("${/}", File.separator);
    }

    protected UserStore getUserStore(int channelId) {
        return new JdbcUserStore(this._internalDataSource, channelId);
    }

    protected GroupStore getGroupStore(int channelId) {
        return new JdbcGroupStore(this._internalDataSource, channelId, Collections.emptyList(), null);
    }

    protected GroupMembershipStore getGroupMembershipStore(int channelId) {
        return new JdbcGroupMembershipStore(this._internalDataSource, channelId, this.hasSubGroup);
    }

    protected VariableStore getVariableStore(int channelId) {
        return new JdbcVariableStore(this._internalDataSource, channelId);
    }

    protected ProvisionerNodeStateDataManager getProvisionerNodeStateDataManager() {
        return new JdbcProvisionerNodeStateDataManager(this._internalDataSource);
    }
}

