/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.cli;

import com.pingidentity.provisioner.cli.CliException;
import com.pingidentity.provisioner.cli.InternalDbCommand;
import com.pingidentity.provisioner.resources.SaasProvisionableResource;
import com.pingidentity.provisioner.saas.SaasException;
import com.pingidentity.provisioner.store.DataStoreUpdater;
import com.pingidentity.provisioner.store.SaasProvisionableResourceCallback;
import com.pingidentity.provisioner.store.groups.GroupStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class ShowDirtyGroupsCommand
extends InternalDbCommand {
    private static final int COLUMNS = 4;

    @Override
    protected Option createOption() {
        return new Option(null, "show-dirty-group-records", false, "Show a list of all dirty group records [c]");
    }

    @Override
    public void execute(CommandLine cli, Options options) throws CliException {
        Vector<String> header = new Vector<String>(Arrays.asList("Cnt", "LDAP GUID", "SaaS Group Name", "SaaS GUID"));
        GroupStore groupStore = this.getGroupStore(this.getChannelId(cli));
        CollectDirtyGroupsCallback callback = new CollectDirtyGroupsCallback();
        try {
            groupStore.processDirty(callback, null);
        }
        catch (SaasException e) {
            throw new CliException("Cannot retrieve list of dirty group records!", e);
        }
        this.printTable(header, callback.getGroups(), 4);
    }

    private static class CollectDirtyGroupsCallback
    implements SaasProvisionableResourceCallback {
        private List<Vector<String>> groups = new ArrayList<Vector<String>>();
        private int _cnt = 0;

        private CollectDirtyGroupsCallback() {
        }

        @Override
        public void start() throws SaasException {
        }

        @Override
        public void process(SaasProvisionableResource saasGroup, DataStoreUpdater groupStoreUpdater, String sourceGuid) throws SaasException {
            ++this._cnt;
            Vector<String> group = new Vector<String>(4);
            group.add(Integer.toString(this._cnt));
            group.add(sourceGuid);
            group.add(saasGroup.getName());
            group.add(saasGroup.getGuid());
            this.groups.add(group);
        }

        @Override
        public void stop() throws SaasException {
        }

        public List<Vector<String>> getGroups() {
            return this.groups;
        }
    }
}

