/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.cli;

import com.pingidentity.provisioner.cli.CliException;
import com.pingidentity.provisioner.cli.InternalDbCommand;
import com.pingidentity.provisioner.resources.SaasProvisionableResource;
import com.pingidentity.provisioner.saas.SaasException;
import com.pingidentity.provisioner.store.DataStoreUpdater;
import com.pingidentity.provisioner.store.SaasProvisionableResourceCallback;
import com.pingidentity.provisioner.store.UserStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class ShowDirtyUsersCommand
extends InternalDbCommand {
    private static final int COLUMNS = 4;

    @Override
    protected Option createOption() {
        return new Option(null, "show-dirty-user-records", false, "Show a list of all dirty user records [c]");
    }

    @Override
    public void execute(CommandLine cli, Options options) throws CliException {
        Vector<String> header = new Vector<String>(Arrays.asList("Cnt", "LDAP GUID", "SaaS Username", "SaaS GUID"));
        UserStore userStore = this.getUserStore(this.getChannelId(cli));
        CollectDirtyUsersCallback callback = new CollectDirtyUsersCallback();
        try {
            userStore.processDirty(callback, null);
        }
        catch (SaasException e) {
            throw new CliException("Cannot retrieve list of dirty user records!", e);
        }
        this.printTable(header, callback.getUsers(), 4);
    }

    private static class CollectDirtyUsersCallback
    implements SaasProvisionableResourceCallback {
        private List<Vector<String>> _users = new ArrayList<Vector<String>>();
        private int _cnt = 0;

        private CollectDirtyUsersCallback() {
        }

        @Override
        public void start() throws SaasException {
        }

        @Override
        public void process(SaasProvisionableResource saasIdentity, DataStoreUpdater updater, String sourceGuid) throws SaasException {
            ++this._cnt;
            Vector<String> user = new Vector<String>(4);
            user.add(Integer.toString(this._cnt));
            user.add(sourceGuid);
            user.add(saasIdentity.getName());
            user.add(saasIdentity.getGuid());
            this._users.add(user);
        }

        @Override
        public void stop() throws SaasException {
        }

        public List<Vector<String>> getUsers() {
            return this._users;
        }
    }
}

