/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.cli;

import com.pingidentity.provisioner.cli.CliException;
import com.pingidentity.provisioner.cli.CommandLineTool;
import com.pingidentity.provisioner.cli.InternalDbCommand;
import com.pingidentity.provisioner.cluster.ProvisionerNodeState;
import com.pingidentity.provisioner.store.jdbc.ProvisionerNodeStateDataManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class ShowNodesCommand
extends InternalDbCommand {
    private static final int COLUMNS = 3;

    @Override
    protected Option createOption() {
        return new Option(null, "show-nodes", false, "Show a list of all nodes in a failover configuration");
    }

    @Override
    public void execute(CommandLine cli, Options options) throws CliException {
        Properties run = CommandLineTool.getRunProperties();
        String mode = run.getProperty("pf.provisioner.mode", "").trim();
        if ("FAILOVER".equals(mode)) {
            Vector<String> header = new Vector<String>(Arrays.asList("Id", "Role", "Heartbeat"));
            ProvisionerNodeStateDataManager nodeStateDataManager = this.getProvisionerNodeStateDataManager();
            List<ProvisionerNodeState> nodeStates = nodeStateDataManager.getAllServerStates();
            ArrayList<Vector<String>> states = new ArrayList<Vector<String>>(nodeStates.size());
            for (ProvisionerNodeState nodeState : nodeStates) {
                Vector<String> state = new Vector<String>(3);
                state.add(Integer.toString(nodeState.getId()));
                state.add(nodeState.getRole().toString());
                state.add(nodeState.getHeartbeat().toString());
                states.add(state);
            }
            this.printTable(header, states, 3);
        } else {
            this._out.println("Not running in failover mode: " + mode);
        }
    }
}

