/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.cli;

import com.pingidentity.provisioner.cli.BaseCommand;
import com.pingidentity.provisioner.cli.CliException;
import com.pingidentity.provisioner.domain.source.ChannelSource;
import java.util.ArrayList;
import java.util.Vector;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.sourceid.saml20.domain.LdapDataSource;

public class ShowSourceCommand
extends BaseCommand {
    @Override
    protected Option createOption() {
        return new Option(null, "show-source", false, "Show source configuration [c]");
    }

    @Override
    public void execute(CommandLine cli, Options options) throws CliException {
        ChannelSource source = this.getDomainSource(this.getChannelId(cli));
        LdapDataSource ldapDataSource = this.getDomainLdapDataSource(source);
        ArrayList<Vector<String>> ldapTable = new ArrayList<Vector<String>>();
        this.addRow(ldapTable, "ID", ldapDataSource.getId());
        this.addRow(ldapTable, "URL", ldapDataSource.getConnectionInfo().getServerUrl());
        this.addRow(ldapTable, "LDAP Type", ldapDataSource.getLdapType().name());
        this.addRow(ldapTable, "Anonymous", ldapDataSource.getAnonymousBinding());
        if (!ldapDataSource.getAnonymousBinding()) {
            this.addRow(ldapTable, "User", ldapDataSource.getPrincipal());
            this.addRow(ldapTable, "Password", "*****");
        }
        this.printNameValueTable("LDAP Connection", ldapTable);
        ArrayList<Vector<String>> settingsTable = new ArrayList<Vector<String>>();
        this.addRow(settingsTable, "GUID Attribute", source.getGuidFormatter().getGuidAttributeName());
        this.addRow(settingsTable, "Binary GUID", source.getGuidFormatter().isGuidIsBinary());
        this.addRow(settingsTable, "User objectClass", source.getUserObjectClass());
        this.addRow(settingsTable, "Member of Group Attribute", source.getMemberOfGroupAttributeName());
        this.addRow(settingsTable, "Group Member Attribute", source.getGroupMemberAttributeName());
        this.addRow(settingsTable, "Changed Users Algorithm", source.getChangedUsersAlgorithm());
        this.addRow(settingsTable, "Timestamp Attribute", source.getTimeStampAttributeName());
        this.addRow(settingsTable, "USN Attribute", source.getUsnAttributeName());
        this.addRow(settingsTable, "Account Status Algorithm", source.getAccountStatusAlgorithm());
        this.addRow(settingsTable, "Account Status Attribute", source.getAccountStatusAttributeName());
        this.addRow(settingsTable, "Flag Comparison Value", source.getFlagComparisonValue());
        this.addRow(settingsTable, "Flag Comparison Status", source.isFlagComparisonStatus() ? "active" : "inactive");
        this.addRow(settingsTable, "Default Status", source.isDefaultStatus() ? "active" : "inactive");
        this._out.println();
        this.printNameValueTable("Settings", settingsTable);
        ArrayList<Vector<String>> locationTable = new ArrayList<Vector<String>>();
        this.addRow(locationTable, "User Base DN", source.getUserBaseDN());
        this.addRow(locationTable, "Group DN", source.getGroupDNForUsers());
        this.addRow(locationTable, "Filter", source.getFilterForUsers());
        this.addRow(locationTable, "User Nested Search", source.isUserNestedSearch());
        this.addRow(locationTable, "Group Nested Search", source.isGroupNestedSearch());
        this._out.println();
        this.printNameValueTable("Location", locationTable);
    }
}

