/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.cli;

import com.pingidentity.provisioner.cli.BaseCommand;
import com.pingidentity.provisioner.cli.CliArgumentException;
import com.pingidentity.provisioner.cli.CliException;
import com.pingidentity.provisioner.domain.Channel;
import com.pingidentity.provisioner.domain.mgmt.ProvisionerConfig;
import com.pingidentity.provisioner.domain.mgmt.ProvisionerManager;
import com.pingidentity.provisioner.domain.target.SaasTarget;
import com.pingidentity.provisioner.saas.SaasPluginManager;
import com.pingidentity.provisioner.saas.SaasProvisionerPlugin;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.TextFieldDescriptor;

public class ShowTargetCommand
extends BaseCommand {
    @Override
    protected Option createOption() {
        return new Option(null, "show-target", false, "Show target configuration [c]");
    }

    @Override
    public void execute(CommandLine cli, Options options) throws CliException {
        SaasTarget target = this.getTarget(this.getChannelId(cli));
        String pluginId = target.getPluginId();
        SaasProvisionerPlugin saasPlugin = SaasPluginManager.getInstance().getPluginInstance(pluginId);
        List<FieldDescriptor> fieldDescriptors = saasPlugin.getParameterDescriptors();
        this._out.println("Plugin: " + pluginId);
        this._out.println();
        ArrayList<Vector<String>> paramTable = new ArrayList<Vector<String>>();
        for (Field field : target.getParameterValues().getFields()) {
            if (this.isPasswordField(fieldDescriptors, field)) {
                this.addRow(paramTable, field.getName(), "*****");
                continue;
            }
            this.addRow(paramTable, field.getName(), field.getValue());
        }
        this.printNameValueTable("Parameters", paramTable);
    }

    private boolean isPasswordField(List<FieldDescriptor> fieldDescriptors, Field field) {
        for (FieldDescriptor fieldDescriptor : fieldDescriptors) {
            if (!fieldDescriptor.getName().equals(field.getName())) continue;
            if (fieldDescriptor instanceof TextFieldDescriptor) {
                TextFieldDescriptor textFieldDescriptor = (TextFieldDescriptor)fieldDescriptor;
                return textFieldDescriptor.isEncrypted();
            }
            return false;
        }
        return false;
    }

    private SaasTarget getTarget(int channelId) throws CliArgumentException {
        for (ProvisionerConfig provisionerConfig : ProvisionerManager.getProvisionerConfigs()) {
            SaasTarget target = provisionerConfig.getTarget();
            for (Channel dChannel : provisionerConfig.getChannels()) {
                if (channelId != dChannel.getId()) continue;
                return target;
            }
        }
        throw new CliArgumentException("Cannot retrieve target information for channel: " + channelId);
    }
}

