/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.cli;

import com.pingidentity.provisioner.channel.runner.ChannelFactory;
import com.pingidentity.provisioner.cli.CliArgumentException;
import com.pingidentity.provisioner.cli.CliException;
import com.pingidentity.provisioner.cli.InternalDbCommand;
import com.pingidentity.provisioner.directory.DirectoryDriver;
import com.pingidentity.provisioner.directory.DirectoryException;
import com.pingidentity.provisioner.directory.GuidFormatter;
import com.pingidentity.provisioner.directory.spring.DirectoryGroupAttributesMapper;
import com.pingidentity.provisioner.directory.spring.DirectoryIdentityAttributesMapper;
import com.pingidentity.provisioner.directory.spring.SpringLdapGuidFormatter;
import com.pingidentity.provisioner.domain.Channel;
import com.pingidentity.provisioner.domain.source.ChannelSource;
import com.pingidentity.provisioner.identity.DirectoryIdentity;
import com.pingidentity.provisioner.identity.SaasGroup;
import com.pingidentity.provisioner.identity.SaasIdentity;
import com.pingidentity.provisioner.mapping.IdentityMapper;
import com.pingidentity.provisioner.store.ProvisionableResourceMeta;
import com.pingidentity.provisioner.store.UserStore;
import com.pingidentity.provisioner.store.groups.GroupMembershipStore;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.sourceid.saml20.domain.LdapDataSource;

public class ShowUserCommand
extends InternalDbCommand {
    @Override
    protected Option createOption() {
        return new Option(null, "show-user", false, "Show internal DB user details [c,u|g]");
    }

    @Override
    public void execute(CommandLine cli, Options options) throws CliException {
        ProvisionableResourceMeta userMeta;
        int channelId = this.getChannelId(cli);
        UserStore userStore = this.getUserStore(channelId);
        GroupMembershipStore groupMembershipStore = this.getGroupMembershipStore(channelId);
        String directoryServerGuid = null;
        if (cli.hasOption(this._saasUsernameOption.getOpt())) {
            userMeta = userStore.getUserMetaBySaasUsername(this.getSaasUsername(cli));
        } else if (cli.hasOption(this._ldapGuidOption.getOpt())) {
            directoryServerGuid = this.getLdapGuid(cli);
            userMeta = userStore.getUserMetaByDirectoryGuid(directoryServerGuid);
        } else {
            throw new CliArgumentException("Missing argument, provide one of: " + this._saasUsernameOption.getArgName() + " or " + this._ldapGuidOption.getArgName());
        }
        if (userMeta != null) {
            directoryServerGuid = userMeta.getDirectoryServerGuid();
            ArrayList<Vector<String>> dbTable = new ArrayList<Vector<String>>();
            this.addRow(dbTable, "SaaS Username", userMeta.getSaasUsername());
            this.addRow(dbTable, "SaaS GUID", userMeta.getSaasGuid());
            this.addRow(dbTable, "LDAP GUID", userMeta.getDirectoryServerGuid());
            if (this.isActiveDirectory(channelId)) {
                this.addRow(dbTable, "  ActiveDirectory String", "{" + SpringLdapGuidFormatter.hexToAdString(userMeta.getDirectoryServerGuid()) + "}");
            }
            this.addRow(dbTable, "In Group", userMeta.isInGroup());
            this.addRow(dbTable, "Values Hash", userMeta.getValuesHash());
            this.addRow(dbTable, "Dirty", userMeta.isDirty());
            this.addRow(dbTable, "Created", userMeta.getCreated().toString());
            this.addRow(dbTable, "Modified", userMeta.getModified().toString());
            SaasIdentity identity = (SaasIdentity)userMeta.getSaasProvisionableResource();
            if (userMeta.isDirty()) {
                this.addRow(dbTable, "Account Status", identity.isAccountEnabled() ? "active" : "inactive");
            }
            Iterator<SaasGroup> groups = groupMembershipStore.getGroupsForUser(userMeta.getDirectoryServerGuid());
            boolean firstGroup = true;
            while (groups.hasNext()) {
                SaasGroup group = groups.next();
                String header = "";
                if (firstGroup) {
                    header = "Member Of";
                    firstGroup = false;
                }
                this.addRow(dbTable, header, group.getName() + " (" + group.getInternalGuid() + ")");
            }
            this.printNameValueTable(null, dbTable);
            if (userMeta.isDirty()) {
                this.printMappedFields(identity);
            }
        } else {
            this._out.println("User not found in internal database.");
        }
        this._out.println();
        if (directoryServerGuid != null) {
            try {
                DirectoryDriver directoryDriver = this.createDirectoryDriver(channelId);
                ArrayList<Vector<String>> ldapTable = new ArrayList<Vector<String>>();
                IdentityMapper identityMapper = this.createIdentityMapper(channelId);
                DirectoryIdentity directoryIdentity = directoryDriver.loadUserByGuid(identityMapper.getAttributeNames(), directoryServerGuid);
                if (directoryIdentity != null) {
                    for (String name : directoryIdentity.getNames()) {
                        for (String value : directoryIdentity.getValues(name)) {
                            this.addRow(ldapTable, name, value);
                        }
                    }
                    this.printNameValueTable("LDAP Attributes", ldapTable);
                } else {
                    this._out.println("User not found in LDAP!");
                }
            }
            catch (DirectoryException e) {
                throw new CliException("Cannot retrieve LDAP attributes. " + e.getMessage(), e);
            }
        }
    }

    private IdentityMapper createIdentityMapper(int channelId) throws CliArgumentException {
        ChannelFactory factory = new ChannelFactory();
        Channel channel = this.getDomainChannel(channelId);
        return factory.createIdentityMapper("channel" + channelId, channel);
    }

    private DirectoryDriver createDirectoryDriver(int channelId) throws CliException {
        try {
            ChannelFactory factory = new ChannelFactory();
            ChannelSource source = this.getDomainSource(channelId);
            GuidFormatter directoryServerGuidFormatter = factory.createGuidFormatter(source);
            DirectoryIdentityAttributesMapper directoryIdentityAttributesMapper = factory.createDirectoryIdentityAttributesMapper(source, directoryServerGuidFormatter);
            DirectoryGroupAttributesMapper directoryGroupAttributesMapper = factory.createDirectoryGroupAttributesMapper(directoryServerGuidFormatter);
            boolean restrictAttributeSyncFilter = true;
            return factory.createDirectoryServer(source, directoryServerGuidFormatter, directoryIdentityAttributesMapper, directoryGroupAttributesMapper, restrictAttributeSyncFilter);
        }
        catch (Exception e) {
            throw new CliException("Cannot create directory driver for channel: " + channelId, e);
        }
    }

    private boolean isActiveDirectory(int channelId) throws CliArgumentException {
        ChannelSource source = this.getDomainSource(channelId);
        LdapDataSource ldapDataSource = this.getDomainLdapDataSource(source);
        return "ActiveDirectory".equalsIgnoreCase(ldapDataSource.getLdapType().name());
    }
}

