/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.directory.spring;

import com.pingidentity.provisioner.directory.spring.ChangedUsersAlgorithm;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPException;
import java.util.Set;
import javax.naming.directory.SearchControls;
import org.apache.commons.lang.StringUtils;

public abstract class BaseChangedUsersAlgorithm
implements ChangedUsersAlgorithm {
    protected String _usersBaseDn;
    protected String _memberOfGroupAttribute = "";
    protected String _provisioningGroupDnForGroups = "";
    protected String _provisioningGroupFilterForGroups = "";

    public void setUsersBaseDn(String usersBaseDn) {
        this._usersBaseDn = usersBaseDn;
    }

    public void setMemberOfGroupAttribute(String memberOfGroupAttribute) {
        this._memberOfGroupAttribute = memberOfGroupAttribute == null ? "" : memberOfGroupAttribute.trim();
    }

    public void setProvisioningGroupDnForGroups(String provisioningGroupDnForGroups) {
        this._provisioningGroupDnForGroups = provisioningGroupDnForGroups == null ? "" : provisioningGroupDnForGroups.trim();
    }

    public void setProvisioningGroupFilterForGroups(String provisioningGroupFilterForGroups) {
        this._provisioningGroupFilterForGroups = provisioningGroupFilterForGroups == null ? "" : provisioningGroupFilterForGroups.trim();
    }

    public boolean isCheckForChangedGroupMembership() {
        return (this.isGroupDnForGroupsDefined() || this.isGroupFilterForGroupsDefined()) && this._memberOfGroupAttribute.length() > 0;
    }

    public boolean isGroupDnForGroupsDefined() {
        return StringUtils.isNotEmpty((String)this._provisioningGroupDnForGroups);
    }

    public boolean isGroupFilterForGroupsDefined() {
        return StringUtils.isNotEmpty((String)this._provisioningGroupFilterForGroups);
    }

    protected Filter buildBaseGroupFilter() throws LDAPException {
        Filter baseGroupFilter = null;
        Filter memberOfFilter = null;
        Filter hardCodedFilter = null;
        if (this._memberOfGroupAttribute.length() > 0 && this._provisioningGroupDnForGroups.length() > 0) {
            memberOfFilter = Filter.createEqualityFilter((String)this._memberOfGroupAttribute, (String)this._provisioningGroupDnForGroups);
        }
        if (this._provisioningGroupFilterForGroups.length() > 0) {
            hardCodedFilter = Filter.create((String)this._provisioningGroupFilterForGroups);
        }
        baseGroupFilter = memberOfFilter != null && hardCodedFilter != null ? Filter.createANDFilter((Filter[])new Filter[]{memberOfFilter, hardCodedFilter}) : (memberOfFilter != null ? memberOfFilter : hardCodedFilter);
        return baseGroupFilter;
    }

    public SearchControls getSearchControls(Set<String> attributeNames, String extraAttributeName) {
        SearchControls controls = new SearchControls();
        controls.setSearchScope(2);
        if (attributeNames != null) {
            attributeNames.add(extraAttributeName);
            controls.setReturningAttributes(attributeNames.toArray(new String[0]));
        }
        return controls;
    }
}

