/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.directory.spring;

import com.pingidentity.provisioner.handler.BaseProvisioningAttributeHandler;
import com.pingidentity.provisioner.util.LDAPTimestamp;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.util.log.AttributeMap;

public class TimestampChangedGroupsCallbackHandler
extends BaseProvisioningAttributeHandler {
    private String _timestampAttributeName;
    private Date _lastTimestamp;
    private boolean _groupMembershipChanged = false;
    private Date _maxTimestamp = new Date(0L);

    public TimestampChangedGroupsCallbackHandler(String timestampAttributeName, Date lastTimestamp) {
        this._timestampAttributeName = timestampAttributeName;
        this._lastTimestamp = lastTimestamp;
    }

    public Date getMaxTimestamp() {
        return this._maxTimestamp;
    }

    public boolean isGroupMembershipChanged() {
        return this._groupMembershipChanged;
    }

    @Override
    public void handle(AttributeMap attributeMap) {
        AttributeValue timeAttribute = (AttributeValue)attributeMap.get((Object)this._timestampAttributeName);
        Date timestamp = LDAPTimestamp.toDate(timeAttribute.getValue());
        if (timestamp != null && timestamp.equals(this._lastTimestamp)) {
            return;
        }
        this._groupMembershipChanged = true;
        if (timestamp != null && timestamp.after(this._maxTimestamp)) {
            this._maxTimestamp = timestamp;
        }
    }

    @Override
    public Set<String> getAttributeNames() {
        return Collections.singleton(this._timestampAttributeName);
    }
}

