/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.domain;

import com.pingidentity.provisioner.domain.IdentityMappingField;
import com.pingidentity.provisioner.domain.source.ChannelSource;
import com.pingidentity.provisioner.xml.util.ChannelUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Channel
implements Serializable {
    private Logger _logger = LogManager.getLogger(Channel.class);
    private static final long serialVersionUID = 20050515L;
    public static final int UNDEFINED = -1;
    private int id = -1;
    private String name = null;
    private ChannelSource source = null;
    private String saasUsernameFieldCode;
    private List<IdentityMappingField> identityMapping = null;
    private int maxThreads = 1;
    private int timeout;
    private boolean deleteDeprovisionedUsers = true;
    private boolean enableAttributeSync = true;
    private boolean active = false;

    public Channel() {
        this.source = new ChannelSource();
        this.identityMapping = new ArrayList<IdentityMappingField>();
    }

    public Channel(String name, int id, ChannelSource provSrc, List<IdentityMappingField> idMap, int maxThrds, boolean deleteDeprovUsers, boolean enableAttrSync) {
        this.name = name;
        this.id = id;
        this.source = provSrc;
        this.identityMapping = idMap;
        this.maxThreads = maxThrds;
        this.deleteDeprovisionedUsers = deleteDeprovUsers;
        this.enableAttributeSync = enableAttrSync;
    }

    public Channel(String name) {
        this();
        this.name = name;
    }

    public Channel(Channel toBeCopied) {
        this.id = toBeCopied.getId();
        this.name = toBeCopied.getName();
        this.source = new ChannelSource(toBeCopied.getSource());
        if (toBeCopied.getIdentityMapping() != null) {
            this.identityMapping = new ArrayList<IdentityMappingField>();
            for (IdentityMappingField mapping : toBeCopied.getIdentityMapping()) {
                this.identityMapping.add(new IdentityMappingField(mapping));
            }
        }
        this.maxThreads = toBeCopied.getMaxThreads();
        this.timeout = toBeCopied.getTimeout();
        this.deleteDeprovisionedUsers = toBeCopied.isDeleteDeprovisionedUsers();
        this.enableAttributeSync = toBeCopied.isEnableAttributeSync();
        this.active = false;
        this.saasUsernameFieldCode = toBeCopied.getSaasUsernameFieldCode();
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ChannelSource getSource() {
        return this.source;
    }

    public void setSource(ChannelSource source) {
        this.source = source;
    }

    public List<IdentityMappingField> getIdentityMapping() {
        return this.identityMapping;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    public boolean isDeleteDeprovisionedUsers() {
        return this.deleteDeprovisionedUsers;
    }

    public void setDeleteDeprovisionedUsers(boolean deleteDeprovisionedUsers) {
        this.deleteDeprovisionedUsers = deleteDeprovisionedUsers;
    }

    public boolean isEnableAttributeSync() {
        return this.enableAttributeSync;
    }

    public void setEnableAttributeSync(boolean enableAttributeSync) {
        this.enableAttributeSync = enableAttributeSync;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setidentityMapping(List<IdentityMappingField> identityMapping) {
        this.identityMapping = identityMapping;
    }

    public String getIdentityMappingHash() {
        if (this.identityMapping == null) {
            return "";
        }
        return ChannelUtil.getIdentityMappingHash(this.identityMapping);
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String getSaasUsernameFieldCode() {
        return this.saasUsernameFieldCode;
    }

    public void setSaasUsernameFieldCode(String saasUsernameFieldCode) {
        this.saasUsernameFieldCode = saasUsernameFieldCode;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }
}

