/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.domain.mgmt;

import com.pingidentity.common.util.xml.XmlBeansUtil;
import com.pingidentity.module.connection.ConnectionModuleConfiguration;
import com.pingidentity.provisioner.domain.Channel;
import com.pingidentity.provisioner.domain.IdentityMappingField;
import com.pingidentity.provisioner.domain.ProvisionerGlobalSettings;
import com.pingidentity.provisioner.domain.mgmt.FieldInfoManager;
import com.pingidentity.provisioner.domain.mgmt.ProvisionerConfig;
import com.pingidentity.provisioner.domain.target.SaasTarget;
import com.pingidentity.provisioner.mapping.FieldConfig;
import com.pingidentity.provisioner.mapping.FieldInfo;
import com.pingidentity.provisioner.saas.SaasException;
import com.pingidentity.provisioner.xml.ConfigHandler;
import com.pingidentity.provisioner.xml.util.ChannelUtil;
import com.pingidentity.x2008.x06.saasProvisioner.SaasProvisionerDocument;
import com.pingidentity.x2008.x06.saasProvisioner.SaasProvisionerType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.saml20.domain.DataSource;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.ExtensionsType;

public class ProvisionerManager {
    private static Logger log = LogManager.getLogger(ProvisionerManager.class);
    private static Map<String, ProvisionerConfig> map;
    private static ProvisionerGlobalSettings globalSettings;

    public static synchronized ProvisionerConfig getProvisionerConfig(String entityId) {
        if (map != null && map.containsKey(entityId)) {
            ProvisionerConfig provisionerConfig = map.get(entityId);
            return provisionerConfig;
        }
        return null;
    }

    public static synchronized List<ProvisionerConfig> getProvisionerConfigs() {
        ArrayList<ProvisionerConfig> provisionerConfigs = new ArrayList<ProvisionerConfig>();
        for (String entityId : map.keySet()) {
            ProvisionerConfig provisionerConfig = ProvisionerManager.getProvisionerConfig(entityId);
            if (provisionerConfig == null) continue;
            provisionerConfigs.add(provisionerConfig);
        }
        return Collections.unmodifiableList(provisionerConfigs);
    }

    public static synchronized void saveProvisionerConfig(ProvisionerConfig provisionerConfig) {
        boolean mapUpdated = ProvisionerManager.saveProvisionerConfigToMap(provisionerConfig);
        if (mapUpdated) {
            ProvisionerManager.save();
        }
    }

    public static synchronized void saveProvisionerConfigs(List<ConnectionModuleConfiguration> provisionerConfigs) {
        int numUpdated = 0;
        for (ConnectionModuleConfiguration config : provisionerConfigs) {
            ProvisionerConfig provisionerConfig = (ProvisionerConfig)config;
            boolean mapUpdated = ProvisionerManager.saveProvisionerConfigToMap(provisionerConfig);
            if (!mapUpdated) continue;
            ++numUpdated;
        }
        if (numUpdated > 0) {
            ProvisionerManager.save();
        }
    }

    private static synchronized boolean saveProvisionerConfigToMap(ProvisionerConfig provisionerConfig) {
        boolean mapUpdated = false;
        if (provisionerConfig != null) {
            String entityId = provisionerConfig.getEntityId();
            if (entityId != null) {
                map.put(entityId, provisionerConfig);
                mapUpdated = true;
            } else {
                log.error("Saving the provisioning configuration failed.  The entityid is missing.");
            }
        }
        return mapUpdated;
    }

    public static synchronized void deleteProvisionerConfig(String entityId) {
        boolean mapUpdated = ProvisionerManager.deleteProvisionerConfigFromMap(entityId);
        if (mapUpdated) {
            ProvisionerManager.save();
        }
    }

    public static synchronized void deleteProvisionerConfigs(List<String> entityIds) {
        int numDeleted = 0;
        for (String entityId : entityIds) {
            boolean mapUpdated = ProvisionerManager.deleteProvisionerConfigFromMap(entityId);
            if (!mapUpdated) continue;
            ++numDeleted;
        }
        if (numDeleted > 0) {
            ProvisionerManager.save();
        }
    }

    private static synchronized boolean deleteProvisionerConfigFromMap(String entityId) {
        boolean deleted = false;
        if (entityId != null && map.containsKey(entityId)) {
            log.info("Deleting provisioner configuration for " + entityId);
            map.remove(entityId);
            deleted = true;
        }
        return deleted;
    }

    public static synchronized ProvisionerGlobalSettings getProvisionerGlobalSettings() {
        return globalSettings;
    }

    public static synchronized void saveProvisionerGlobalSettings(ProvisionerGlobalSettings settings) {
        log.info("Saving ProvisionerGlobalSettings ...");
        globalSettings = settings;
        ProvisionerManager.save();
    }

    public static synchronized boolean isDataSourceInUse(DataSource dataSource) {
        String dataSourceId;
        if (dataSource != null && !StringUtils.isEmpty((String)(dataSourceId = dataSource.getId()))) {
            if (ProvisionerManager.isInternalDataSource(dataSource)) {
                return true;
            }
            for (ProvisionerConfig proConfig : map.values()) {
                for (Channel channel : proConfig.getChannels()) {
                    if (channel.getSource() == null || !dataSourceId.equals(channel.getSource().getDataSourceId())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static synchronized boolean isInternalDataSource(DataSource dataSource) {
        String dataSourceId;
        return dataSource != null && (!StringUtils.isEmpty((String)(dataSourceId = dataSource.getId())) && dataSourceId.equals(globalSettings.getInternalDataSourceId()) || "ProvisionerDS".equals(dataSourceId));
    }

    private static void load() {
        ConfigHandler configHandler = new ConfigHandler();
        map = configHandler.getProvisionerConfigMap();
        globalSettings = configHandler.getGlobalSettings();
        int topChannelIdUsed = 0;
        for (ProvisionerConfig conf : map.values()) {
            if (!conf.hasChannels()) continue;
            for (Channel channel : conf.getChannels()) {
                if (channel.getId() <= topChannelIdUsed) continue;
                topChannelIdUsed = channel.getId();
            }
        }
        ChannelUtil.adjustNextChannelNumber(topChannelIdUsed);
    }

    private static void save() {
        log.info("saving provisioner configuration...");
        ConfigHandler configHandler = new ConfigHandler();
        configHandler.save(globalSettings, map);
    }

    public static void updateFieldInfo(Channel channel, SaasTarget target) {
        if (target != null) {
            try {
                List<FieldInfo> fieldInfoListFromDriver = FieldInfoManager.getInstance().getFieldInfoList(target);
                List<IdentityMappingField> fieldList = channel.getIdentityMapping();
                ArrayList<IdentityMappingField> updatedFieldList = new ArrayList<IdentityMappingField>();
                for (FieldInfo fieldInfo : fieldInfoListFromDriver) {
                    IdentityMappingField mappingFld = new IdentityMappingField(fieldInfo.getCode());
                    mappingFld.setFieldInfo(fieldInfo);
                    boolean fieldConfigSet = false;
                    if (fieldList != null) {
                        for (IdentityMappingField existingFld : fieldList) {
                            if (!fieldInfo.getCode().equals(existingFld.getFieldName())) continue;
                            mappingFld.setFieldConfig(existingFld.getFieldConfig());
                            fieldConfigSet = true;
                            break;
                        }
                    }
                    if (!fieldConfigSet) {
                        FieldConfig fieldConfig = new FieldConfig();
                        mappingFld.setFieldConfig(fieldConfig);
                    }
                    updatedFieldList.add(mappingFld);
                }
                channel.setidentityMapping(updatedFieldList);
                channel.setSaasUsernameFieldCode(FieldInfoManager.getInstance().getSaasUsernameFieldCode(target));
            }
            catch (SaasException e) {
                log.error("Error in getting FieldInfo list from Saas Driver", (Throwable)e);
            }
        }
    }

    public static void getProvisionerConfigAsXML(ExtensionsType moduleXmlType, ProvisionerConfig provisionerConfig) {
        SaasProvisionerDocument saasProvisionerDoc = new ConfigHandler().getProvisionerConfigAsDocument(provisionerConfig);
        SaasProvisionerType saasProvisionerType = saasProvisionerDoc.getSaasProvisioner();
        XmlBeansUtil.setChildren((XmlObject)moduleXmlType, (XmlObject[])new XmlObject[]{saasProvisionerType});
    }

    public static void reload() {
        ProvisionerManager.load();
        new ConfigHandler().touchConfig();
    }

    static {
        ProvisionerManager.load();
    }
}

