/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.domain.mgmt;

import com.pingidentity.module.connection.ConnectionModuleConfiguration;
import com.pingidentity.module.connection.ConnectionModuleGlobalConfiguration;
import com.pingidentity.module.connection.ConnectionModuleManager;
import com.pingidentity.provisioner.domain.Channel;
import com.pingidentity.provisioner.domain.ProvisionerGlobalSettings;
import com.pingidentity.provisioner.domain.mgmt.ProvisionerConfig;
import com.pingidentity.provisioner.domain.mgmt.ProvisionerManager;
import com.pingidentity.provisioner.domain.source.ChannelSource;
import com.pingidentity.provisioner.saas.SaasException;
import com.pingidentity.provisioner.saas.SaasPluginManager;
import com.pingidentity.provisioner.xml.ConfigHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.domain.DataSource;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.ConnectionModuleType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.DependenciesType;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.ExtensionsType;
import org.sourceid.util.license.LicenseManager;

public class ProvisionerModuleManager
implements ConnectionModuleManager {
    private Log log = LogFactory.getLog(this.getClass());

    public ConnectionModuleConfiguration getConfiguration(String entityId) {
        return ProvisionerManager.getProvisionerConfig(entityId);
    }

    public void saveConfiguration(ConnectionModuleConfiguration moduleConfiguration) {
        ProvisionerManager.saveProvisionerConfig((ProvisionerConfig)moduleConfiguration);
    }

    public void saveConfigurations(List<ConnectionModuleConfiguration> moduleConfigurations) {
        ProvisionerManager.saveProvisionerConfigs(moduleConfigurations);
    }

    public void deleteConfiguration(String entityId) {
        ProvisionerManager.deleteProvisionerConfig(entityId);
    }

    public void deleteConfigurations(List<String> entityIds) {
        ProvisionerManager.deleteProvisionerConfigs(entityIds);
    }

    public ConnectionModuleGlobalConfiguration getGlobalConfiguration() {
        return ProvisionerManager.getProvisionerGlobalSettings();
    }

    public void saveGlobalConfiguration(ConnectionModuleGlobalConfiguration globalConfiguration) {
        ProvisionerManager.saveProvisionerGlobalSettings((ProvisionerGlobalSettings)globalConfiguration);
    }

    public void exportConfiguration(DependenciesType exportDocument, String entityId) {
        ProvisionerConfig provisionerConfig = ProvisionerManager.getProvisionerConfig(entityId);
        if (provisionerConfig != null) {
            ConnectionModuleType module = exportDocument.addNewConnectionModule();
            module.setModuleClass(ProvisionerConfig.class.getName());
            ExtensionsType moduleXmlType = module.addNewData();
            ProvisionerManager.getProvisionerConfigAsXML(moduleXmlType, provisionerConfig);
        }
    }

    public ConnectionModuleConfiguration createConfigurationForImport(String entityIdFromConnection, String xmlData) {
        ProvisionerConfig configuration = null;
        ConfigHandler configHandler = new ConfigHandler();
        try {
            configuration = configHandler.getProvisionerConfigFromXML(xmlData);
            configuration.setEntityId(entityIdFromConnection);
            List<Channel> channels = configuration.getChannels();
            if (channels != null && !channels.isEmpty()) {
                for (Channel channel : channels) {
                    if (channel != null) {
                        channel.setId(-1);
                        continue;
                    }
                    this.log.warn((Object)"Configuration from xml contains a null channel.");
                }
            } else {
                this.log.warn((Object)"Configuration from xml does not contain any channels.");
            }
        }
        catch (SaasException e) {
            this.log.error((Object)("Unable to create SaaS Provisioner configuration from xml data. " + e.getMessage()));
        }
        return configuration;
    }

    public void validateConfigurationForImport(ConnectionModuleConfiguration moduleConfiguration, List<String> problems) {
        if (moduleConfiguration != null) {
            ProvisionerConfig provConfig = (ProvisionerConfig)moduleConfiguration;
            List<Channel> channels = provConfig.getChannels();
            if (channels != null && !channels.isEmpty()) {
                for (Channel channel : channels) {
                    ChannelSource source = channel.getSource();
                    if (source != null) {
                        String sourceId = source.getDataSourceId();
                        if (MgmtFactory.getDataSourceManager().getLdapDataSource(sourceId) != null) continue;
                        problems.add("Invalid Provisioner configuration. The defined source ldap directory does not exist: " + sourceId);
                        continue;
                    }
                    problems.add("Invalid Provisioner configuration. No source found for channel " + channel.getName() + ".");
                }
            } else {
                problems.add("Invalid Provisioner configuration. No Channels found.");
            }
        } else {
            problems.add("Unable to validate Provisioner configuration. Configuration is not defined.");
        }
    }

    public boolean isDataSourceInUse(DataSource dataSource) {
        return ProvisionerManager.isDataSourceInUse(dataSource);
    }

    public boolean isInternalDataSource(DataSource dataSource) {
        return ProvisionerManager.isInternalDataSource(dataSource);
    }

    public boolean isIncludeWithConnectionCopy() {
        return false;
    }

    public List<String> validateDependencies() {
        ArrayList<String> errorMessages = new ArrayList<String>();
        SaasPluginManager pluginManager = SaasPluginManager.getInstance();
        Collection spConnections = MgmtFactory.getConnectionManager().getAllSpConnections();
        for (SpConnection spConnection : spConnections) {
            String targetType = spConnection.getConnectionTargetType();
            if ("Standard".equals(targetType) || targetType == null || pluginManager.getPluginInstance(targetType) != null) continue;
            errorMessages.add("SaaS Provisioner Connector missing.  Connection '" + spConnection.getName() + "' is configured to use a connector that is not loaded. (" + targetType + ")");
        }
        return errorMessages;
    }

    public boolean isEnabledInLicense() {
        return LicenseManager.isFeatureEnabled((String)"SaasProvisioning");
    }

    public String getDescription() {
        return "Outbound Provisioning";
    }

    public void reload() {
        ProvisionerManager.reload();
    }
}

