/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.identity;

import com.pingidentity.provisioner.resources.SaasProvisionableResource;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.codec.binary.Hex;

public class SaasIdentity
extends SaasProvisionableResource {
    private static final String VALUES_HASH_ALGORITHM = "MD5";
    private String _saasUsernameFieldCode;
    private Set<String> _createOnlyFields = new HashSet<String>();
    private boolean _accountEnabled = true;
    private boolean _inProvisioningGroup = false;
    private String _saasGuid;

    public SaasIdentity(String saasUsernameFieldCode) {
        super(new HashMap<String, List<String>>());
        this._saasUsernameFieldCode = saasUsernameFieldCode;
    }

    public boolean hasUpdateValue(String name) {
        return !this._createOnlyFields.contains(name) && this.hasValue(name);
    }

    public String getSaasUsernameFieldCode() {
        return this._saasUsernameFieldCode;
    }

    @Deprecated
    public String getSaasUsername() {
        return this.getName();
    }

    public boolean isFieldCreateOnly(String fieldCode) {
        return this._createOnlyFields.contains(fieldCode);
    }

    public void setCreateOnlyFields(Set<String> createOnlyFields) {
        this._createOnlyFields = createOnlyFields;
    }

    @Override
    public boolean isInProvisioningGroup() {
        return this._inProvisioningGroup;
    }

    public void setInProvisioningGroup(boolean inProvisioningGroup) {
        this._inProvisioningGroup = inProvisioningGroup;
    }

    public boolean isActive() {
        return this.isAccountEnabled() && this.isInProvisioningGroup();
    }

    @Deprecated
    public boolean hasSaasGuid() {
        return this.hasGuid();
    }

    @Override
    public boolean hasGuid() {
        return this._saasGuid != null && this._saasGuid.length() > 0;
    }

    @Deprecated
    public String getSaasGuid() {
        return this.getGuid();
    }

    public void setSaasGuid(String saasGuid) {
        this._saasGuid = saasGuid;
    }

    public String calculateValuesHash() {
        try {
            MessageDigest md5 = MessageDigest.getInstance(VALUES_HASH_ALGORITHM);
            TreeSet<String> names = new TreeSet<String>(this.getNames());
            md5.update((this.isAccountEnabled() ? "true" : "false").getBytes("UTF-8"));
            for (String name : names) {
                if (this.isMapValue(name)) {
                    Map<String, List<String>> map = this.getMap(name);
                    TreeSet<String> mapKeys = new TreeSet<String>(map.keySet());
                    for (String key : mapKeys) {
                        ArrayList values = new ArrayList(map.get(key));
                        Collections.sort(values);
                        for (String value : values) {
                            md5.update(value.getBytes("UTF-8"));
                        }
                    }
                    continue;
                }
                ArrayList<String> values = new ArrayList<String>(this.getValues(name));
                Collections.sort(values);
                for (String value : values) {
                    md5.update(value.getBytes(StandardCharsets.UTF_8));
                }
            }
            byte[] digest = md5.digest();
            return new String(Hex.encodeHex((byte[])digest));
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.toString(builder);
        return builder.toString();
    }

    @Override
    public void toString(StringBuilder builder) {
        builder.append("SaaS username field code: ").append(this._saasUsernameFieldCode).append("; ");
        builder.append("Account enabled: ").append(this._accountEnabled ? "Yes" : "No").append("; ");
        super.toString(builder);
    }

    @Override
    public String getName() {
        return this.getValue(this._saasUsernameFieldCode);
    }

    @Override
    public String getGuid() {
        return this._saasGuid;
    }

    public boolean isAccountEnabled() {
        return this._accountEnabled;
    }

    public void setAccountEnabled(boolean accountEnabled) {
        this._accountEnabled = accountEnabled;
    }

    public boolean isNameMasked() {
        return this.getMaskedFields().contains(this._saasUsernameFieldCode);
    }
}

