/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.mapping;

import com.pingidentity.provisioner.util.OrderedProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FieldInfo
implements Serializable {
    private static final long serialVersionUID = 20050515L;
    protected static final Log log = LogFactory.getLog(FieldInfo.class);
    private String _code;
    private String _label;
    private boolean _required = false;
    private boolean _unique = false;
    private boolean _multiValue = false;
    private List<Option> _options = new ArrayList<Option>();
    private Set<String> _optionCodes = new HashSet<String>();
    private int _minLength = 0;
    private int _maxLength = Integer.MAX_VALUE;
    private Pattern _pattern = null;
    private List<String> _notes = new ArrayList<String>();
    private String _default = "";
    private boolean _isLdapMap;
    private boolean _persistForMembership;
    private boolean _isAttributeGroup;

    public FieldInfo(String code, String label) throws IllegalArgumentException {
        if (code == null || code.length() == 0) {
            throw new IllegalArgumentException("Code cannot be null or empty!");
        }
        if (label == null || label.length() == 0) {
            throw new IllegalArgumentException("Label cannot be null or empty!");
        }
        this._code = code;
        this._label = label;
    }

    public FieldInfo(String code, String label, boolean required, boolean unique) throws IllegalArgumentException {
        this(code, label);
        this._required = required;
        this._unique = unique;
    }

    public FieldInfo(String code, String label, boolean required, boolean unique, int minLength, int maxLength, String regex) throws IllegalArgumentException {
        this(code, label);
        this._required = required;
        this._unique = unique;
        this._minLength = minLength;
        this._maxLength = maxLength;
        if (regex != null) {
            this._pattern = Pattern.compile(regex);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldInfo fieldInfo = (FieldInfo)o;
        return this._code.equals(fieldInfo._code);
    }

    public int hashCode() {
        return this._code.hashCode();
    }

    public String getCode() {
        return this._code;
    }

    public void setCode(String code) {
        this._code = code;
    }

    public String getLabel() {
        return this._label;
    }

    public void setLabel(String label) {
        this._label = label;
    }

    public boolean isRequired() {
        return this._required;
    }

    public void setRequired(boolean required) {
        this._required = required;
    }

    public boolean isUnique() {
        return this._unique;
    }

    public void setUnique(boolean unique) {
        this._unique = unique;
    }

    public boolean isMultiValue() {
        return this._multiValue;
    }

    public void setMultiValue(boolean multiValue) {
        this._multiValue = multiValue;
    }

    public List<Option> getOptions() {
        return this._options;
    }

    public boolean hasOptions() {
        return this._options.size() > 0;
    }

    public void addOption(Option option) {
        if (log != null && this._optionCodes.contains(option.getCode())) {
            log.debug((Object)("Option code added twice: " + option.getCode()));
        }
        this._options.add(option);
        this._optionCodes.add(option.getCode());
    }

    public void addOption(String code, String label) throws IllegalArgumentException {
        this.addOption(new Option(code, label));
    }

    public void addOptions(List<Option> options) {
        for (Option option : options) {
            this.addOption(option);
        }
    }

    public void setOptions(List<Option> options) {
        this._options.clear();
        this._optionCodes.clear();
        this.addOptions(options);
    }

    public int getMinLength() {
        return this._minLength;
    }

    public void setMinLength(int minLength) {
        this._minLength = minLength;
    }

    public int getMaxLength() {
        return this._maxLength;
    }

    public void setMaxLength(int maxLength) {
        this._maxLength = maxLength;
    }

    public String getRegEx() {
        if (this._pattern == null) {
            return null;
        }
        return this._pattern.pattern();
    }

    public void setRegEx(String regex) {
        this._pattern = regex == null ? null : Pattern.compile(regex);
    }

    public List<String> getNotes() {
        return this._notes;
    }

    public boolean hasNotes() {
        return this._notes.size() > 0;
    }

    public void addNote(String note) {
        if ((note = note.trim()).length() > 0) {
            this._notes.add(note);
        }
    }

    public void setNotes(Collection<String> notes) {
        this._notes.clear();
        for (String note : notes) {
            this.addNote(note);
        }
    }

    public String getDefault() {
        return this._default;
    }

    public boolean hasDefault() {
        return this._default != null && this._default.length() > 0;
    }

    public void setDefault(String aDefault) {
        this._default = aDefault;
    }

    public boolean validate(String value, List<String> errors) {
        boolean valid = true;
        if (this._required) {
            if (value == null) {
                valid = false;
                errors.add("Required but null");
            } else if (value.length() == 0) {
                valid = false;
                errors.add("Required but empty");
            }
        }
        if (value != null) {
            if (this.hasOptions() && !this._optionCodes.contains(value)) {
                valid = false;
                errors.add("Not a valid option: " + value);
            }
            if (value.length() < this._minLength) {
                valid = false;
                errors.add("Shorter than minimum length: " + this._minLength);
            }
            if (value.length() > this._maxLength) {
                valid = false;
                errors.add("Longer than maximum length: " + this._maxLength);
            }
            if (this._pattern != null && !this._pattern.matcher(value).matches()) {
                valid = false;
                errors.add("Does not match regex: " + this._pattern.pattern());
            }
        }
        return valid;
    }

    public boolean validate(List<String> values, List<String> errors) {
        boolean valid = true;
        switch (values.size()) {
            case 0: {
                valid = this.validate((String)null, errors);
                break;
            }
            case 1: {
                valid = this.validate(values.get(0), errors);
                break;
            }
            default: {
                if (this._multiValue) {
                    for (String value : values) {
                        valid = valid && this.validate(value, errors);
                    }
                    break;
                }
                valid = false;
                errors.add("Multi values not supported, received: " + values.size());
                this.validate(values.get(0), errors);
            }
        }
        return valid;
    }

    public static List<FieldInfo> parseFieldsInfo(String propsFilename) throws IOException {
        return FieldInfo.parseFieldsInfo(Thread.currentThread().getContextClassLoader().getResourceAsStream(propsFilename));
    }

    public static List<FieldInfo> parseFieldsInfo(File propsFile) throws IOException {
        return FieldInfo.parseFieldsInfo(new FileInputStream(propsFile));
    }

    public static List<FieldInfo> parseFieldsInfo(InputStream propsInputStream) throws IOException {
        ArrayList<String> codes = new ArrayList<String>();
        HashMap<String, ArrayList<Option>> fieldsOptionsMap = new HashMap<String, ArrayList<Option>>();
        OrderedProperties props = new OrderedProperties();
        props.load(propsInputStream);
        Enumeration<?> keys = ((Properties)props).propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            int dotIdx = key.indexOf(46);
            if (dotIdx < 1) {
                throw new IllegalArgumentException("Invalid key in fields info properties file: " + key);
            }
            String code = key.substring(0, dotIdx);
            if (!codes.contains(code)) {
                codes.add(code);
            }
            if (!key.startsWith(code + ".option.")) continue;
            String optionCode = key.substring(dotIdx + 8);
            String optionLabel = props.getProperty(key);
            ArrayList<Option> options = (ArrayList<Option>)fieldsOptionsMap.get(code);
            if (options == null) {
                options = new ArrayList<Option>();
                fieldsOptionsMap.put(code, options);
            }
            options.add(new Option(optionCode, optionLabel));
        }
        ArrayList<FieldInfo> fields = new ArrayList<FieldInfo>(codes.size());
        for (String code : codes) {
            String note;
            boolean isLdapMap;
            String label = props.getProperty(code + ".label");
            FieldInfo field = new FieldInfo(code, label);
            String required = props.getProperty(code + ".required");
            if (required != null) {
                field.setRequired(Boolean.parseBoolean(required));
            }
            if (isLdapMap = Boolean.parseBoolean(props.getProperty(code + ".ldapMap"))) {
                field.setLdapMap(isLdapMap);
            } else {
                String persistForMembership;
                String theDefault;
                String regex;
                String multi;
                String max;
                String min;
                String unique = props.getProperty(code + ".unique");
                if (unique != null) {
                    field.setUnique(Boolean.parseBoolean(unique));
                }
                if ((min = props.getProperty(code + ".min")) != null) {
                    field.setMinLength(Integer.parseInt(min));
                }
                if ((max = props.getProperty(code + ".max")) != null) {
                    field.setMaxLength(Integer.parseInt(max));
                }
                if ((multi = props.getProperty(code + ".multi")) != null) {
                    field.setMultiValue(Boolean.parseBoolean(multi));
                }
                if ((regex = props.getProperty(code + ".regex")) != null) {
                    field.setRegEx(regex);
                }
                if (fieldsOptionsMap.containsKey(code)) {
                    field.addOptions((List)fieldsOptionsMap.get(code));
                }
                if ((theDefault = props.getProperty(code + ".default")) != null) {
                    field.setDefault(theDefault);
                }
                if ((persistForMembership = props.getProperty(code + ".persistForMembership")) != null) {
                    field.setPersistForMembership(Boolean.parseBoolean(persistForMembership));
                }
            }
            int noteIdx = 1;
            while ((note = props.getProperty(code + ".note." + noteIdx)) != null) {
                field.addNote(note);
                ++noteIdx;
            }
            fields.add(field);
        }
        return fields;
    }

    public boolean isDisplayMinLength() {
        return this._minLength > 0;
    }

    public boolean isDisplayMaxLength() {
        return this._maxLength < Integer.MAX_VALUE;
    }

    public boolean isDisplayRegEx() {
        return this._pattern != null && !this.getRegEx().trim().equals("");
    }

    public boolean isLdapMap() {
        return this._isLdapMap;
    }

    public void setLdapMap(boolean isLdapMap) {
        this._isLdapMap = isLdapMap;
    }

    public boolean isPersistForMembership() {
        return this._persistForMembership;
    }

    public void setPersistForMembership(boolean persistForMembership) {
        this._persistForMembership = persistForMembership;
    }

    public boolean isAttributeGroup() {
        return this._isAttributeGroup;
    }

    public void setAttributeGroup(boolean isAttributeGroup) {
        this._isAttributeGroup = isAttributeGroup;
    }

    public static class Option
    implements Serializable {
        private static final long serialVersionUID = 20050515L;
        private String _code;
        private String _label;

        public Option(String code, String label) throws IllegalArgumentException {
            if (code == null || code.length() == 0) {
                throw new IllegalArgumentException("Code cannot be null or empty!");
            }
            if (label == null) {
                throw new IllegalArgumentException("Label cannot be null!");
            }
            this._code = code;
            this._label = label;
        }

        public String getCode() {
            return this._code;
        }

        public String getLabel() {
            return this._label;
        }
    }
}

