/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.mapping;

import com.pingidentity.provisioner.directory.DirectoryException;
import com.pingidentity.provisioner.identity.DirectoryGroup;
import com.pingidentity.provisioner.identity.SaasGroup;
import java.util.HashSet;
import java.util.Set;

public class GroupMapper {
    private final boolean useDnAsGroupName;

    public GroupMapper(boolean useDnAsGroupName) {
        this.useDnAsGroupName = useDnAsGroupName;
    }

    public SaasGroup map(String dn, DirectoryGroup directoryGroup) throws DirectoryException {
        String guid = directoryGroup.getGuid();
        String groupName = this.useDnAsGroupName ? dn : directoryGroup.getValue("cn");
        if (groupName == null) {
            throw new DirectoryException("Unable to extract CN from group DN: " + dn);
        }
        SaasGroup saasGroup = new SaasGroup(groupName);
        saasGroup.setInternalGuid(guid);
        return saasGroup;
    }

    public Set<String> getLdapAttributeNames() {
        HashSet<String> attributeNames = new HashSet<String>();
        if (!this.useDnAsGroupName) {
            attributeNames.add("cn");
        }
        return attributeNames;
    }
}

