/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.monitor;

import java.time.Instant;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProvisioningEventLogger {
    private static Logger logger = LogManager.getLogger(ProvisioningEventLogger.class);
    private static Logger summaryLogger = LogManager.getLogger((String)"ProvisionerChannelSummaryLog");
    private final int channelCode;
    private final String channelName;
    private final String connectionName;
    private final long cycleId;
    private final Counter passiveProvUsersScanned = new Counter();
    private final Counter passiveProvUsersAdded = new Counter();
    private final Counter passiveProvUsersRemoved = new Counter();
    private final Counter passiveProvUsersSkipped = new Counter();
    private final Counter passiveProvGroupsScanned = new Counter();
    private final Counter passiveProvGroupsAdded = new Counter();
    private final Counter passiveProvGroupsRemoved = new Counter();
    private final Counter attributeSyncUsersProcessed = new Counter();
    private final Counter attributeSyncUsersUpdated = new Counter();
    private final Counter attributeSyncUserErrors = new Counter();
    private final Counter attributeSyncUsersSkipped = new Counter();
    private final Counter usersPushedToTarget = new Counter();
    private final Counter usersDeprovisionedFromTarget = new Counter();
    private final Counter usersUpdatedAtTarget = new Counter();
    private final Counter usersProcessed = new Counter();
    private final Counter groupsPushedToTarget = new Counter();
    private final Counter groupsUpdatedAtTarget = new Counter();
    private final Counter groupsDeprovisionedFromTarget = new Counter();
    private final Instant cycleStartTime;
    private long passiveProvStartTime;
    private long attributeSyncStartTime;
    private long targetProvStartTime;
    private static final int LOG_INTERVAL_USERS = 500;

    public ProvisioningEventLogger(int channelCode, String channelName, long cycleId, String connectionName) {
        this.channelCode = channelCode;
        this.channelName = channelName;
        this.cycleId = cycleId;
        this.connectionName = connectionName;
        this.cycleStartTime = Instant.now();
    }

    public void passiveProvUserSkipped() {
        this.passiveProvUsersSkipped.increment();
        this.passiveProvUserProcessed();
    }

    public void passiveProvUserAdded() {
        this.passiveProvUsersAdded.increment();
        this.passiveProvUserProcessed();
    }

    public void passiveProvUserRemoved() {
        this.passiveProvUsersRemoved.increment();
        this.passiveProvUserProcessed();
    }

    public void passiveProvUserProcessed() {
        this.passiveProvUsersScanned.increment();
        if (this.passiveProvUsersScanned.getCountSinceLastLog() >= 500) {
            this.logPassiveProvProgressMessage();
        }
    }

    public void passiveProvGroupProcessed() {
        this.passiveProvGroupsScanned.increment();
    }

    public void passiveProvGroupAdded() {
        this.passiveProvGroupsAdded.increment();
        this.passiveProvGroupProcessed();
    }

    public void logPassiveProvProgressMessage() {
        logger.info("Processed " + this.passiveProvUsersScanned.getCountSinceLastLog() + " users. Users added: " + this.passiveProvUsersAdded.getCountSinceLastLog() + ". Users skipped: " + this.passiveProvUsersSkipped.getCountSinceLastLog());
        this.passiveProvUsersScanned.resetLogCount();
        this.passiveProvUsersAdded.resetLogCount();
        this.passiveProvUsersRemoved.resetLogCount();
        this.passiveProvUsersSkipped.resetLogCount();
    }

    public void logPassiveProvSummary() {
        if (this.passiveProvUsersScanned.getCountSinceLastLog() > 0) {
            this.logPassiveProvProgressMessage();
        }
        String summaryMessage = "User/group addition and group membership change detection stage completed in " + (System.currentTimeMillis() - this.passiveProvStartTime) + " ms. Total users processed: " + this.passiveProvUsersScanned.getCount() + ". Total users added: " + this.passiveProvUsersAdded.getCount() + ". Total users removed: " + this.passiveProvUsersRemoved.getCount() + ". Total users skipped: " + this.passiveProvUsersSkipped.getCount() + ".";
        logger.info(summaryMessage);
        String groupSummaryMessage = "Total groups processed: " + this.passiveProvGroupsScanned.getCount() + ". Total groups added: " + this.passiveProvGroupsAdded.getCount() + ". Total groups removed: " + this.passiveProvGroupsRemoved.getCount();
        logger.info(groupSummaryMessage);
    }

    public void startPassiveProvisioning() {
        this.passiveProvStartTime = System.currentTimeMillis();
    }

    public void attributeSyncUserProcessed() {
        this.attributeSyncUsersProcessed.increment();
        if (this.attributeSyncUsersProcessed.getCountSinceLastLog() >= 500) {
            this.logAttributeSyncProgressMessage();
        }
    }

    public void attributeSyncUserUpdated() {
        this.attributeSyncUsersUpdated.increment();
        this.attributeSyncUserProcessed();
    }

    public void attributeSyncUserNotUpdated() {
        this.attributeSyncUserProcessed();
    }

    public void attributeSyncUserSkipped() {
        this.attributeSyncUsersSkipped.increment();
        this.attributeSyncUserProcessed();
    }

    public void attributeSyncUserError() {
        this.attributeSyncUserErrors.increment();
        this.attributeSyncUserProcessed();
    }

    public void logAttributeSyncSummary() {
        if (this.attributeSyncUsersProcessed.getCountSinceLastLog() > 0) {
            this.logAttributeSyncProgressMessage();
        }
        String summaryMessage = "Attribute update detection stage completed in " + (System.currentTimeMillis() - this.attributeSyncStartTime) + " ms. Total users processed: " + this.attributeSyncUsersProcessed.getCount() + ". Total users updated: " + this.attributeSyncUsersUpdated.getCount() + ". Total users skipped: " + this.attributeSyncUsersSkipped.getCount() + ". Total errors: " + this.attributeSyncUserErrors.getCount();
        logger.info(summaryMessage);
    }

    public void logAttributeSyncProgressMessage() {
        logger.info("Processed " + this.attributeSyncUsersProcessed.getCountSinceLastLog() + " users. Users updated: " + this.attributeSyncUsersUpdated.getCountSinceLastLog() + ". Users skipped: " + this.attributeSyncUsersSkipped.getCountSinceLastLog() + ". Errors: " + this.attributeSyncUserErrors.getCountSinceLastLog());
        this.attributeSyncUsersProcessed.resetLogCount();
        this.attributeSyncUsersUpdated.resetLogCount();
        this.attributeSyncUserErrors.resetLogCount();
        this.attributeSyncUsersSkipped.resetLogCount();
    }

    public void startAttributeSync() {
        this.attributeSyncStartTime = System.currentTimeMillis();
    }

    public void newUserPushedToTarget() {
        this.usersPushedToTarget.increment();
        this.userProcessed();
    }

    public void userDeprovisionedFromTarget() {
        this.usersDeprovisionedFromTarget.increment();
        this.userProcessed();
    }

    public void userUpdatedAtTarget() {
        this.usersUpdatedAtTarget.increment();
        this.userProcessed();
    }

    public void newGroupPushedToTarget() {
        this.groupsPushedToTarget.increment();
    }

    public void groupDeprovisionedFromTarget() {
        this.groupsDeprovisionedFromTarget.increment();
    }

    public void userProcessed() {
        this.usersProcessed.increment();
        if (this.usersProcessed.getCountSinceLastLog() >= 500) {
            this.logUserProgressMessage();
        }
    }

    private void logUserProgressMessage() {
        logger.info("Processed " + this.usersProcessed.getCountSinceLastLog() + " users. Users created: " + this.usersPushedToTarget.getCountSinceLastLog() + ". Users updated: " + this.usersUpdatedAtTarget.getCountSinceLastLog() + ". Users deprovisioned: " + this.usersDeprovisionedFromTarget.getCountSinceLastLog());
        this.usersProcessed.resetLogCount();
        this.usersPushedToTarget.resetLogCount();
        this.usersUpdatedAtTarget.resetLogCount();
        this.usersDeprovisionedFromTarget.resetLogCount();
    }

    public void logTargetProvSummary() {
        if (this.usersProcessed.getCountSinceLastLog() > 0) {
            this.logUserProgressMessage();
        }
        String summaryMessage = "Finished pushing user/group updates to the target. Completed in " + (System.currentTimeMillis() - this.targetProvStartTime) + " ms. Total users created " + this.usersPushedToTarget.getCount() + ". Total users updated " + this.usersUpdatedAtTarget.getCount() + ". Total users deprovisioned " + this.usersDeprovisionedFromTarget.getCount();
        logger.info(summaryMessage);
    }

    public void startTargetProvisioning() {
        this.targetProvStartTime = System.currentTimeMillis();
    }

    public void logCycleSummary() {
        String summaryMessage = "Provisioning Cycle " + this.cycleId + " for channel " + this.channelName + " (" + this.channelCode + ") in " + this.connectionName + " connection completed in " + (Instant.now().toEpochMilli() - this.cycleStartTime.toEpochMilli()) + " ms";
        summaryMessage = summaryMessage + "\n\tNumber of users added in source: " + this.passiveProvUsersAdded.getCount();
        summaryMessage = summaryMessage + "\n\tNumber of users removed in source: " + this.passiveProvUsersRemoved.getCount();
        summaryMessage = summaryMessage + "\n\tNumber of users updated in source: " + this.attributeSyncUsersUpdated.getCount();
        summaryMessage = summaryMessage + "\n\tNumber of users created in target: " + this.usersPushedToTarget.getCount();
        summaryMessage = summaryMessage + "\n\tNumber of users updated in target: " + this.usersUpdatedAtTarget.getCount();
        summaryMessage = summaryMessage + "\n\tNumber of users deprovisioned from target: " + this.usersDeprovisionedFromTarget.getCount();
        summaryMessage = summaryMessage + "\n\tNumber of groups created in target: " + this.groupsPushedToTarget.getCount();
        summaryMessage = summaryMessage + "\n\tNumber of groups updated in target: " + this.groupsUpdatedAtTarget.getCount();
        summaryMessage = summaryMessage + "\n\tNumber of groups deprovisioned from target: " + this.groupsDeprovisionedFromTarget.getCount();
        summaryMessage = summaryMessage + "\n\tTotal time taken: " + (System.currentTimeMillis() - this.cycleStartTime.toEpochMilli()) + " ms";
        summaryLogger.info(summaryMessage);
    }

    private static class Counter {
        private int count = 0;
        private int countSinceLastLog = 0;

        private Counter() {
        }

        public void increment() {
            ++this.count;
            ++this.countSinceLastLog;
        }

        public int getCount() {
            return this.count;
        }

        public int getCountSinceLastLog() {
            return this.countSinceLastLog;
        }

        public void resetLogCount() {
            this.countSinceLastLog = 0;
        }
    }
}

