/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.monitor;

import com.pingidentity.provisioner.monitor.Event;
import com.pingidentity.provisioner.monitor.ProvisionerAuditLogger;
import com.pingidentity.provisioner.monitor.SaasProvisioningCycleIdHelper;
import com.pingidentity.provisioner.monitor.SaasProvisioningEventTracker;
import com.pingidentity.provisioner.saas.SaasException;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SaasProvisioningEventTrackerLog4jImpl
implements SaasProvisioningEventTracker {
    private static final Log log = LogFactory.getLog(SaasProvisioningEventTracker.class);

    @Override
    public void trackEvent(String sourceId, String targetId, SaasProvisioningEventTracker.EventType type, int channelId, SaasException failureCause) {
        ProvisionerAuditLogger provisionerauditLogger = null;
        if (this.isValidAuditLogEntry(type)) {
            long cycleId = SaasProvisioningCycleIdHelper.getInstance().getCycleId();
            String message = failureCause != null ? failureCause.getMessage() : null;
            Event event = new Event(cycleId, new Date(), sourceId, targetId, type, channelId, message);
            provisionerauditLogger = new ProvisionerAuditLogger(event);
            provisionerauditLogger.setAttributesToLog();
            provisionerauditLogger.log();
            provisionerauditLogger.clearThreadContext();
        }
    }

    @Override
    public void trackEvent(SaasProvisioningEventTracker.EventType type) {
        this.trackEvent(null, null, type, -1, null);
    }

    private boolean isValidAuditLogEntry(SaasProvisioningEventTracker.EventType eventType) {
        return eventType == null || !eventType.equals((Object)SaasProvisioningEventTracker.EventType.START_CYCLE) && !eventType.equals((Object)SaasProvisioningEventTracker.EventType.STOP_CYCLE) && !eventType.equals((Object)SaasProvisioningEventTracker.EventType.CREATE_USER_INTERNAL) && !eventType.equals((Object)SaasProvisioningEventTracker.EventType.UPDATE_USER_INTERNAL) && !eventType.equals((Object)SaasProvisioningEventTracker.EventType.DELETE_USER_INTERNAL) && !eventType.equals((Object)SaasProvisioningEventTracker.EventType.CREATE_GROUP_INTERNAL) && !eventType.equals((Object)SaasProvisioningEventTracker.EventType.UPDATE_GROUP_INTERNAL) && !eventType.equals((Object)SaasProvisioningEventTracker.EventType.DELETE_GROUP_INTERNAL);
    }
}

