/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.resources;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ProvisionableResource {
    protected static final String TO_STRING_SEPARATOR = "; ";
    private static Logger _logger = LogManager.getLogger(ProvisionableResource.class);
    private Map<String, List<String>> _attributeMap;

    protected ProvisionableResource(Map<String, List<String>> attributeMap) {
        this._attributeMap = attributeMap;
    }

    public Set<String> getNames() {
        return this._attributeMap.keySet();
    }

    public String getValue(String name) {
        List<String> values = this._attributeMap.get(name);
        if (values == null || values.size() == 0) {
            return "";
        }
        if (values.size() > 1) {
            _logger.warn("Multiple values for " + name + " attribute, using only first!");
        }
        return values.get(0);
    }

    public boolean hasValue(String name) {
        return this._attributeMap.containsKey(name);
    }

    public List<String> getValues(String name) {
        List<String> values = this._attributeMap.get(name);
        if (values == null) {
            values = new ArrayList<String>();
        }
        return Collections.unmodifiableList(values);
    }

    public void putValues(String name, String first, String ... rest) {
        ArrayList<String> values = new ArrayList<String>();
        values.add(first);
        values.addAll(Arrays.asList(rest));
        this._attributeMap.put(name, values);
    }

    public void putValues(String name, Collection<String> valueColl) {
        if (valueColl.size() > 0) {
            ArrayList<String> values = new ArrayList<String>();
            values.addAll(valueColl);
            this._attributeMap.put(name, values);
        }
    }

    public void addValues(String name, String first, String ... rest) {
        List<String> values = this._attributeMap.get(name);
        if (values == null) {
            values = new ArrayList<String>(1 + rest.length);
            this._attributeMap.put(name, values);
        }
        values.add(first);
        values.addAll(Arrays.asList(rest));
    }

    public void setNameValues(Map<String, List<String>> nameValuesMap) {
        this.clear();
        for (String name : nameValuesMap.keySet()) {
            this.putValues(name, (Collection<String>)nameValuesMap.get(name));
        }
    }

    public void removeAll(String name) {
        this._attributeMap.remove(name);
    }

    public void clear() {
        this._attributeMap.clear();
    }

    public boolean contains(String name) {
        return this._attributeMap.containsKey(name);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.toString(builder);
        return builder.toString();
    }

    public void toString(StringBuilder builder) {
        builder.append("Attributes: ");
        boolean first = true;
        for (String name : this.getNames()) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append(name).append('=');
            List<String> values = this.getValues(name);
            builder.append(values.toString());
        }
        builder.append(TO_STRING_SEPARATOR);
    }
}

