/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.saas;

import com.pingidentity.provisioner.identity.SaasGroup;
import com.pingidentity.provisioner.identity.SaasIdentity;
import com.pingidentity.provisioner.saas.BaseSaasPlugin;
import com.pingidentity.provisioner.saas.SaasException;
import com.pingidentity.provisioner.store.UserUpdater;
import com.pingidentity.provisioner.store.groups.GroupStoreUpdater;
import com.pingidentity.provisioner.util.UserActivityLogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;

public class NoopSaasPlugin
extends BaseSaasPlugin {
    private static Logger _userLogger = UserActivityLogger.getLogger();
    private long _apiCallTimeMillis = 1000L;

    public NoopSaasPlugin(String usernameFieldCode) {
        this.setSaasUsernameFieldCode(usernameFieldCode);
    }

    public void setApiCallTimeMillis(long apiCallTimeMillis) {
        this._apiCallTimeMillis = apiCallTimeMillis;
    }

    @Override
    public List<FieldDescriptor> getParameterDescriptors() {
        return new ArrayList<FieldDescriptor>();
    }

    @Override
    protected void doLoadFieldsInfo() throws SaasException {
        try {
            this.setFieldInfos("com/pingidentity/provisioner/saas/noop/fields.properties");
        }
        catch (IOException e) {
            throw new SaasException("Cannot parse fields information!", e);
        }
    }

    @Override
    protected SaasIdentity doGetUser(SaasIdentity identity) throws SaasException {
        this.sleep();
        String saasGuid = identity.getGuid();
        if (saasGuid != null && saasGuid.endsWith("::NoopSaasPlugin")) {
            return identity;
        }
        return null;
    }

    @Override
    protected void doUpdateUser(SaasIdentity updatedIdentity, SaasIdentity existingIdentity, UserUpdater userUpdater) throws SaasException {
        String username = updatedIdentity.getValue(this.getSaasUsernameFieldCode());
        this.sleep();
        userUpdater.clearDirtyFlag();
        _userLogger.info((Object)("Updated: " + username));
    }

    @Override
    protected void doCreateUser(SaasIdentity identity, UserUpdater userUpdater) throws SaasException {
        String username = identity.getValue(this.getSaasUsernameFieldCode());
        this.sleep();
        userUpdater.clearDirtyFlag();
        userUpdater.setSaasGuid(username + "::NoopSaasPlugin");
        _userLogger.info((Object)("Created: " + username));
    }

    @Override
    protected Properties loadDefaultMappings() throws IOException {
        return new Properties();
    }

    private void sleep() {
        try {
            Thread.sleep(this._apiCallTimeMillis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public String getId() {
        return "noop";
    }

    @Override
    public int getDefaultMaxThreads() {
        return 1;
    }

    @Override
    public String getDescription() {
        return "NoOp Plugin";
    }

    public void deleteGroup(SaasGroup group, GroupStoreUpdater userUpdater, String sourceGuid) throws SaasException {
    }

    public void updateGroup(SaasGroup group, GroupStoreUpdater userUpdater, String sourceGuid) throws SaasException {
    }
}

