/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.saas;

import com.pingidentity.common.util.AdapterUtils;
import com.pingidentity.pingcommons.util.Closer;
import com.pingidentity.provisioner.saas.BaseSaasPlugin;
import com.pingidentity.provisioner.saas.SaasProvisionerPlugin;
import com.pingidentity.provisioner.saas.SaasProvisionerPluginInfo;
import com.pingidentity.sdk.PluginFipsStatus;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SaasPluginManager {
    public static final String PLUGIN_DESCRIPTOR = "PF-INF/saas-provisioning-plugin-descriptor";
    private static Logger logger = LogManager.getLogger(SaasPluginManager.class);
    private static volatile SaasPluginManager instance = new SaasPluginManager();
    private Map<String, String> pluginId2Class;
    private Map<String, String> pluginId2Description;
    private Map<String, SaasProvisionerPluginInfo> pluginId2Info;

    public static SaasPluginManager getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadPluginDescriptors() {
        BufferedReader bufferedReader = null;
        try {
            this.pluginId2Class = new HashMap<String, String>();
            this.pluginId2Description = new HashMap<String, String>();
            this.pluginId2Info = new HashMap<String, SaasProvisionerPluginInfo>();
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Enumeration<URL> urls = classLoader.getResources(PLUGIN_DESCRIPTOR);
            while (urls.hasMoreElements()) {
                String pluginClassName;
                URL url = urls.nextElement();
                Object content = url.getContent();
                if (!(content instanceof InputStream)) continue;
                InputStream is = (InputStream)content;
                bufferedReader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
                while ((pluginClassName = bufferedReader.readLine()) != null) {
                    SaasProvisionerPlugin instance;
                    SaasProvisionerPlugin saasDriver = this.createPluginInstanceFromClassName(pluginClassName);
                    if (saasDriver == null) continue;
                    String pluginId = saasDriver.getId();
                    if (this.pluginId2Class.containsKey(pluginId)) {
                        logger.warn("Duplicate plugin detected. A plugin with id '" + pluginId + "' has already been loaded.");
                        continue;
                    }
                    if (this.createPluginInstanceFromClassName(pluginClassName) == null || (instance = this.createPluginInstanceFromClassName(pluginClassName)) == null) continue;
                    boolean userSelectable = true;
                    if (instance instanceof BaseSaasPlugin) {
                        userSelectable = ((BaseSaasPlugin)instance).isUserSelectable();
                    }
                    this.pluginId2Class.put(pluginId, pluginClassName);
                    this.pluginId2Description.put(pluginId, saasDriver.getDescription());
                    PluginFipsStatus fipsStatus = AdapterUtils.getPluginFipsStatus((String)pluginClassName, saasDriver.getMetadata());
                    this.pluginId2Info.put(pluginId, new SaasProvisionerPluginInfo(pluginId, pluginClassName, saasDriver.getDescription(), userSelectable, fipsStatus));
                }
            }
        }
        catch (IOException e) {
            logger.error((Object)e);
            boolean bl = false;
            return bl;
        }
        finally {
            Closer.close(bufferedReader);
        }
        return true;
    }

    public SaasProvisionerPlugin getPluginInstance(String pluginId) {
        String pluginClassName = this.pluginId2Class.get(pluginId);
        if (pluginClassName == null) {
            return null;
        }
        return this.createPluginInstanceFromClassName(pluginClassName);
    }

    public int getNumberOfPluginsLoaded() {
        return this.pluginId2Description.size();
    }

    public Map<String, String> getPluginIds() {
        return Collections.unmodifiableMap(this.pluginId2Description);
    }

    public SaasProvisionerPluginInfo getPluginInfo(String id) {
        return this.pluginId2Info.get(id);
    }

    public String getPluginDescription(String pluginId) {
        return this.pluginId2Description.get(pluginId);
    }

    private SaasProvisionerPlugin createPluginInstanceFromClassName(String className) {
        try {
            Class<?> pluginClass = Class.forName(className);
            return (SaasProvisionerPlugin)pluginClass.newInstance();
        }
        catch (Exception e) {
            logger.error("Cannot instantiate plugin class: " + className, (Throwable)e);
            return null;
        }
    }

    static {
        boolean success = instance.loadPluginDescriptors();
        if (!success) {
            logger.error("Cannot instantiante SaasPluginManager!");
        }
    }
}

