/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.store;

import com.pingidentity.provisioner.identity.SaasIdentity;
import com.pingidentity.provisioner.mapping.IdentityMapper;
import com.pingidentity.provisioner.saas.SaasException;
import com.pingidentity.provisioner.store.DuplicateKeyException;
import com.pingidentity.provisioner.store.ProvisionableResourceMeta;
import com.pingidentity.provisioner.store.SaasProvisionableResourceCallback;
import com.pingidentity.provisioner.store.UserStore;
import com.pingidentity.provisioner.store.UserStoreUpdater;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class InMemoryUserStore
implements UserStore {
    private Map<String, ProvisionableResourceMeta> _store = new HashMap<String, ProvisionableResourceMeta>();

    @Override
    public void loadDirectoryServerGuids(Set<String> inside, Set<String> outside) {
        for (String guid : this._store.keySet()) {
            ProvisionableResourceMeta userRecord = this._store.get(guid);
            if (userRecord.isInGroup()) {
                inside.add(guid);
                continue;
            }
            outside.add(guid);
        }
    }

    @Override
    public void create(String directoryServerGuid, SaasIdentity saasIdentity, boolean inProvisioningGroup) throws DuplicateKeyException {
        this.isNameUnique(directoryServerGuid, saasIdentity.getName());
        ProvisionableResourceMeta userRecord = new ProvisionableResourceMeta();
        userRecord.setInGroup(inProvisioningGroup);
        userRecord.setValuesHash(saasIdentity.calculateValuesHash());
        userRecord.setSaasUsername(saasIdentity.getName());
        userRecord.setDirty(true);
        userRecord.setSaasProvisionableResource(saasIdentity);
        this._store.put(directoryServerGuid, userRecord);
    }

    @Override
    public boolean update(String directoryServerGuid, SaasIdentity saasIdentity) throws DuplicateKeyException {
        this.isNameUnique(directoryServerGuid, saasIdentity.getName());
        ProvisionableResourceMeta userRecord = this._store.get(directoryServerGuid);
        userRecord.setValuesHash(saasIdentity.calculateValuesHash());
        userRecord.setSaasUsername(saasIdentity.getName());
        userRecord.setDirty(true);
        userRecord.setModified(new Date());
        userRecord.setSaasProvisionableResource(saasIdentity);
        return true;
    }

    @Override
    public boolean update(String directoryServerGuid, SaasIdentity saasIdentity, boolean inProvisioningGroup) throws DuplicateKeyException {
        this.isNameUnique(directoryServerGuid, saasIdentity.getName());
        ProvisionableResourceMeta userRecord = this._store.get(directoryServerGuid);
        userRecord.setInGroup(inProvisioningGroup);
        userRecord.setValuesHash(saasIdentity.calculateValuesHash());
        userRecord.setSaasUsername(saasIdentity.getName());
        userRecord.setDirty(true);
        userRecord.setModified(new Date());
        userRecord.setSaasProvisionableResource(saasIdentity);
        return true;
    }

    @Override
    public boolean updateChannel(String directoryServerGuid, SaasIdentity saasIdentity, boolean inProvisioningGroup, int oldChannel) throws DuplicateKeyException {
        return this.update(directoryServerGuid, saasIdentity, inProvisioningGroup);
    }

    @Override
    public boolean removeIfNotDirty(String directoryServerGuid) {
        ProvisionableResourceMeta userRecord = this._store.get(directoryServerGuid);
        if (!userRecord.isDirty()) {
            this._store.remove(directoryServerGuid);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(String directoryServerGuid) {
        this._store.remove(directoryServerGuid);
        return true;
    }

    @Override
    public String getValuesHash(String directoryServerGuid) {
        ProvisionableResourceMeta userRecord = this._store.get(directoryServerGuid);
        return userRecord.getValuesHash();
    }

    @Override
    public String getSaasUsername(String directoryServerGuid) {
        ProvisionableResourceMeta userRecord = this._store.get(directoryServerGuid);
        return userRecord.getSaasUsername();
    }

    @Override
    public void processDirty(SaasProvisionableResourceCallback callback, IdentityMapper identityMapper) throws SaasException {
        this.processDirty(callback, identityMapper, null);
    }

    @Override
    public void processDirty(SaasProvisionableResourceCallback callback, IdentityMapper identityMapper, Set<String> usersToIgnore) throws SaasException {
        for (Map.Entry<String, ProvisionableResourceMeta> entry : this._store.entrySet()) {
            String guid = entry.getKey();
            ProvisionableResourceMeta userRecord = entry.getValue();
            if (!userRecord.isDirty() || usersToIgnore != null && usersToIgnore.contains(guid)) continue;
            SaasIdentity saasIdentity = (SaasIdentity)userRecord.getSaasProvisionableResource();
            saasIdentity.setSaasGuid(userRecord.getSaasGuid());
            saasIdentity.setInProvisioningGroup(userRecord.isInGroup());
            String usernameToMask = null;
            if (saasIdentity.isNameMasked()) {
                usernameToMask = saasIdentity.getName();
            }
            callback.process(userRecord.getSaasProvisionableResource(), new UserStoreUpdater(this, guid, usernameToMask), guid);
        }
    }

    @Override
    public void clearDirtyFlag(String directoryServerGuid) {
        ProvisionableResourceMeta userRecord = this._store.get(directoryServerGuid);
        userRecord.setDirty(false);
        userRecord.setSaasProvisionableResource(null);
        userRecord.setModified(new Date());
    }

    @Override
    public void setSaasGuid(String directoryServerGuid, String saasGuid, boolean maskGuid) {
        ProvisionableResourceMeta userRecord = this._store.get(directoryServerGuid);
        userRecord.setSaasGuid(saasGuid);
        userRecord.setModified(new Date());
    }

    @Override
    public void resetValuesHash() {
        for (ProvisionableResourceMeta userRecord : this._store.values()) {
            userRecord.setValuesHash(null);
        }
    }

    @Override
    public int getUserCount() {
        return this._store.size();
    }

    @Override
    public int getDirtyUserCount() {
        int count = 0;
        for (ProvisionableResourceMeta userRecord : this._store.values()) {
            if (!userRecord.isDirty()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int deleteAllUsers() {
        int cnt = this._store.size();
        this._store.clear();
        return cnt;
    }

    protected void isNameUnique(String directoryServerGuid, String saasUsername) throws DuplicateKeyException {
        boolean collides = false;
        ProvisionableResourceMeta userRecord = this.getUserMetaBySaasUsername(saasUsername);
        if (userRecord != null && !userRecord.getDirectoryServerGuid().equals(directoryServerGuid)) {
            throw new DuplicateKeyException("Key collision", saasUsername);
        }
    }

    @Override
    public ProvisionableResourceMeta getUserMetaBySaasUsername(String saasUsername) {
        for (ProvisionableResourceMeta userRecord : this._store.values()) {
            if (!userRecord.getSaasUsername().equals(saasUsername)) continue;
            return userRecord;
        }
        return null;
    }

    @Override
    public ProvisionableResourceMeta getUserMetaByDirectoryGuid(String directoryServerGuid) {
        return this._store.get(directoryServerGuid);
    }

    @Override
    public Set<String> getAllUserGuids() {
        HashSet<String> allUserGuids = new HashSet<String>();
        for (ProvisionableResourceMeta userRecord : this._store.values()) {
            allUserGuids.add(userRecord.getDirectoryServerGuid());
        }
        return allUserGuids;
    }

    @Override
    public void setSaasIdentity(String directoryServerGuid, SaasIdentity saasIdentity, Set<String> fields) {
    }
}

