/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.store.groups;

import com.pingidentity.provisioner.store.DataStoreUpdater;
import com.pingidentity.provisioner.store.ProvisionableResourceMeta;
import com.pingidentity.provisioner.store.groups.GroupStore;

public class GroupStoreUpdater
implements DataStoreUpdater {
    private GroupStore groupStore;
    private String directoryServerGuid;
    private boolean markForSecondProv;

    public GroupStoreUpdater(GroupStore store, String guid, boolean markForSecondProv) {
        this.groupStore = store;
        this.directoryServerGuid = guid;
        this.markForSecondProv = markForSecondProv;
    }

    @Override
    public void clearDirtyFlag() {
        this.groupStore.clearDirtyFlag(this.directoryServerGuid, true);
    }

    @Override
    public void setSaasGuid(String saasGuid) {
        this.groupStore.setSaasGuid(this.directoryServerGuid, saasGuid);
    }

    @Override
    public ProvisionableResourceMeta getResourceMetaBySaasUsername(String saasUniqueName) {
        return this.groupStore.getMetaBySaasName(saasUniqueName);
    }

    public boolean isMarkForSecondProv() {
        return this.markForSecondProv;
    }

    public void markGroupForSecondPhase() {
        if (this.markForSecondProv) {
            this.groupStore.markGroupForSecondPhase(this.directoryServerGuid);
        }
    }
}

