/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.store.groups;

import com.pingidentity.provisioner.identity.SaasGroup;
import com.pingidentity.provisioner.monitor.SaasProvisioningEventTracker;
import com.pingidentity.provisioner.saas.SaasException;
import com.pingidentity.provisioner.store.ProvisionableResourceMeta;
import com.pingidentity.provisioner.store.SaasProvisionableResourceCallback;
import com.pingidentity.provisioner.store.groups.GroupStore;
import com.pingidentity.provisioner.store.groups.GroupStoreException;
import java.util.Map;
import java.util.Set;

public class GroupStoreWithEventTracking
implements GroupStore {
    private int channelId;
    private GroupStore groupStore;
    private SaasProvisioningEventTracker eventTracker;

    public GroupStoreWithEventTracking(GroupStore gs, int chanId, SaasProvisioningEventTracker et) {
        this.channelId = chanId;
        this.groupStore = gs;
        this.eventTracker = et;
    }

    @Override
    public void clearDirtyFlag(String directoryServerGuid, boolean groupModified) {
        this.groupStore.clearDirtyFlag(directoryServerGuid, groupModified);
        this.eventTracker.trackEvent(directoryServerGuid, null, SaasProvisioningEventTracker.EventType.UPDATE_GROUP_INTERNAL, this.channelId, null);
    }

    @Override
    public void create(String directoryServerGuid, SaasGroup saasGroup, boolean inProvisioningGroup) throws GroupStoreException {
        String targetId = saasGroup.hasGuid() ? saasGroup.getGuid() : saasGroup.getName();
        try {
            this.groupStore.create(directoryServerGuid, saasGroup, inProvisioningGroup);
            this.eventTracker.trackEvent(directoryServerGuid, targetId, SaasProvisioningEventTracker.EventType.CREATE_GROUP_INTERNAL, this.channelId, null);
        }
        catch (GroupStoreException gse) {
            this.eventTracker.trackEvent(directoryServerGuid, targetId, SaasProvisioningEventTracker.EventType.CREATE_GROUP_INTERNAL, this.channelId, gse);
            throw gse;
        }
    }

    @Override
    public void loadDirectoryServerGuids(Map<String, SaasGroup> insideGroups, Map<String, SaasGroup> outsideGroups) {
        this.groupStore.loadDirectoryServerGuids(insideGroups, outsideGroups);
    }

    @Override
    public void processDirty(SaasProvisionableResourceCallback callback, Set<String> saasIdentityMaskedFields) throws SaasException {
        this.groupStore.processDirty(callback, saasIdentityMaskedFields);
    }

    @Override
    public void setSaasGuid(String directoryServerGuid, String saasGuid) {
        this.groupStore.setSaasGuid(directoryServerGuid, saasGuid);
        this.eventTracker.trackEvent(directoryServerGuid, saasGuid, SaasProvisioningEventTracker.EventType.UPDATE_GROUP_INTERNAL, this.channelId, null);
    }

    @Override
    public boolean update(String directoryServerGuid, SaasGroup saasGroup, boolean inProvisioningGroup) {
        boolean success = this.groupStore.update(directoryServerGuid, saasGroup, inProvisioningGroup);
        if (success) {
            String targetId = saasGroup.hasGuid() ? saasGroup.getGuid() : saasGroup.getName();
            this.eventTracker.trackEvent(directoryServerGuid, targetId, SaasProvisioningEventTracker.EventType.UPDATE_GROUP_INTERNAL, this.channelId, null);
        }
        return success;
    }

    @Override
    public boolean removeIfNotDirty(String directoryServerGuid) {
        boolean success = this.groupStore.removeIfNotDirty(directoryServerGuid);
        if (success) {
            this.eventTracker.trackEvent(directoryServerGuid, null, SaasProvisioningEventTracker.EventType.DELETE_GROUP_INTERNAL, this.channelId, null);
        }
        return success;
    }

    @Override
    public int deleteAllGroups() {
        return this.groupStore.deleteAllGroups();
    }

    @Override
    public ProvisionableResourceMeta getMetaByDirectoryGuid(String directoryServerGuid) {
        return this.groupStore.getMetaByDirectoryGuid(directoryServerGuid);
    }

    @Override
    public ProvisionableResourceMeta getMetaBySaasName(String saasName) {
        return this.groupStore.getMetaBySaasName(saasName);
    }

    @Override
    public int getDirtyGroupCount() {
        return this.groupStore.getDirtyGroupCount();
    }

    @Override
    public Set<String> getAllProvisionedGroupDsGuidsInCycle() {
        return this.groupStore.getAllProvisionedGroupDsGuidsInCycle();
    }

    @Override
    public String getValuesHash(String directoryServerGuid, boolean cleanRecordsOnly) {
        return this.groupStore.getValuesHash(directoryServerGuid, cleanRecordsOnly);
    }

    @Override
    public void updateValuesHashWithMembers(SaasGroup group) {
        this.groupStore.updateValuesHashWithMembers(group);
    }

    @Override
    public void markGroupForSecondPhase(String directoryServerGuid) {
        this.groupStore.markGroupForSecondPhase(directoryServerGuid);
    }
}

