/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.store.jdbc;

import com.pingidentity.common.util.TinyHashSet;
import com.pingidentity.provisioner.identity.SaasGroup;
import com.pingidentity.provisioner.saas.SaasException;
import com.pingidentity.provisioner.store.ProvisionableResourceMeta;
import com.pingidentity.provisioner.store.SaasProvisionableResourceCallback;
import com.pingidentity.provisioner.store.groups.GroupMembershipStore;
import com.pingidentity.provisioner.store.groups.GroupStore;
import com.pingidentity.provisioner.store.groups.GroupStoreException;
import com.pingidentity.provisioner.store.groups.GroupStoreUpdater;
import com.pingidentity.provisioner.store.jdbc.SaasDataAccessException;
import com.pingidentity.provisioner.store.jdbc.SaasResourcePacker;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.codec.binary.Hex;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;

public class JdbcGroupStore
implements GroupStore {
    private static Logger _logger = LogManager.getLogger(JdbcGroupStore.class);
    private static final String VALUES_HASH_ALGORITHM = "MD5";
    private static final int FLAG_NOT_DIRTY = 0;
    public static final int FLAG_DIRTY_NOT_EXISTS = 1;
    private static final int FLAG_DIRTY_EXISTS = 2;
    private static final int FLAG_DIRTY_NOT_EXISTS_SECOND_STEP = 3;
    private final int _channelId;
    private final JdbcTemplate _jdbcTpl;
    private final List<Integer> _prevChannelIds;
    private final GroupMembershipStore _membershipStore;

    public JdbcGroupStore(DataSource dataSource, int channelId, List<Integer> previousChannelIds, GroupMembershipStore membershipStore) {
        this._channelId = channelId;
        this._jdbcTpl = new JdbcTemplate(dataSource);
        this._prevChannelIds = previousChannelIds;
        this._membershipStore = membershipStore;
    }

    @Override
    public void create(String directoryServerGuid, SaasGroup saasGroup, boolean inProvisioningGroup) throws GroupStoreException {
        Timestamp now = JdbcGroupStore.timestampNow();
        String sql = "INSERT INTO channel_group (channel, dsGuid, saasGroupName, valuesHash, inGroup, dirty, saasGroup, created, modified) VALUES (?,?,?,?,?,1,?,?,?)";
        String saasGroupName = saasGroup.getName();
        String saasGroupString = SaasResourcePacker.pack(saasGroup);
        int inGroup = inProvisioningGroup ? 1 : 0;
        String hashValue = this.getHashValueWithoutMembers(saasGroup);
        if (_logger.isDebugEnabled()) {
            _logger.debug("Inserting group to JDBC store: channel=" + this._channelId + ", dsGUID=" + directoryServerGuid + ", saasGroupName=" + saasGroupName + ", valuesHash=" + hashValue + ", inGroup=" + inGroup + ", saasGroup=" + saasGroupString);
        }
        try {
            this._jdbcTpl.update(sql, new Object[]{this._channelId, directoryServerGuid, saasGroupName, hashValue, inGroup, saasGroupString, now, now});
        }
        catch (DataIntegrityViolationException dive) {
            throw new GroupStoreException("Unable insert to channel group " + saasGroup.getName() + ": " + dive.getMessage(), dive);
        }
    }

    private String getHashValueWithoutMembers(SaasGroup saasGroup) {
        try {
            MessageDigest md5 = MessageDigest.getInstance(VALUES_HASH_ALGORITHM);
            try {
                md5.update(saasGroup.getName().getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            byte[] digest = md5.digest();
            return new String(Hex.encodeHex((byte[])digest));
        }
        catch (NoSuchAlgorithmException e) {
            _logger.error("Cant find MD5 algorithm", (Throwable)e);
            return null;
        }
    }

    @Override
    public void loadDirectoryServerGuids(final Map<String, SaasGroup> insideGroups, final Map<String, SaasGroup> outsideGroups) {
        String sql = "SELECT dsGuid, inGroup, saasGroup FROM channel_group WHERE channel=?";
        RowCallbackHandler rowCallbackHandler = new RowCallbackHandler(){

            public void processRow(ResultSet resultSet) throws SQLException {
                String dsGuid = resultSet.getString(1);
                boolean inProvisioningGroup = resultSet.getBoolean(2);
                String saasGroupString = resultSet.getString(3);
                SaasGroup saasGroup = JdbcGroupStore.string2SaasGroup(saasGroupString, null, dsGuid, inProvisioningGroup);
                if (resultSet.getBoolean(2)) {
                    insideGroups.put(dsGuid, saasGroup);
                } else {
                    outsideGroups.put(dsGuid, saasGroup);
                }
            }
        };
        this._jdbcTpl.query(sql, new Object[]{this._channelId}, rowCallbackHandler);
    }

    @Override
    public boolean update(String directoryServerGuid, SaasGroup saasGroup, boolean inProvisioningGroup) {
        int numberOfUpdates;
        String dontOverwriteNewDirtySql = "UPDATE channel_group SET saasGroupName=?, inGroup=?, dirty=2, saasGroup=?, modified=?, valuesHash=? WHERE channel=? AND dsGuid=? AND dirty!=?";
        String saasGroupName = saasGroup.getName();
        String saasGroupString = SaasResourcePacker.pack(saasGroup);
        int inGroup = inProvisioningGroup ? 1 : 0;
        String hashValue = this.getHashValueWithoutMembers(saasGroup);
        if (_logger.isDebugEnabled()) {
            _logger.debug("Updating group in JDBC store: channel=" + this._channelId + ", dsGUID=" + directoryServerGuid + ", saasGroupName=" + saasGroupName + ", valuesHash=" + hashValue + ", inGroup=" + inGroup + ", saasGroup=" + saasGroupString);
        }
        if ((numberOfUpdates = this._jdbcTpl.update(dontOverwriteNewDirtySql, new Object[]{saasGroupName, inGroup, saasGroupString, JdbcGroupStore.timestampNow(), hashValue, this._channelId, directoryServerGuid, 1})) == 0) {
            String dontChangeDirtySql = "UPDATE channel_group SET saasGroupName=?, inGroup=?, saasGroup=?, modified=?, valuesHash=? WHERE channel=? AND dsGuid=?";
            numberOfUpdates = this._jdbcTpl.update(dontChangeDirtySql, new Object[]{saasGroupName, inGroup, saasGroupString, JdbcGroupStore.timestampNow(), hashValue, this._channelId, directoryServerGuid});
        }
        return numberOfUpdates > 0;
    }

    @Override
    public void processDirty(SaasProvisionableResourceCallback callback, Set<String> saasIdentityMaskedFields) throws SaasException {
        try {
            if (_logger.isDebugEnabled()) {
                _logger.debug("Provisioning groups to SP - 1st phase: channel=" + this._channelId);
            }
            String firstPhaseSql = "SELECT dsGuid, saasGuid, saasGroup, inGroup FROM channel_group WHERE channel=? AND dirty=1";
            ProvisionGroupCallbackHandler firstPhaseCallbackHandler = new ProvisionGroupCallbackHandler((JdbcOperations)this._jdbcTpl, callback, saasIdentityMaskedFields, false);
            this._jdbcTpl.query(firstPhaseSql, new Object[]{this._channelId}, (RowCallbackHandler)firstPhaseCallbackHandler);
            if (_logger.isDebugEnabled()) {
                _logger.debug("Provisioning groups to SP - 2nd phase: channel=" + this._channelId);
            }
            String secondPhaseSql = "SELECT dsGuid, saasGuid, saasGroup, inGroup FROM channel_group WHERE channel=? AND dirty IN (3,2)";
            ProvisionGroupCallbackHandler secondPhaseCallbackHandler = new ProvisionGroupCallbackHandler((JdbcOperations)this._jdbcTpl, callback, saasIdentityMaskedFields, true);
            this._jdbcTpl.query(secondPhaseSql, new Object[]{this._channelId}, (RowCallbackHandler)secondPhaseCallbackHandler);
            if (_logger.isDebugEnabled()) {
                _logger.debug("Provisioning groups to SP - Finished");
            }
        }
        catch (SaasDataAccessException e) {
            throw (SaasException)e.getCause();
        }
    }

    @Override
    public void clearDirtyFlag(String directoryServerGuid, boolean groupModified) {
        String sql = groupModified ? "UPDATE channel_group SET dirty=0, modified=? WHERE channel=? AND dsGuid=?" : "UPDATE channel_group SET dirty=0 WHERE channel=? AND dsGuid=?";
        if (_logger.isDebugEnabled()) {
            _logger.debug("Clearing group in JDBC store: channel=" + this._channelId + ", dsGUID=" + directoryServerGuid);
        }
        if (groupModified) {
            this._jdbcTpl.update(sql, new Object[]{JdbcGroupStore.timestampNow(), this._channelId, directoryServerGuid});
        } else {
            this._jdbcTpl.update(sql, new Object[]{this._channelId, directoryServerGuid});
        }
    }

    @Override
    public void setSaasGuid(String directoryServerGuid, String saasGuid) {
        String sql = "UPDATE channel_group SET saasGuid=?, modified=? WHERE channel=? AND dsGuid=?";
        if (_logger.isDebugEnabled()) {
            _logger.debug("Setting SaaS GUID for group in JDBC store: channel=" + this._channelId + ", dsGUID=" + directoryServerGuid + ", saasGuid=" + saasGuid);
        }
        this._jdbcTpl.update(sql, new Object[]{saasGuid, JdbcGroupStore.timestampNow(), this._channelId, directoryServerGuid});
    }

    @Override
    public boolean removeIfNotDirty(String directoryServerGuid) {
        String sql = "DELETE FROM channel_group WHERE channel=? AND dsGuid=? AND dirty=0";
        if (_logger.isDebugEnabled()) {
            _logger.debug("Deleting group in JDBC store, if clean: channel=" + this._channelId + ", dsGUID=" + directoryServerGuid);
        }
        int numberOfUpdates = this._jdbcTpl.update(sql, new Object[]{this._channelId, directoryServerGuid});
        if (_logger.isDebugEnabled()) {
            _logger.debug("Deleting group in JDBC store, if clean: deleted=" + numberOfUpdates);
        }
        return numberOfUpdates > 0;
    }

    protected static SaasGroup string2SaasGroup(String text, String guid, String dsGuid, boolean inProvisioningGroup) {
        SaasGroup saasGroup = SaasResourcePacker.unpackSaasGroup(text);
        saasGroup.setInProvisioningGroup(inProvisioningGroup);
        saasGroup.setGuid(guid);
        saasGroup.setInternalGuid(dsGuid);
        return saasGroup;
    }

    private static Timestamp timestampNow() {
        return new Timestamp(new Date().getTime());
    }

    @Override
    public int deleteAllGroups() {
        if (_logger.isDebugEnabled()) {
            _logger.debug("Deleting all groups in JDBC store: channel=" + this._channelId);
        }
        return this._jdbcTpl.update("DELETE FROM channel_group WHERE channel=?", new Object[]{this._channelId});
    }

    @Override
    public ProvisionableResourceMeta getMetaByDirectoryGuid(String directoryServerGuid) {
        try {
            return (ProvisionableResourceMeta)this._jdbcTpl.queryForObject("SELECT * FROM channel_group WHERE channel=? AND dsGuid=?", (RowMapper)new GroupMetaMapper(), new Object[]{this._channelId, directoryServerGuid});
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    @Override
    public ProvisionableResourceMeta getMetaBySaasName(String saasName) {
        try {
            return (ProvisionableResourceMeta)this._jdbcTpl.queryForObject("SELECT * FROM channel_group WHERE channel=? AND saasGroupName=?", (RowMapper)new GroupMetaMapper(), new Object[]{this._channelId, saasName});
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    @Override
    public int getDirtyGroupCount() {
        String sql = "SELECT COUNT(*) FROM channel_group WHERE channel=? AND dirty IN (1,2)";
        Object[] args = new Object[]{this._channelId};
        Integer result = (Integer)this._jdbcTpl.queryForObject(sql, args, Integer.TYPE);
        return result != null ? result : -1;
    }

    @Override
    public Set<String> getAllProvisionedGroupDsGuidsInCycle() {
        TinyHashSet provisionedGroups = new TinyHashSet();
        if (this._prevChannelIds.isEmpty()) {
            return provisionedGroups;
        }
        StringBuilder saasGuidQueryBuilder = new StringBuilder();
        saasGuidQueryBuilder.append("SELECT dsGuid FROM channel_group WHERE channel IN (");
        boolean firstChannelId = true;
        for (Integer channelId : this._prevChannelIds) {
            if (firstChannelId) {
                firstChannelId = false;
            } else {
                saasGuidQueryBuilder.append(',');
            }
            saasGuidQueryBuilder.append(channelId);
        }
        saasGuidQueryBuilder.append(") AND inGroup=1");
        RowCallbackHandler callbackHandler = arg_0 -> JdbcGroupStore.lambda$getAllProvisionedGroupDsGuidsInCycle$0((Set)provisionedGroups, arg_0);
        this._jdbcTpl.query(saasGuidQueryBuilder.toString(), callbackHandler);
        return provisionedGroups;
    }

    @Override
    public String getValuesHash(String directoryServerGuid, boolean cleanRecordsOnly) {
        try {
            if (cleanRecordsOnly) {
                String sql = "SELECT valuesHash FROM channel_group WHERE channel=? AND dsGuid=? AND dirty=0";
                return (String)this._jdbcTpl.queryForObject(sql, String.class, new Object[]{this._channelId, directoryServerGuid});
            }
            String sql = "SELECT valuesHash FROM channel_group WHERE channel=? AND dsGuid=?";
            return (String)this._jdbcTpl.queryForObject(sql, String.class, new Object[]{this._channelId, directoryServerGuid});
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    @Override
    public void updateValuesHashWithMembers(SaasGroup saasGroup) {
        String sql = "UPDATE channel_group SET valuesHash=? WHERE channel=? AND dsGuid=?";
        String valuesHash = null;
        String dsGuid = saasGroup.getInternalGuid();
        try {
            MessageDigest md5 = MessageDigest.getInstance(VALUES_HASH_ALGORITHM);
            md5.update(saasGroup.getName().getBytes("UTF-8"));
            if (this._membershipStore != null) {
                this._membershipStore.commit();
                Iterator<String> members = this._membershipStore.getMemberDsGuids(dsGuid);
                while (members.hasNext()) {
                    md5.update(members.next().getBytes("UTF-8"));
                }
            }
            byte[] digest = md5.digest();
            valuesHash = new String(Hex.encodeHex((byte[])digest));
        }
        catch (NoSuchAlgorithmException e) {
            _logger.warn((Object)e);
        }
        catch (GroupStoreException e) {
            _logger.error((Object)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("Updating group in JDBC store: channel=" + this._channelId + ", dsGUID=" + dsGuid + ", valuesHash=" + valuesHash);
        }
        this._jdbcTpl.update(sql, new Object[]{valuesHash, this._channelId, dsGuid});
    }

    @Override
    public void markGroupForSecondPhase(String directoryServerGuid) {
        String sql = "UPDATE channel_group SET dirty=3, modified=? WHERE channel=? AND dsGuid=?";
        if (_logger.isDebugEnabled()) {
            _logger.debug("Marking group in JDBC store for 2nd provision: channel=" + this._channelId + ", dsGUID=" + directoryServerGuid);
        }
        this._jdbcTpl.update(sql, new Object[]{JdbcGroupStore.timestampNow(), this._channelId, directoryServerGuid});
    }

    private static /* synthetic */ void lambda$getAllProvisionedGroupDsGuidsInCycle$0(Set provisionedGroups, ResultSet rs) throws SQLException {
        String dsGuid = rs.getString(1);
        provisionedGroups.add(dsGuid);
    }

    private static class GroupMetaMapper
    implements RowMapper<ProvisionableResourceMeta> {
        private GroupMetaMapper() {
        }

        public ProvisionableResourceMeta mapRow(ResultSet rs, int rowNum) throws SQLException {
            boolean inGroup = rs.getBoolean("inGroup");
            String saasGuid = rs.getString("saasGuid");
            String encodedGroup = rs.getString("saasGroup");
            ProvisionableResourceMeta groupMeta = new ProvisionableResourceMeta();
            groupMeta.setDirectoryServerGuid(rs.getString("dsGuid"));
            groupMeta.setSaasGuid(saasGuid);
            groupMeta.setSaasUsername(rs.getString("saasGroupName"));
            groupMeta.setValuesHash(rs.getString("valuesHash"));
            groupMeta.setInGroup(inGroup);
            groupMeta.setDirty(rs.getBoolean("dirty"));
            if (encodedGroup != null && encodedGroup.trim().length() > 0) {
                SaasGroup saasGroup = JdbcGroupStore.string2SaasGroup(encodedGroup, saasGuid, groupMeta.getDirectoryServerGuid(), inGroup);
                groupMeta.setSaasProvisionableResource(saasGroup);
            }
            groupMeta.setCreated(rs.getTimestamp("created"));
            groupMeta.setModified(rs.getTimestamp("modified"));
            return groupMeta;
        }
    }

    private class ProvisionGroupCallbackHandler
    implements RowCallbackHandler {
        private final JdbcOperations jdbcOps;
        private final boolean isSecondPhase;
        private final Set<String> identityMaskedFields;
        private final SaasProvisionableResourceCallback callback;

        public ProvisionGroupCallbackHandler(JdbcOperations jdbcOps, SaasProvisionableResourceCallback callback, Set<String> identityMaskedFields, boolean isSecondPhase) {
            this.jdbcOps = jdbcOps;
            this.callback = callback;
            this.isSecondPhase = isSecondPhase;
            this.identityMaskedFields = identityMaskedFields != null ? identityMaskedFields : Collections.emptySet();
        }

        public void processRow(ResultSet resultSet) throws SQLException {
            SaasGroup saasGroup = null;
            try {
                String dsGuid = resultSet.getString(1);
                String saasGuid = resultSet.getString(2);
                String saasGroupString = resultSet.getString(3);
                boolean inGroup = resultSet.getBoolean(4);
                boolean needsSecondPhase = false;
                saasGroup = JdbcGroupStore.string2SaasGroup(saasGroupString, saasGuid, dsGuid, inGroup);
                saasGroup.setMarkedForDelete(!inGroup);
                if (JdbcGroupStore.this._membershipStore != null) {
                    saasGroup.setMembersIterator(JdbcGroupStore.this._membershipStore.getUserMembers(dsGuid, this.identityMaskedFields));
                    if (!this.isSecondPhase) {
                        needsSecondPhase = JdbcGroupStore.this._membershipStore.hasNewSubGroupMembers(dsGuid);
                        saasGroup.setSubGroupsIterator(JdbcGroupStore.this._membershipStore.getExistingSubGroupMembers(dsGuid));
                    } else {
                        saasGroup.setSubGroupsIterator(JdbcGroupStore.this._membershipStore.getSubGroupMembers(dsGuid));
                    }
                }
                if (saasGuid == null && !JdbcGroupStore.this._prevChannelIds.isEmpty()) {
                    StringBuilder saasGuidQueryBuilder = new StringBuilder();
                    saasGuidQueryBuilder.append("SELECT saasGuid FROM channel_group WHERE channel IN (");
                    boolean firstChannelId = true;
                    for (Integer channelId : JdbcGroupStore.this._prevChannelIds) {
                        if (firstChannelId) {
                            firstChannelId = false;
                        } else {
                            saasGuidQueryBuilder.append(',');
                        }
                        saasGuidQueryBuilder.append(channelId);
                    }
                    saasGuidQueryBuilder.append(") AND dsGuid=? AND inGroup=1 AND saasGuid IS NOT NULL");
                    SaasGuidCallbackHandler saasGuidCallbackHandler = new SaasGuidCallbackHandler();
                    this.jdbcOps.query(saasGuidQueryBuilder.toString(), new Object[]{dsGuid}, (RowCallbackHandler)saasGuidCallbackHandler);
                    saasGroup.setGuid(saasGuidCallbackHandler.getSaasGuid());
                }
                GroupStoreUpdater updater = new GroupStoreUpdater(JdbcGroupStore.this, dsGuid, needsSecondPhase);
                this.callback.process(saasGroup, updater, dsGuid);
            }
            catch (SaasException e) {
                if (e.isStopSession()) {
                    throw new SaasDataAccessException(e);
                }
                _logger.error("Cannot process group: " + saasGroup.getName(), (Throwable)e);
            }
        }
    }

    private class SaasGuidCallbackHandler
    implements RowCallbackHandler {
        private String saasGuid;

        private SaasGuidCallbackHandler() {
        }

        public void processRow(ResultSet saasGuidResultSet) throws SQLException {
            this.saasGuid = saasGuidResultSet.getString(1);
        }

        public String getSaasGuid() {
            return this.saasGuid;
        }
    }
}

