/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.store.jdbc;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import org.springframework.jdbc.support.DatabaseMetaDataCallback;
import org.springframework.jdbc.support.MetaDataAccessException;

public class JdbcMetadataCallback
implements DatabaseMetaDataCallback {
    private static final String ORACLE_JDBC_URL_PREFIX = "jdbc:oracle:";

    public Object processMetaData(DatabaseMetaData dbmd) throws SQLException, MetaDataAccessException {
        String tableName;
        String columnName;
        String schemaName = null;
        if (dbmd.storesUpperCaseIdentifiers()) {
            columnName = "subGroupDsGuid".toUpperCase(Locale.ENGLISH);
            tableName = "group_membership".toUpperCase(Locale.ENGLISH);
        } else if (dbmd.storesLowerCaseIdentifiers()) {
            columnName = "subGroupDsGuid".toLowerCase(Locale.ENGLISH);
            tableName = "group_membership".toLowerCase(Locale.ENGLISH);
        } else {
            columnName = "subGroupDsGuid";
            tableName = "group_membership";
        }
        String lowerUrl = dbmd.getURL();
        if (lowerUrl != null && lowerUrl.startsWith(ORACLE_JDBC_URL_PREFIX)) {
            String dbUserName;
            schemaName = dbUserName = dbmd.getUserName();
        }
        ResultSet rs = dbmd.getColumns(null, schemaName, tableName, columnName);
        return rs.next();
    }
}

