/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.store.jdbc;

import com.pingidentity.provisioner.domain.mgmt.ProvisionerManager;
import com.pingidentity.provisioner.identity.SaasIdentity;
import com.pingidentity.provisioner.mapping.IdentityMapper;
import com.pingidentity.provisioner.saas.SaasException;
import com.pingidentity.provisioner.store.DuplicateKeyException;
import com.pingidentity.provisioner.store.InvalidProvisioningDataException;
import com.pingidentity.provisioner.store.ProvisionableResourceMeta;
import com.pingidentity.provisioner.store.SaasProvisionableResourceCallback;
import com.pingidentity.provisioner.store.UserStore;
import com.pingidentity.provisioner.store.UserStoreUpdater;
import com.pingidentity.provisioner.store.jdbc.SaasDataAccessException;
import com.pingidentity.provisioner.store.jdbc.SaasResourcePacker;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;

public class JdbcUserStore
implements UserStore {
    private static Logger _logger = LogManager.getLogger(JdbcUserStore.class);
    private int _channelId;
    private JdbcTemplate _jdbcTpl;

    public JdbcUserStore(DataSource dataSource, int channelId) {
        this._channelId = channelId;
        this._jdbcTpl = new JdbcTemplate(dataSource);
    }

    @Override
    public void loadDirectoryServerGuids(final Set<String> inside, final Set<String> outside) {
        String sql = "SELECT dsGuid, inGroup FROM channel_user WHERE channel=?";
        RowCallbackHandler rowCallbackHandler = new RowCallbackHandler(){

            public void processRow(ResultSet resultSet) throws SQLException {
                String dsGuid = resultSet.getString(1);
                if (resultSet.getBoolean(2)) {
                    inside.add(dsGuid);
                } else {
                    outside.add(dsGuid);
                }
            }
        };
        this._jdbcTpl.query(sql, new Object[]{this._channelId}, rowCallbackHandler);
    }

    @Override
    public void create(String directoryServerGuid, SaasIdentity saasIdentity, boolean inProvisioningGroup) throws InvalidProvisioningDataException {
        Timestamp now = JdbcUserStore.timestampNow();
        String sql = "INSERT INTO channel_user (channel, dsGuid, saasUsername, valuesHash, inGroup, dirty, saasIdentity, created, modified) VALUES (?,?,?,?,?,1,?,?,?)";
        String saasUsername = saasIdentity.getName();
        String hash = saasIdentity.calculateValuesHash();
        String saasIdentityStr = SaasResourcePacker.pack(saasIdentity);
        int inGroup = inProvisioningGroup ? 1 : 0;
        this.isNameUnique(directoryServerGuid, saasUsername);
        if (_logger.isDebugEnabled()) {
            String maskedIdentityStr = SaasResourcePacker.pack(saasIdentity, true);
            maskedIdentityStr = JdbcUserStore.maskSaasIdentityString(maskedIdentityStr);
            _logger.debug("Inserting user to JDBC store: channel=" + this._channelId + ", dsGUID=" + directoryServerGuid + ", saasUsername=" + (saasIdentity.isNameMasked() ? "*****" : saasUsername) + ", hash=" + hash + ", inGroup=" + inGroup + ", saasIdentity=" + maskedIdentityStr);
        }
        try {
            this._jdbcTpl.update(sql, new Object[]{this._channelId, directoryServerGuid, saasUsername, hash, inGroup, saasIdentityStr, now, now});
        }
        catch (DataIntegrityViolationException e) {
            _logger.debug((Object)e.getStackTrace());
            throw new InvalidProvisioningDataException("User create skipped for GUID: " + directoryServerGuid + ". Unable to update database due to data violation. " + e.getMessage(), e);
        }
    }

    @Override
    public boolean update(String directoryServerGuid, SaasIdentity saasIdentity) throws InvalidProvisioningDataException {
        int numberOfUpdates;
        String sql = "UPDATE channel_user SET saasUsername=?, valuesHash=?, dirty=1, saasIdentity=?, modified=? WHERE channel=? AND dsGuid=?";
        String saasUsername = saasIdentity.getName();
        String hash = saasIdentity.calculateValuesHash();
        String saasIdentityStr = SaasResourcePacker.pack(saasIdentity);
        this.isNameUnique(directoryServerGuid, saasUsername);
        if (_logger.isDebugEnabled()) {
            String maskedIdentityStr = SaasResourcePacker.pack(saasIdentity, true);
            maskedIdentityStr = JdbcUserStore.maskSaasIdentityString(maskedIdentityStr);
            _logger.debug("Updating user in JDBC store: channel=" + this._channelId + ", saasUsername=" + (saasIdentity.isNameMasked() ? "*****" : saasUsername) + ", hash=" + hash + ", saasIdentity=" + maskedIdentityStr + ", dsGUID=" + directoryServerGuid);
        }
        try {
            numberOfUpdates = this._jdbcTpl.update(sql, new Object[]{saasUsername, hash, saasIdentityStr, JdbcUserStore.timestampNow(), this._channelId, directoryServerGuid});
        }
        catch (DataIntegrityViolationException e) {
            _logger.debug((Object)e.getStackTrace());
            throw new InvalidProvisioningDataException("User update record, skipped for GUID: " + directoryServerGuid + ". Unable to update database due to data violation. " + e.getMessage(), e);
        }
        return numberOfUpdates > 0;
    }

    @Override
    public boolean update(String directoryServerGuid, SaasIdentity saasIdentity, boolean inProvisioningGroup) throws InvalidProvisioningDataException {
        int numberOfUpdates;
        String sql = "UPDATE channel_user SET saasUsername=?, valuesHash=?, inGroup=?, dirty=1, saasIdentity=?, modified=? WHERE channel=? AND dsGuid=?";
        String saasUsername = saasIdentity.getName();
        String hash = saasIdentity.calculateValuesHash();
        String saasIdentityStr = SaasResourcePacker.pack(saasIdentity);
        int inGroup = inProvisioningGroup ? 1 : 0;
        this.isNameUnique(directoryServerGuid, saasUsername);
        if (_logger.isDebugEnabled()) {
            String maskedIdentityStr = SaasResourcePacker.pack(saasIdentity, true);
            maskedIdentityStr = JdbcUserStore.maskSaasIdentityString(maskedIdentityStr);
            _logger.debug("Updating user in JDBC store: channel=" + this._channelId + ", saasUsername=" + (saasIdentity.isNameMasked() ? "*****" : saasUsername) + ", hash=" + hash + ", inGroup=" + inGroup + ", saasIdentity=" + maskedIdentityStr + ", dsGUID=" + directoryServerGuid);
        }
        try {
            numberOfUpdates = this._jdbcTpl.update(sql, new Object[]{saasUsername, hash, inGroup, saasIdentityStr, JdbcUserStore.timestampNow(), this._channelId, directoryServerGuid});
        }
        catch (DataIntegrityViolationException e) {
            _logger.debug((Object)e.getStackTrace());
            throw new InvalidProvisioningDataException("User create skipped for GUID: " + directoryServerGuid + ". Unable to update database due to data violation. " + e.getMessage(), e);
        }
        return numberOfUpdates > 0;
    }

    @Override
    public boolean updateChannel(String directoryServerGuid, SaasIdentity saasIdentity, boolean inProvisioningGroup, int oldChannel) throws InvalidProvisioningDataException {
        int numberOfUpdates;
        String sql = "UPDATE channel_user SET channel=?, saasUsername=?, valuesHash=?, inGroup=?, dirty=1, saasIdentity=?, modified=? WHERE channel=? AND dsGuid=?";
        String saasUsername = saasIdentity.getName();
        String hash = saasIdentity.calculateValuesHash();
        String saasIdentityStr = SaasResourcePacker.pack(saasIdentity);
        int inGroup = inProvisioningGroup ? 1 : 0;
        this.isNameUnique(directoryServerGuid, saasUsername);
        if (_logger.isDebugEnabled()) {
            String maskedIdentityStr = SaasResourcePacker.pack(saasIdentity, true);
            maskedIdentityStr = JdbcUserStore.maskSaasIdentityString(maskedIdentityStr);
            _logger.debug("Updating user in JDBC store: channel=" + this._channelId + ", saasUsername=" + (saasIdentity.isNameMasked() ? "*****" : saasUsername) + ", hash=" + hash + ", inGroup=" + inGroup + ", saasIdentity=" + maskedIdentityStr + ", dsGUID=" + directoryServerGuid);
        }
        try {
            numberOfUpdates = this._jdbcTpl.update(sql, new Object[]{this._channelId, saasUsername, hash, inGroup, saasIdentityStr, JdbcUserStore.timestampNow(), oldChannel, directoryServerGuid});
        }
        catch (DataIntegrityViolationException e) {
            _logger.debug((Object)e.getStackTrace());
            throw new InvalidProvisioningDataException("User create skipped for GUID: " + directoryServerGuid + ". Unable to update database due to data violation. " + e.getMessage(), e);
        }
        return numberOfUpdates > 0;
    }

    @Override
    public boolean removeIfNotDirty(String directoryServerGuid) {
        return this.remove(directoryServerGuid, true);
    }

    @Override
    public boolean remove(String directoryServerGuid) {
        return this.remove(directoryServerGuid, false);
    }

    private boolean remove(String directoryServerGuid, boolean cleanUsersOnly) {
        StringBuilder sql = new StringBuilder("DELETE FROM channel_user WHERE channel=? AND dsGuid=?");
        if (cleanUsersOnly) {
            sql.append(" AND dirty=0");
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("Deleting user in JDBC store" + (cleanUsersOnly ? ", if clean" : "") + ": channel=" + this._channelId + ", dsGUID=" + directoryServerGuid);
        }
        int numberOfUpdates = this._jdbcTpl.update(sql.toString(), new Object[]{this._channelId, directoryServerGuid});
        if (_logger.isDebugEnabled()) {
            _logger.debug("Deleting user in JDBC store" + (cleanUsersOnly ? ", if clean" : "") + ": deleted=" + numberOfUpdates);
        }
        return numberOfUpdates > 0;
    }

    @Override
    public String getValuesHash(String directoryServerGuid) {
        try {
            String sql = "SELECT valuesHash FROM channel_user WHERE channel=? AND dsGuid=?";
            String result = (String)this._jdbcTpl.queryForObject(sql, String.class, new Object[]{this._channelId, directoryServerGuid});
            if (result == null) {
                result = "";
            }
            return result;
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    @Override
    public String getSaasUsername(String directoryServerGuid) {
        try {
            String sql = "SELECT saasUsername FROM channel_user WHERE channel=? AND dsGuid=?";
            return (String)this._jdbcTpl.queryForObject(sql, String.class, new Object[]{this._channelId, directoryServerGuid});
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    protected void isNameUnique(String directoryServerGuid, String saasUsername) throws DuplicateKeyException {
        String sql = "SELECT COUNT(saasUsername) FROM channel_user WHERE channel=? AND saasUsername=? AND dsGuid<>?";
        Object[] params = new Object[]{this._channelId, saasUsername, directoryServerGuid};
        Integer matches = (Integer)this._jdbcTpl.queryForObject(sql, params, Integer.TYPE);
        if (matches != null && matches > 0) {
            throw new DuplicateKeyException("Non Unique Name", saasUsername);
        }
    }

    @Override
    public void processDirty(SaasProvisionableResourceCallback callback, IdentityMapper identityMapper) throws SaasException {
        this.processDirty(callback, identityMapper, null);
    }

    @Override
    public void processDirty(final SaasProvisionableResourceCallback callback, final IdentityMapper identityMapper, final Set<String> usersToSkip) throws SaasException {
        try {
            String sql = "SELECT dsGuid, saasIdentity, saasGuid, inGroup FROM channel_user WHERE channel=? AND dirty=1";
            RowCallbackHandler rowCallbackHandler = new RowCallbackHandler(){

                public void processRow(ResultSet resultSet) throws SQLException {
                    SaasIdentity saasIdentity = null;
                    try {
                        String dsGuid = resultSet.getString(1);
                        String encodedText = resultSet.getString(2);
                        String saasGuid = resultSet.getString(3);
                        boolean inGroup = resultSet.getBoolean(4);
                        String usernameToMask = null;
                        if (identityMapper != null) {
                            saasIdentity = JdbcUserStore.string2SaasIdentity(encodedText, saasGuid, dsGuid, inGroup, identityMapper.getMaskedFields());
                            saasIdentity.setCreateOnlyFields(identityMapper.getCreateOnlyFields());
                        } else {
                            saasIdentity = JdbcUserStore.string2SaasIdentity(encodedText, saasGuid, dsGuid, inGroup);
                        }
                        if (saasIdentity.isNameMasked()) {
                            usernameToMask = saasIdentity.getName();
                        }
                        if (usersToSkip == null || !usersToSkip.contains(dsGuid)) {
                            UserStoreUpdater updater = new UserStoreUpdater(JdbcUserStore.this, dsGuid, usernameToMask);
                            callback.process(saasIdentity, updater, dsGuid);
                        }
                    }
                    catch (SaasException e) {
                        if (e.isStopSession()) {
                            throw new SaasDataAccessException(e);
                        }
                        if (saasIdentity != null) {
                            _logger.error("Cannot process user: " + saasIdentity.getName(), (Throwable)e);
                        }
                        _logger.error("Cannot process user!", (Throwable)e);
                    }
                }
            };
            this._jdbcTpl.query(sql, new Object[]{this._channelId}, rowCallbackHandler);
        }
        catch (SaasDataAccessException e) {
            throw (SaasException)e.getCause();
        }
    }

    @Override
    public void clearDirtyFlag(String directoryServerGuid) {
        String sql = "UPDATE channel_user SET dirty=0, modified=? WHERE channel=? AND dsGuid=?";
        if (_logger.isDebugEnabled()) {
            _logger.debug("Clearing user in JDBC store: channel=" + this._channelId + ", dsGUID=" + directoryServerGuid);
        }
        this._jdbcTpl.update(sql, new Object[]{JdbcUserStore.timestampNow(), this._channelId, directoryServerGuid});
    }

    @Override
    public void setSaasGuid(String directoryServerGuid, String saasGuid, boolean maskGuid) {
        String sql = "UPDATE channel_user SET saasGuid=?, modified=? WHERE channel=? AND dsGuid=?";
        if (_logger.isDebugEnabled()) {
            _logger.debug("Setting SaaS GUID for user in JDBC store: channel=" + this._channelId + ", dsGUID=" + directoryServerGuid + ", saasGuid=" + (maskGuid ? "*****" : saasGuid));
        }
        this._jdbcTpl.update(sql, new Object[]{saasGuid, JdbcUserStore.timestampNow(), this._channelId, directoryServerGuid});
    }

    @Override
    public void setSaasIdentity(String directoryServerGuid, SaasIdentity saasIdentity, Set<String> fields) {
        String saasIdentityStr = SaasResourcePacker.pack(saasIdentity, false, fields);
        String sql = "UPDATE channel_user SET saasIdentity=?, modified=? WHERE channel=? AND dsGuid=?";
        if (_logger.isDebugEnabled()) {
            String maskedIdentityStr = SaasResourcePacker.pack(saasIdentity, true, fields);
            maskedIdentityStr = JdbcUserStore.maskSaasIdentityString(maskedIdentityStr);
            _logger.debug("Setting SaaS Identity for user in JDBC store: channel=" + this._channelId + ", dsGUID=" + directoryServerGuid + ", saasIdentity=" + maskedIdentityStr);
        }
        this._jdbcTpl.update(sql, new Object[]{saasIdentityStr, JdbcUserStore.timestampNow(), this._channelId, directoryServerGuid});
    }

    @Override
    public void resetValuesHash() {
        String sql = "UPDATE channel_user SET valuesHash = 'to-be-updated' WHERE channel=?";
        if (_logger.isDebugEnabled()) {
            _logger.debug("Reseting values hash for all users in JDBC store: channel=" + this._channelId);
        }
        this._jdbcTpl.update(sql, new Object[]{this._channelId});
    }

    @Override
    public int getUserCount() {
        String sql = "SELECT COUNT(*) FROM channel_user WHERE channel=?";
        Object[] args = new Object[]{this._channelId};
        Integer result = (Integer)this._jdbcTpl.queryForObject(sql, args, Integer.TYPE);
        return result != null ? result : -1;
    }

    @Override
    public int getDirtyUserCount() {
        String sql = "SELECT COUNT(*) FROM channel_user WHERE channel=? AND dirty=1";
        Object[] args = new Object[]{this._channelId};
        Integer result = (Integer)this._jdbcTpl.queryForObject(sql, args, Integer.TYPE);
        return result != null ? result : -1;
    }

    @Override
    public Set<String> getAllUserGuids() {
        HashSet<String> dirtyUserGuids = new HashSet<String>();
        List results = this._jdbcTpl.queryForList("SELECT dsGuid FROM channel_user WHERE channel=?", new Object[]{this._channelId});
        for (Map row : results) {
            dirtyUserGuids.add((String)row.get("dsGuid"));
        }
        return dirtyUserGuids;
    }

    @Override
    public int deleteAllUsers() {
        if (_logger.isDebugEnabled()) {
            _logger.debug("Deleting all users in JDBC store: channel=" + this._channelId);
        }
        return this._jdbcTpl.update("DELETE FROM channel_user WHERE channel=?", new Object[]{this._channelId});
    }

    @Override
    public ProvisionableResourceMeta getUserMetaBySaasUsername(String saasUsername) {
        try {
            return (ProvisionableResourceMeta)this._jdbcTpl.queryForObject("SELECT * FROM channel_user WHERE channel=? AND saasUsername=?", (RowMapper)new UserMetaMapper(), new Object[]{this._channelId, saasUsername});
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    @Override
    public ProvisionableResourceMeta getUserMetaByDirectoryGuid(String directoryServerGuid) {
        try {
            return (ProvisionableResourceMeta)this._jdbcTpl.queryForObject("SELECT * FROM channel_user WHERE channel=? AND dsGuid=?", (RowMapper)new UserMetaMapper(), new Object[]{this._channelId, directoryServerGuid});
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    protected static SaasIdentity string2SaasIdentity(String text, String saasGuid, String dsGuid, boolean inProvisioningGroup) throws SaasException {
        return JdbcUserStore.string2SaasIdentity(text, saasGuid, dsGuid, inProvisioningGroup, null);
    }

    protected static SaasIdentity string2SaasIdentity(String text, String saasGuid, String dsGuid, boolean inProvisioningGroup, Set<String> identityMaskedFields) throws SaasException {
        SaasIdentity saasIdentity = SaasResourcePacker.unpackSaasIdentity(text, identityMaskedFields);
        saasIdentity.setSaasGuid(saasGuid);
        saasIdentity.setInternalGuid(dsGuid);
        saasIdentity.setInProvisioningGroup(inProvisioningGroup);
        return saasIdentity;
    }

    private static Timestamp timestampNow() {
        return new Timestamp(new Date().getTime());
    }

    public static String maskSaasIdentityString(String saasIdentityStr) {
        if (ProvisionerManager.getProvisionerGlobalSettings().isEncryptSaasIdentities()) {
            return saasIdentityStr;
        }
        String passwordRegex = "([pP][aA][sS][sS][wW][oO][rR][dD])=([^&]*)";
        Pattern p = Pattern.compile("([pP][aA][sS][sS][wW][oO][rR][dD])=([^&]*)");
        Matcher m = p.matcher(saasIdentityStr);
        ArrayList<Integer[]> matchedIndices = new ArrayList<Integer[]>();
        while (m.find()) {
            int passwordStart = m.start(2);
            int passwordEnd = saasIdentityStr.indexOf(38, passwordStart);
            if (passwordEnd == -1) {
                passwordEnd = saasIdentityStr.length();
            }
            matchedIndices.add(new Integer[]{passwordStart, passwordEnd});
        }
        StringBuilder maskedString = new StringBuilder(saasIdentityStr.length());
        int previousEndIndex = 0;
        for (Integer[] indexPair : matchedIndices) {
            maskedString.append(saasIdentityStr, previousEndIndex, (int)indexPair[0]);
            maskedString.append("*****");
            previousEndIndex = indexPair[1];
        }
        maskedString.append(saasIdentityStr.substring(previousEndIndex));
        return maskedString.toString();
    }

    private static class UserMetaMapper
    implements RowMapper<ProvisionableResourceMeta> {
        private UserMetaMapper() {
        }

        public ProvisionableResourceMeta mapRow(ResultSet rs, int rowNum) throws SQLException {
            boolean inGroup = rs.getBoolean("inGroup");
            String saasGuid = rs.getString("saasGuid");
            String dsGuid = rs.getString("dsGuid");
            String encodedIdentity = rs.getString("saasIdentity");
            ProvisionableResourceMeta userMeta = new ProvisionableResourceMeta();
            userMeta.setDirectoryServerGuid(dsGuid);
            userMeta.setSaasGuid(saasGuid);
            userMeta.setSaasUsername(rs.getString("saasUsername"));
            userMeta.setValuesHash(rs.getString("valuesHash"));
            userMeta.setInGroup(inGroup);
            userMeta.setDirty(rs.getBoolean("dirty"));
            try {
                if (encodedIdentity != null && encodedIdentity.trim().length() > 0) {
                    userMeta.setSaasProvisionableResource(JdbcUserStore.string2SaasIdentity(encodedIdentity, saasGuid, dsGuid, inGroup));
                }
            }
            catch (SaasException e) {
                _logger.warn("Unable to retrieve provisionable resource, setting metadata's resource to null", (Throwable)e);
            }
            userMeta.setCreated(rs.getTimestamp("created"));
            userMeta.setModified(rs.getTimestamp("modified"));
            return userMeta;
        }
    }
}

