/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.store.jdbc;

import com.pingidentity.common.util.ObfuscationException;
import com.pingidentity.common.util.Obfuscator;
import com.pingidentity.provisioner.domain.mgmt.ProvisionerManager;
import com.pingidentity.provisioner.identity.SaasGroup;
import com.pingidentity.provisioner.identity.SaasIdentity;
import com.pingidentity.provisioner.resources.SaasProvisionableResource;
import com.pingidentity.provisioner.saas.SaasException;
import com.pingidentity.provisioner.store.StoreError;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SaasResourcePacker {
    public static String pack(SaasIdentity identity) {
        return SaasResourcePacker.pack(identity, false);
    }

    public static String pack(SaasIdentity identity, boolean mask) {
        return SaasResourcePacker.pack(identity, mask, identity.getNames());
    }

    public static String pack(SaasIdentity identity, boolean mask, Set<String> attributesToPack) {
        StringBuilder text = new StringBuilder();
        SaasResourcePacker.encodeToBuffer(text, identity.getSaasUsernameFieldCode());
        text.append('&');
        text.append(Boolean.toString(identity.isAccountEnabled()));
        text.append('&');
        boolean encrypt = ProvisionerManager.getProvisionerGlobalSettings().isEncryptSaasIdentities();
        SaasResourcePacker.pack(text, identity, mask && !encrypt, attributesToPack);
        text.deleteCharAt(text.length() - 1);
        String val = text.toString();
        if (encrypt) {
            val = Obfuscator.obfuscate((String)val);
        }
        return val;
    }

    public static String pack(SaasGroup group) {
        StringBuilder text = new StringBuilder();
        SaasResourcePacker.encodeToBuffer(text, group.getName());
        text.append('&');
        SaasResourcePacker.pack(text, group, false);
        text.deleteCharAt(text.length() - 1);
        return text.toString();
    }

    private static void pack(StringBuilder buffer, SaasProvisionableResource resource, boolean mask) {
        SaasResourcePacker.pack(buffer, resource, mask, resource.getNames());
    }

    private static void pack(StringBuilder buffer, SaasProvisionableResource resource, boolean mask, Set<String> attributesToPack) {
        for (String name : attributesToPack) {
            if (resource.isMapValue(name)) {
                SaasResourcePacker.pack(buffer, name, resource.getMap(name));
                continue;
            }
            SaasResourcePacker.pack(buffer, name, resource.getValues(name), resource.isFieldMasked(name) && mask);
        }
    }

    private static void pack(StringBuilder buffer, String name, Map<String, List<String>> map) {
        boolean empty = true;
        SaasResourcePacker.encodeToBuffer(buffer, name);
        buffer.append("={");
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            empty = false;
            SaasResourcePacker.pack(buffer, entry.getKey(), entry.getValue(), false);
        }
        if (!empty) {
            buffer.deleteCharAt(buffer.length() - 1);
        }
        buffer.append("}&");
    }

    private static void pack(StringBuilder buffer, String name, List<String> values, boolean mask) {
        for (String value : values) {
            if (value == null) continue;
            SaasResourcePacker.encodeToBuffer(buffer, name);
            buffer.append('=');
            if (mask) {
                buffer.append("*****");
            } else {
                SaasResourcePacker.encodeToBuffer(buffer, value);
            }
            buffer.append('&');
        }
    }

    private static void encodeToBuffer(StringBuilder buffer, String value) {
        try {
            buffer.append(URLEncoder.encode(value, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static SaasIdentity unpackSaasIdentity(String text, Set<String> identityMaskedFields) throws SaasException {
        int valueStart = 0;
        int ampersandIndex = text.indexOf(38);
        if (ampersandIndex == -1) {
            try {
                text = Obfuscator.deobfuscate((String)text);
            }
            catch (ObfuscationException e) {
                throw new SaasException("Unable to decrypt Saas Identity properly.", e);
            }
            ampersandIndex = text.indexOf(38);
        }
        SaasIdentity saasIdentity = new SaasIdentity(SaasResourcePacker.decode(text.substring(valueStart, ampersandIndex)));
        valueStart = ampersandIndex + 1;
        if ((ampersandIndex = text.indexOf(38, valueStart)) == -1) {
            saasIdentity.setAccountEnabled(Boolean.parseBoolean(text.substring(valueStart)));
        } else {
            saasIdentity.setAccountEnabled(Boolean.parseBoolean(text.substring(valueStart, ampersandIndex)));
            SaasResourcePacker.unpackProperties(saasIdentity, ampersandIndex + 1, text);
        }
        if (identityMaskedFields != null) {
            saasIdentity.setMaskedFields(identityMaskedFields);
        }
        return saasIdentity;
    }

    public static SaasGroup unpackSaasGroup(String text) {
        SaasGroup saasGroup;
        int ampersandIndex = text.indexOf(38);
        if (ampersandIndex == -1) {
            saasGroup = new SaasGroup(SaasResourcePacker.decode(text));
        } else {
            saasGroup = new SaasGroup(SaasResourcePacker.decode(text.substring(0, ampersandIndex)));
            SaasResourcePacker.unpackProperties(saasGroup, ampersandIndex + 1, text);
        }
        return saasGroup;
    }

    private static void unpackProperties(SaasProvisionableResource resource, int offset, String text) {
        int ampersandIndex = offset - 1;
        if (ampersandIndex < 0) {
            ampersandIndex = 0;
        }
        while (ampersandIndex >= 0) {
            int propertyStart = ampersandIndex + 1;
            int equalsIndex = text.indexOf(61, propertyStart);
            if (equalsIndex == -1) {
                throw new StoreError("Invalid name value pair: " + text.substring(propertyStart));
            }
            String name = SaasResourcePacker.decode(text.substring(propertyStart, equalsIndex));
            if (equalsIndex + 1 == text.length()) {
                resource.addValues(name, "", new String[0]);
                break;
            }
            int valueIndex = equalsIndex + 1;
            if (text.charAt(valueIndex) == '{') {
                int mapEndIndex = text.indexOf(125, valueIndex + 1);
                if (mapEndIndex == -1) {
                    throw new StoreError("Invalid map value: " + text.substring(valueIndex));
                }
                Map<String, List<String>> map = SaasResourcePacker.unpackMap(text.substring(valueIndex + 1, mapEndIndex));
                resource.putMap(name, map);
                if (text.length() > mapEndIndex + 1) {
                    if (text.charAt(mapEndIndex + 1) != '&') {
                        throw new StoreError("Invalid name value pair: " + text.substring(mapEndIndex + 1));
                    }
                    ampersandIndex = mapEndIndex + 1;
                    continue;
                }
                ampersandIndex = -1;
                continue;
            }
            ampersandIndex = text.indexOf(38, valueIndex);
            String value = ampersandIndex == -1 ? SaasResourcePacker.decode(text.substring(valueIndex)) : SaasResourcePacker.decode(text.substring(valueIndex, ampersandIndex));
            resource.addValues(name, value, new String[0]);
        }
    }

    private static Map<String, List<String>> unpackMap(String text) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        if (text.isEmpty()) {
            return map;
        }
        int startIndex = 0;
        int ampersandIndex = 0;
        while (ampersandIndex >= 0) {
            int equalsIndex = text.indexOf(61, startIndex);
            if (equalsIndex == -1 || equalsIndex + 1 >= text.length() || startIndex == equalsIndex) {
                throw new StoreError("Invalid name value pair: " + text);
            }
            String name = SaasResourcePacker.decode(text.substring(startIndex, equalsIndex));
            int valueIndex = equalsIndex + 1;
            ampersandIndex = text.indexOf(38, valueIndex);
            String value = ampersandIndex == -1 ? text.substring(valueIndex) : text.substring(valueIndex, ampersandIndex);
            value = SaasResourcePacker.decode(value);
            ArrayList<String> values = (ArrayList<String>)map.get(name);
            if (values == null) {
                values = new ArrayList<String>();
                map.put(name, values);
            }
            values.add(value);
            startIndex = ampersandIndex + 1;
        }
        return map;
    }

    private static String decode(String encodedValue) {
        try {
            return URLDecoder.decode(encodedValue, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

