/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.util;

import com.pingidentity.provisioner.ProvisioningException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.naming.NamingException;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.sourceid.saml20.domain.mgmt.DataSourceManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.springframework.jndi.JndiTemplate;

@SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
public class DataSourceInitializer {
    private static final Logger _logger = LogManager.getLogger(DataSourceInitializer.class);
    private static final long JNDI_WAIT_MILLIS = 500L;
    private static final long JNDI_MAX_WAIT_MILLIS = 60000L;
    private String _dsName;

    public void setDsName(String dsName) {
        this._dsName = dsName;
    }

    public void init() throws NamingException, ProvisioningException, InterruptedException {
        if (StringUtils.isEmpty((String)this._dsName)) {
            return;
        }
        DataSourceManager dsMgr = MgmtFactory.getDataSourceManager();
        dsMgr.getJdbcDataSources();
        JndiTemplate jndiTemplate = new JndiTemplate();
        Object ds = jndiTemplate.lookup(this._dsName);
        long startTime = System.currentTimeMillis();
        if (ds == null) {
            _logger.info("Waiting for JNDI to initialize...");
        }
        while (ds == null) {
            if (System.currentTimeMillis() - startTime > 60000L) {
                throw new ProvisioningException("Data source did not become available: " + this._dsName);
            }
            Thread.sleep(500L);
            ds = jndiTemplate.lookup(this._dsName);
        }
    }
}

