/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.xml.util;

import com.pingidentity.pingcommons.crypto.HashAlgorithm;
import com.pingidentity.pingcommons.crypto.HashUtil;
import com.pingidentity.provisioner.domain.Channel;
import com.pingidentity.provisioner.domain.IdentityMappingField;
import com.pingidentity.provisioner.domain.source.ChannelSource;
import com.pingidentity.provisioner.mapping.FieldConfig;
import com.pingidentity.provisioner.mapping.FieldInfo;
import com.pingidentity.provisioner.saas.SaasException;
import com.pingidentity.provisioner.xml.util.FieldConfigUtil;
import com.pingidentity.provisioner.xml.util.FieldInfoUtil;
import com.pingidentity.provisioner.xml.util.LdapSourceUtil;
import com.pingidentity.x2008.x06.saasProvisioner.ChannelType;
import com.pingidentity.x2008.x06.saasProvisioner.FieldConfigType;
import com.pingidentity.x2008.x06.saasProvisioner.FieldInfoType;
import com.pingidentity.x2008.x06.saasProvisioner.IdentityMappingFieldType;
import com.pingidentity.x2008.x06.saasProvisioner.SourceType;
import java.util.ArrayList;
import java.util.List;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;

public abstract class ChannelUtil {
    private static ConfigStore configStore = ConfigStoreFarm.getConfig(ChannelUtil.class);
    private static final String NEXT_CHANNEL_ID = "NextChannelId";

    public static Channel constructChannel(ChannelType channelType) throws SaasException {
        Channel channel = new Channel();
        channel.setId(Integer.parseInt(channelType.getId()));
        channel.setName(channelType.getName());
        channel.setMaxThreads(channelType.getMaxThreads());
        channel.setTimeout(channelType.getTimeout());
        channel.setDeleteDeprovisionedUsers(channelType.getDeleteDeprovisionedUsers());
        channel.setEnableAttributeSync(channelType.getEnableAttributeSync());
        channel.setActive(channelType.getActive());
        SourceType srcType = channelType.getSource();
        ChannelSource source = LdapSourceUtil.constructChannelSource(srcType);
        channel.setSource(source);
        channel.setSaasUsernameFieldCode(channelType.getSaasUsernameFieldCode());
        ArrayList<IdentityMappingField> identityMapping = new ArrayList<IdentityMappingField>();
        for (IdentityMappingFieldType identityMappingFieldType : channelType.getIdentityMappingFieldArray()) {
            IdentityMappingField mappingFld = ChannelUtil.getIdentityMappingFieldFromFieldType(identityMappingFieldType);
            identityMapping.add(mappingFld);
        }
        channel.setidentityMapping(identityMapping);
        return channel;
    }

    private static IdentityMappingField getIdentityMappingFieldFromFieldType(IdentityMappingFieldType identityMappingFieldType) {
        String name = identityMappingFieldType.getFieldName();
        IdentityMappingField mappingFld = new IdentityMappingField(name);
        FieldInfoType fieldInfoType = identityMappingFieldType.getFieldInfo();
        FieldInfo fieldInfo = FieldInfoUtil.contructFieldInfo(fieldInfoType);
        mappingFld.setFieldInfo(fieldInfo);
        FieldConfigType fieldConfigType = identityMappingFieldType.getFieldConfig();
        FieldConfig fieldConfig = FieldConfigUtil.contructFieldConfig(fieldConfigType);
        mappingFld.setFieldConfig(fieldConfig);
        return mappingFld;
    }

    private static synchronized int getNextChannelNumber() {
        int nextId = configStore.getIntValue(NEXT_CHANNEL_ID, 1);
        configStore.setIntValue(NEXT_CHANNEL_ID, nextId + 1);
        return nextId;
    }

    public static synchronized void adjustNextChannelNumber(int topChannelIdUsed) {
        int nextId = configStore.getIntValue(NEXT_CHANNEL_ID, 1);
        if (nextId <= topChannelIdUsed) {
            nextId = topChannelIdUsed;
            configStore.setIntValue(NEXT_CHANNEL_ID, nextId + 1);
        }
    }

    public static void saveToBeanDoc(ChannelType channelType, Channel channel) {
        if (channel.getId() == -1 || channel.getId() < 0) {
            channel.setId(ChannelUtil.getNextChannelNumber());
        }
        channelType.setId(Integer.toString(channel.getId()));
        channelType.setName(channel.getName());
        channelType.setMaxThreads(channel.getMaxThreads());
        channelType.setTimeout(channel.getTimeout());
        channelType.setActive(channel.isActive());
        ChannelSource src = channel.getSource();
        SourceType srcType = channelType.addNewSource();
        LdapSourceUtil.saveToBeanDoc(srcType, src);
        channelType.setSaasUsernameFieldCode(channel.getSaasUsernameFieldCode());
        for (IdentityMappingField mappingFld : channel.getIdentityMapping()) {
            IdentityMappingFieldType identityMappingFieldType = channelType.addNewIdentityMappingField();
            ChannelUtil.mapIdentityMappingFieldDomainToType(mappingFld, identityMappingFieldType);
        }
    }

    public static String getIdentityMappingHash(List<IdentityMappingField> fields) {
        if (fields == null) {
            return "";
        }
        StringBuilder concat = new StringBuilder();
        for (IdentityMappingField field : fields) {
            IdentityMappingFieldType fieldType = IdentityMappingFieldType.Factory.newInstance();
            ChannelUtil.mapIdentityMappingFieldDomainToType(field, fieldType);
            concat.append(fieldType.xmlText());
        }
        return HashUtil.hashToHexString((String)concat.toString(), (HashAlgorithm)HashAlgorithm.SHA256).substring(0, 32);
    }

    private static void mapIdentityMappingFieldDomainToType(IdentityMappingField mappingFld, IdentityMappingFieldType identityMappingFieldType) {
        FieldConfig fieldConfig;
        identityMappingFieldType.setFieldName(mappingFld.getFieldName());
        FieldInfo fieldInfo = mappingFld.getFieldInfo();
        if (fieldInfo != null) {
            FieldInfoType fieldInfoType = identityMappingFieldType.addNewFieldInfo();
            FieldInfoUtil.saveToBeanDoc(fieldInfoType, fieldInfo);
        }
        if ((fieldConfig = mappingFld.getFieldConfig()) != null) {
            FieldConfigType fieldConfigType = identityMappingFieldType.addNewFieldConfig();
            FieldConfigUtil.saveToBeanDoc(fieldConfigType, fieldConfig);
        }
    }
}

